/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.PooledObjectFactory;
import org.apache.camel.support.service.ServiceSupport;

public abstract class PooledObjectFactorySupport<T>
extends ServiceSupport
implements PooledObjectFactory<T> {
    protected final Object source;
    protected UtilizationStatistics statistics;
    protected CamelContext camelContext;
    protected BlockingQueue<T> pool;
    protected int capacity = 100;
    protected boolean statisticsEnabled;

    public PooledObjectFactorySupport() {
        this.source = null;
    }

    public PooledObjectFactorySupport(Object source) {
        this.source = source;
    }

    @Override
    protected void doBuild() throws Exception {
        super.doBuild();
        if (this.isPooled()) {
            this.pool = new ArrayBlockingQueue<T>(this.capacity);
        }
        if (this.isStatisticsEnabled()) {
            this.statistics = new UtilizationStatistics();
        }
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @Override
    public int getSize() {
        if (this.pool != null) {
            return this.pool.size();
        }
        return 0;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public void resetStatistics() {
        if (this.statistics != null) {
            this.statistics.reset();
        }
    }

    @Override
    public boolean isPooled() {
        return true;
    }

    @Override
    public void purge() {
        if (this.pool != null) {
            this.pool.clear();
        }
    }

    @Override
    public PooledObjectFactory.Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.statistics != null) {
            this.statistics.reset();
            this.statistics = null;
        }
        if (this.pool != null) {
            this.pool.clear();
            this.pool = null;
        }
    }

    protected final class UtilizationStatistics
    implements PooledObjectFactory.Statistics {
        public final LongAdder created = new LongAdder();
        public final LongAdder acquired = new LongAdder();
        public final LongAdder released = new LongAdder();
        public final LongAdder discarded = new LongAdder();

        protected UtilizationStatistics() {
        }

        @Override
        public void reset() {
            this.created.reset();
            this.acquired.reset();
            this.released.reset();
            this.discarded.reset();
        }

        @Override
        public long getCreatedCounter() {
            return this.created.longValue();
        }

        @Override
        public long getAcquiredCounter() {
            return this.acquired.longValue();
        }

        @Override
        public long getReleasedCounter() {
            return this.released.longValue();
        }

        @Override
        public long getDiscardedCounter() {
            return this.discarded.longValue();
        }
    }
}

