/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.language.LanguageConstants;
import org.apache.camel.component.language.LanguageProducer;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;

@UriEndpoint(firstVersion="2.5.0", scheme="language", title="Language", syntax="language:languageName:resourceUri", producerOnly=true, category={Category.CORE, Category.SCRIPT}, headersClass=LanguageConstants.class)
public class LanguageEndpoint
extends ResourceEndpoint {
    private Language language;
    private Expression expression;
    private boolean contentResolvedFromResource;
    @UriPath(enums="bean,constant,csimple,datasonnet,exchangeProperty,file,groovy,header,hl7terser,joor,jq,jsonpath,mvel,ognl,ref,simple,spel,sql,tokenize,xpath,xquery,xtokenize")
    @Metadata(required=true)
    private String languageName;
    @UriPath(description="Path to the resource, or a reference to lookup a bean in the Registry to use as the resource")
    @Metadata(required=false)
    private String resourceUri;
    @UriParam
    private String script;
    @UriParam(defaultValue="true")
    private boolean transform = true;
    @UriParam
    private boolean binary;
    @UriParam
    private boolean cacheScript;
    @UriParam(defaultValue="true", description="Sets whether to use resource content cache or not")
    private boolean contentCache;

    public LanguageEndpoint() {
        this.setContentCache(true);
    }

    public LanguageEndpoint(String endpointUri, Component component, Language language, Expression expression, String resourceUri) {
        super(endpointUri, component, resourceUri);
        this.language = language;
        this.expression = expression;
        this.setContentCache(true);
    }

    @Override
    protected void doInit() throws Exception {
        if (this.language == null && this.languageName != null) {
            this.language = this.getCamelContext().resolveLanguage(this.languageName);
        }
        if (this.cacheScript && this.expression == null && this.script != null) {
            boolean external;
            boolean bl = external = this.script.startsWith("file:") || this.script.startsWith("http:");
            if (!external) {
                this.script = this.resolveScript(this.script);
                this.expression = this.language.createExpression(this.script);
            }
        }
    }

    @Override
    public Producer createProducer() throws Exception {
        if (this.cacheScript && this.expression == null && this.script != null) {
            this.script = this.resolveScript(this.script);
            this.expression = this.language.createExpression(this.script);
        }
        return new LanguageProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Cannot consume to a LanguageEndpoint: " + this.getEndpointUri());
    }

    protected String resolveScript(String script) throws IOException {
        String answer;
        if (ResourceHelper.hasScheme(script)) {
            InputStream is = this.loadResource(script);
            answer = this.getCamelContext().getTypeConverter().convertTo(String.class, is);
            IOHelper.close((Closeable)is);
        } else {
            answer = EndpointHelper.isReferenceParameter(script) ? CamelContextHelper.mandatoryLookup(this.getCamelContext(), script, String.class) : script;
        }
        return answer;
    }

    @Override
    protected String createEndpointUri() {
        String s = this.script;
        try {
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.languageName + ":" + s;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Expression getExpression() {
        if (this.isContentResolvedFromResource() && this.isContentCacheCleared()) {
            return null;
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public boolean isTransform() {
        return this.transform;
    }

    public void setTransform(boolean transform) {
        this.transform = transform;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    @Override
    public void setResourceUri(String resourceUri) {
        super.setResourceUri(resourceUri);
    }

    @Override
    public String getResourceUri() {
        return super.getResourceUri();
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isContentResolvedFromResource() {
        return this.contentResolvedFromResource;
    }

    public void setContentResolvedFromResource(boolean contentResolvedFromResource) {
        this.contentResolvedFromResource = contentResolvedFromResource;
    }

    public boolean isCacheScript() {
        return this.cacheScript;
    }

    public void setCacheScript(boolean cacheScript) {
        this.cacheScript = cacheScript;
    }

    @Override
    public void clearContentCache() {
        super.clearContentCache();
        this.expression = null;
        this.script = null;
    }
}

