/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.iq80.leveldb.impl.Compaction;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.Filename;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.Level;
import org.iq80.leveldb.impl.LogMonitors;
import org.iq80.leveldb.impl.LogReader;
import org.iq80.leveldb.impl.LogWriter;
import org.iq80.leveldb.impl.Logs;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.SeekingIterable;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.impl.Version;
import org.iq80.leveldb.impl.VersionEdit;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.AbstractSeekingIterator;
import org.iq80.leveldb.util.Level0Iterator;
import org.iq80.leveldb.util.MergingIterator;
import org.iq80.leveldb.util.Slice;

public class VersionSet
implements SeekingIterable<InternalKey, Slice> {
    private static final int L0_COMPACTION_TRIGGER = 4;
    public static final int TARGET_FILE_SIZE = 0x200000;
    public static final long MAX_GRAND_PARENT_OVERLAP_BYTES = 0x1400000L;
    private final AtomicLong nextFileNumber = new AtomicLong(2L);
    private long manifestFileNumber = 1L;
    private Version current;
    private long lastSequence;
    private long logNumber;
    private long prevLogNumber;
    private final Map<Version, Object> activeVersions = new MapMaker().weakKeys().makeMap();
    private final File databaseDir;
    private final TableCache tableCache;
    private final InternalKeyComparator internalKeyComparator;
    private LogWriter descriptorLog;
    private final Map<Integer, InternalKey> compactPointers = Maps.newTreeMap();

    public VersionSet(File databaseDir, TableCache tableCache, InternalKeyComparator internalKeyComparator) throws IOException {
        this.databaseDir = databaseDir;
        this.tableCache = tableCache;
        this.internalKeyComparator = internalKeyComparator;
        this.appendVersion(new Version(this));
        this.initializeIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNeeded() throws IOException {
        File currentFile = new File(this.databaseDir, Filename.currentFileName());
        if (!currentFile.exists()) {
            VersionEdit edit = new VersionEdit();
            edit.setComparatorName(this.internalKeyComparator.name());
            edit.setLogNumber(this.prevLogNumber);
            edit.setNextFileNumber(this.nextFileNumber.get());
            edit.setLastSequenceNumber(this.lastSequence);
            try (LogWriter log = Logs.createLogWriter(new File(this.databaseDir, Filename.descriptorFileName(this.manifestFileNumber)), this.manifestFileNumber);){
                this.writeSnapshot(log);
                log.addRecord(edit.encode(), false);
            }
            Filename.setCurrentFile(this.databaseDir, log.getFileNumber());
        }
    }

    public void destroy() throws IOException {
        Version t;
        if (this.descriptorLog != null) {
            this.descriptorLog.close();
            this.descriptorLog = null;
        }
        if ((t = this.current) != null) {
            this.current = null;
            t.release();
        }
        Set<Version> versions = this.activeVersions.keySet();
    }

    private void appendVersion(Version version) {
        Preconditions.checkNotNull(version, "version is null");
        Preconditions.checkArgument(version != this.current, "version is the current version");
        Version previous = this.current;
        this.current = version;
        this.activeVersions.put(version, new Object());
        if (previous != null) {
            previous.release();
        }
    }

    public void removeVersion(Version version) {
        boolean removed;
        Preconditions.checkNotNull(version, "version is null");
        Preconditions.checkArgument(version != this.current, "version is the current version");
        boolean bl = removed = this.activeVersions.remove(version) != null;
        assert (removed) : "Expected the version to still be in the active set";
    }

    public InternalKeyComparator getInternalKeyComparator() {
        return this.internalKeyComparator;
    }

    public TableCache getTableCache() {
        return this.tableCache;
    }

    public Version getCurrent() {
        return this.current;
    }

    public long getManifestFileNumber() {
        return this.manifestFileNumber;
    }

    public long getNextFileNumber() {
        return this.nextFileNumber.getAndIncrement();
    }

    public long getLogNumber() {
        return this.logNumber;
    }

    public long getPrevLogNumber() {
        return this.prevLogNumber;
    }

    public MergingIterator iterator() {
        return this.current.iterator();
    }

    public MergingIterator makeInputIterator(Compaction c) {
        ArrayList<AbstractSeekingIterator> list = Lists.newArrayList();
        for (int which = 0; which < 2; ++which) {
            if (c.getInputs()[which].isEmpty()) continue;
            if (c.getLevel() + which == 0) {
                List<FileMetaData> files = c.getInputs()[which];
                list.add(new Level0Iterator(this.tableCache, files, this.internalKeyComparator));
                continue;
            }
            list.add(Level.createLevelConcatIterator(this.tableCache, c.getInputs()[which], this.internalKeyComparator));
        }
        return new MergingIterator(list, this.internalKeyComparator);
    }

    public LookupResult get(LookupKey key) {
        return this.current.get(key);
    }

    public boolean overlapInLevel(int level, Slice smallestUserKey, Slice largestUserKey) {
        return this.current.overlapInLevel(level, smallestUserKey, largestUserKey);
    }

    public int numberOfFilesInLevel(int level) {
        return this.current.numberOfFilesInLevel(level);
    }

    public long numberOfBytesInLevel(int level) {
        return this.current.numberOfFilesInLevel(level);
    }

    public long getLastSequence() {
        return this.lastSequence;
    }

    public void setLastSequence(long newLastSequence) {
        Preconditions.checkArgument(newLastSequence >= this.lastSequence, "Expected newLastSequence to be greater than or equal to current lastSequence");
        this.lastSequence = newLastSequence;
    }

    public void logAndApply(VersionEdit edit) throws IOException {
        if (edit.getLogNumber() != null) {
            Preconditions.checkArgument(edit.getLogNumber() >= this.logNumber);
            Preconditions.checkArgument(edit.getLogNumber() < this.nextFileNumber.get());
        } else {
            edit.setLogNumber(this.logNumber);
        }
        if (edit.getPreviousLogNumber() == null) {
            edit.setPreviousLogNumber(this.prevLogNumber);
        }
        edit.setNextFileNumber(this.nextFileNumber.get());
        edit.setLastSequenceNumber(this.lastSequence);
        Version version = new Version(this);
        Builder builder = new Builder(this, this.current);
        builder.apply(edit);
        builder.saveTo(version);
        this.finalizeVersion(version);
        boolean createdNewManifest = false;
        try {
            if (this.descriptorLog == null) {
                edit.setNextFileNumber(this.nextFileNumber.get());
                this.descriptorLog = Logs.createLogWriter(new File(this.databaseDir, Filename.descriptorFileName(this.manifestFileNumber)), this.manifestFileNumber);
                this.writeSnapshot(this.descriptorLog);
                createdNewManifest = true;
            }
            Slice record = edit.encode();
            this.descriptorLog.addRecord(record, true);
            if (createdNewManifest) {
                Filename.setCurrentFile(this.databaseDir, this.descriptorLog.getFileNumber());
            }
        }
        catch (IOException e) {
            if (createdNewManifest) {
                this.descriptorLog.close();
                new File(this.databaseDir, Filename.logFileName(this.descriptorLog.getFileNumber())).delete();
                this.descriptorLog = null;
            }
            throw e;
        }
        this.appendVersion(version);
        this.logNumber = edit.getLogNumber();
        this.prevLogNumber = edit.getPreviousLogNumber();
    }

    private void writeSnapshot(LogWriter log) throws IOException {
        VersionEdit edit = new VersionEdit();
        edit.setComparatorName(this.internalKeyComparator.name());
        edit.setCompactPointers(this.compactPointers);
        edit.addFiles(this.current.getFiles());
        Slice record = edit.encode();
        log.addRecord(record, false);
    }

    public void recover() throws IOException {
        File currentFile = new File(this.databaseDir, Filename.currentFileName());
        Preconditions.checkState(currentFile.exists(), "CURRENT file does not exist");
        String currentName = Files.toString(currentFile, Charsets.UTF_8);
        if (currentName.isEmpty() || currentName.charAt(currentName.length() - 1) != '\n') {
            throw new IllegalStateException("CURRENT file does not end with newline");
        }
        currentName = currentName.substring(0, currentName.length() - 1);
        try (FileInputStream fis = new FileInputStream(new File(this.databaseDir, currentName));
             FileChannel fileChannel = fis.getChannel();){
            Long nextFileNumber = null;
            Long lastSequence = null;
            Long logNumber = null;
            Long prevLogNumber = null;
            Builder builder = new Builder(this, this.current);
            LogReader reader = new LogReader(fileChannel, LogMonitors.throwExceptionMonitor(), true, 0L);
            Slice record = reader.readRecord();
            while (record != null) {
                VersionEdit edit = new VersionEdit(record);
                String editComparator = edit.getComparatorName();
                String userComparator = this.internalKeyComparator.name();
                Preconditions.checkArgument(editComparator == null || editComparator.equals(userComparator), "Expected user comparator %s to match existing database comparator ", userComparator, editComparator);
                builder.apply(edit);
                logNumber = VersionSet.coalesce(edit.getLogNumber(), logNumber);
                prevLogNumber = VersionSet.coalesce(edit.getPreviousLogNumber(), prevLogNumber);
                nextFileNumber = VersionSet.coalesce(edit.getNextFileNumber(), nextFileNumber);
                lastSequence = VersionSet.coalesce(edit.getLastSequenceNumber(), lastSequence);
                record = reader.readRecord();
            }
            ArrayList<String> problems = Lists.newArrayList();
            if (nextFileNumber == null) {
                problems.add("Descriptor does not contain a meta-nextfile entry");
            }
            if (logNumber == null) {
                problems.add("Descriptor does not contain a meta-lognumber entry");
            }
            if (lastSequence == null) {
                problems.add("Descriptor does not contain a last-sequence-number entry");
            }
            if (!problems.isEmpty()) {
                throw new RuntimeException("Corruption: \n\t" + Joiner.on("\n\t").join(problems));
            }
            if (prevLogNumber == null) {
                prevLogNumber = 0L;
            }
            Version newVersion = new Version(this);
            builder.saveTo(newVersion);
            this.finalizeVersion(newVersion);
            this.appendVersion(newVersion);
            this.manifestFileNumber = nextFileNumber;
            this.nextFileNumber.set(nextFileNumber + 1L);
            this.lastSequence = lastSequence;
            this.logNumber = logNumber;
            this.prevLogNumber = prevLogNumber;
        }
    }

    private void finalizeVersion(Version version) {
        int bestLevel = -1;
        double bestScore = -1.0;
        for (int level = 0; level < version.numberOfLevels() - 1; ++level) {
            double score;
            if (level == 0) {
                score = 1.0 * (double)version.numberOfFilesInLevel(level) / 4.0;
            } else {
                long levelBytes = 0L;
                for (FileMetaData fileMetaData : version.getFiles(level)) {
                    levelBytes += fileMetaData.getFileSize();
                }
                score = 1.0 * (double)levelBytes / VersionSet.maxBytesForLevel(level);
            }
            if (!(score > bestScore)) continue;
            bestLevel = level;
            bestScore = score;
        }
        version.setCompactionLevel(bestLevel);
        version.setCompactionScore(bestScore);
    }

    private static <V> V coalesce(V ... values) {
        for (V value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public List<FileMetaData> getLiveFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Version activeVersion : this.activeVersions.keySet()) {
            builder.addAll(activeVersion.getFiles().values());
        }
        return builder.build();
    }

    private static double maxBytesForLevel(int level) {
        double result = 1.048576E7;
        while (level > 1) {
            result *= 10.0;
            --level;
        }
        return result;
    }

    public static long maxFileSizeForLevel(int level) {
        return 0x200000L;
    }

    public boolean needsCompaction() {
        return this.current.getCompactionScore() >= 1.0 || this.current.getFileToCompact() != null;
    }

    public Compaction compactRange(int level, InternalKey begin, InternalKey end) {
        List<FileMetaData> levelInputs = this.getOverlappingInputs(level, begin, end);
        if (levelInputs.isEmpty()) {
            return null;
        }
        return this.setupOtherInputs(level, levelInputs);
    }

    public Compaction pickCompaction() {
        List<FileMetaData> levelInputs;
        int level;
        boolean seekCompaction;
        boolean sizeCompaction = this.current.getCompactionScore() >= 1.0;
        boolean bl = seekCompaction = this.current.getFileToCompact() != null;
        if (sizeCompaction) {
            level = this.current.getCompactionLevel();
            Preconditions.checkState(level >= 0);
            Preconditions.checkState(level + 1 < 7);
            levelInputs = Lists.newArrayList();
            for (FileMetaData fileMetaData : this.current.getFiles(level)) {
                if (this.compactPointers.containsKey(level) && this.internalKeyComparator.compare(fileMetaData.getLargest(), this.compactPointers.get(level)) <= 0) continue;
                levelInputs.add(fileMetaData);
                break;
            }
            if (levelInputs.isEmpty()) {
                levelInputs.add(this.current.getFiles(level).get(0));
            }
        } else if (seekCompaction) {
            level = this.current.getFileToCompactLevel();
            levelInputs = ImmutableList.of(this.current.getFileToCompact());
        } else {
            return null;
        }
        if (level == 0) {
            Map.Entry<InternalKey, InternalKey> range = this.getRange(levelInputs);
            Preconditions.checkState(!(levelInputs = this.getOverlappingInputs(0, range.getKey(), range.getValue())).isEmpty());
        }
        Compaction compaction = this.setupOtherInputs(level, levelInputs);
        return compaction;
    }

    private Compaction setupOtherInputs(int level, List<FileMetaData> levelInputs) {
        InternalKey newLimit;
        InternalKey newStart;
        List<FileMetaData> expanded1;
        List<FileMetaData> expanded0;
        Map.Entry<InternalKey, InternalKey> range = this.getRange(levelInputs);
        InternalKey smallest = range.getKey();
        InternalKey largest = range.getValue();
        List<FileMetaData> levelUpInputs = this.getOverlappingInputs(level + 1, smallest, largest);
        range = this.getRange(levelInputs, levelUpInputs);
        InternalKey allStart = range.getKey();
        InternalKey allLimit = range.getValue();
        if (!levelUpInputs.isEmpty() && (expanded0 = this.getOverlappingInputs(level, allStart, allLimit)).size() > levelInputs.size() && (expanded1 = this.getOverlappingInputs(level + 1, newStart = (range = this.getRange(expanded0)).getKey(), newLimit = range.getValue())).size() == levelUpInputs.size()) {
            smallest = newStart;
            largest = newLimit;
            levelInputs = expanded0;
            levelUpInputs = expanded1;
            range = this.getRange(levelInputs, levelUpInputs);
            allStart = range.getKey();
            allLimit = range.getValue();
        }
        List<FileMetaData> grandparents = null;
        if (level + 2 < 7) {
            grandparents = this.getOverlappingInputs(level + 2, allStart, allLimit);
        }
        Compaction compaction = new Compaction(this.current, level, levelInputs, levelUpInputs, grandparents);
        this.compactPointers.put(level, largest);
        compaction.getEdit().setCompactPointer(level, largest);
        return compaction;
    }

    List<FileMetaData> getOverlappingInputs(int level, InternalKey begin, InternalKey end) {
        ImmutableList.Builder files = ImmutableList.builder();
        Slice userBegin = begin.getUserKey();
        Slice userEnd = end.getUserKey();
        UserComparator userComparator = this.internalKeyComparator.getUserComparator();
        for (FileMetaData fileMetaData : this.current.getFiles(level)) {
            if (userComparator.compare(fileMetaData.getLargest().getUserKey(), userBegin) < 0 || userComparator.compare(fileMetaData.getSmallest().getUserKey(), userEnd) > 0) continue;
            files.add(fileMetaData);
        }
        return files.build();
    }

    private Map.Entry<InternalKey, InternalKey> getRange(List<FileMetaData> ... inputLists) {
        InternalKey smallest = null;
        InternalKey largest = null;
        for (List<FileMetaData> inputList : inputLists) {
            for (FileMetaData fileMetaData : inputList) {
                if (smallest == null) {
                    smallest = fileMetaData.getSmallest();
                    largest = fileMetaData.getLargest();
                    continue;
                }
                if (this.internalKeyComparator.compare(fileMetaData.getSmallest(), smallest) < 0) {
                    smallest = fileMetaData.getSmallest();
                }
                if (this.internalKeyComparator.compare(fileMetaData.getLargest(), largest) <= 0) continue;
                largest = fileMetaData.getLargest();
            }
        }
        return Maps.immutableEntry(smallest, largest);
    }

    public long getMaxNextLevelOverlappingBytes() {
        long result = 0L;
        for (int level = 1; level < 7; ++level) {
            for (FileMetaData fileMetaData : this.current.getFiles(level)) {
                List<FileMetaData> overlaps = this.getOverlappingInputs(level + 1, fileMetaData.getSmallest(), fileMetaData.getLargest());
                long totalSize = 0L;
                for (FileMetaData overlap : overlaps) {
                    totalSize += overlap.getFileSize();
                }
                result = Math.max(result, totalSize);
            }
        }
        return result;
    }

    private static class Builder {
        private final VersionSet versionSet;
        private final Version baseVersion;
        private final List<LevelState> levels;

        private Builder(VersionSet versionSet, Version baseVersion) {
            this.versionSet = versionSet;
            this.baseVersion = baseVersion;
            this.levels = Lists.newArrayListWithCapacity(baseVersion.numberOfLevels());
            for (int i = 0; i < baseVersion.numberOfLevels(); ++i) {
                this.levels.add(new LevelState(versionSet.internalKeyComparator));
            }
        }

        public void apply(VersionEdit edit) {
            Integer level;
            for (Map.Entry<Integer, InternalKey> entry : edit.getCompactPointers().entrySet()) {
                level = entry.getKey();
                InternalKey internalKey = entry.getValue();
                this.versionSet.compactPointers.put(level, internalKey);
            }
            for (Map.Entry<Integer, Object> entry : edit.getDeletedFiles().entries()) {
                level = entry.getKey();
                Long fileNumber = (Long)entry.getValue();
                this.levels.get(level).deletedFiles.add(fileNumber);
            }
            for (Map.Entry<Integer, Object> entry : edit.getNewFiles().entries()) {
                level = entry.getKey();
                FileMetaData fileMetaData = (FileMetaData)entry.getValue();
                int allowedSeeks = (int)(fileMetaData.getFileSize() / 16384L);
                if (allowedSeeks < 100) {
                    allowedSeeks = 100;
                }
                fileMetaData.setAllowedSeeks(allowedSeeks);
                this.levels.get(level).deletedFiles.remove(fileMetaData.getNumber());
                this.levels.get(level).addedFiles.add(fileMetaData);
            }
        }

        public void saveTo(Version version) throws IOException {
            FileMetaDataBySmallestKey cmp = new FileMetaDataBySmallestKey(this.versionSet.internalKeyComparator);
            for (int level = 0; level < this.baseVersion.numberOfLevels(); ++level) {
                ImmutableSortedSet addedFiles;
                Collection<FileMetaData> baseFiles = this.baseVersion.getFiles().asMap().get(level);
                if (baseFiles == null) {
                    baseFiles = ImmutableList.of();
                }
                if ((addedFiles = this.levels.get(level).addedFiles) == null) {
                    addedFiles = ImmutableSortedSet.of();
                }
                ArrayList<FileMetaData> sortedFiles = Lists.newArrayListWithCapacity(baseFiles.size() + addedFiles.size());
                sortedFiles.addAll(baseFiles);
                sortedFiles.addAll(addedFiles);
                Collections.sort(sortedFiles, cmp);
                for (FileMetaData fileMetaData : sortedFiles) {
                    this.maybeAddFile(version, level, fileMetaData);
                }
                version.assertNoOverlappingFiles();
            }
        }

        private void maybeAddFile(Version version, int level, FileMetaData fileMetaData) throws IOException {
            if (!this.levels.get(level).deletedFiles.contains(fileMetaData.getNumber())) {
                List<FileMetaData> files = version.getFiles(level);
                if (level > 0 && !files.isEmpty()) {
                    boolean filesOverlap;
                    boolean bl = filesOverlap = this.versionSet.internalKeyComparator.compare(files.get(files.size() - 1).getLargest(), fileMetaData.getSmallest()) >= 0;
                    if (filesOverlap) {
                        throw new IOException(String.format("Compaction is obsolete: Overlapping files %s and %s in level %s", files.get(files.size() - 1).getNumber(), fileMetaData.getNumber(), level));
                    }
                }
                version.addFile(level, fileMetaData);
            }
        }

        private static class LevelState {
            private final SortedSet<FileMetaData> addedFiles;
            private final Set<Long> deletedFiles = new HashSet<Long>();

            public LevelState(InternalKeyComparator internalKeyComparator) {
                this.addedFiles = new TreeSet<FileMetaData>(new FileMetaDataBySmallestKey(internalKeyComparator));
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("LevelState");
                sb.append("{addedFiles=").append(this.addedFiles);
                sb.append(", deletedFiles=").append(this.deletedFiles);
                sb.append('}');
                return sb.toString();
            }
        }

        private static class FileMetaDataBySmallestKey
        implements Comparator<FileMetaData> {
            private final InternalKeyComparator internalKeyComparator;

            private FileMetaDataBySmallestKey(InternalKeyComparator internalKeyComparator) {
                this.internalKeyComparator = internalKeyComparator;
            }

            @Override
            public int compare(FileMetaData f1, FileMetaData f2) {
                return ComparisonChain.start().compare(f1.getSmallest(), f2.getSmallest(), this.internalKeyComparator).compare(f1.getNumber(), f2.getNumber()).result();
            }
        }
    }
}

