/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.InteractivePage;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.HiddenFunctionObject;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.NativeFunctionToStringFunction;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.RecursiveFunctionObject;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptExecutor;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObject;
import com.gargoylesoftware.htmlunit.javascript.host.DateCustom;
import com.gargoylesoftware.htmlunit.javascript.host.Reflect;
import com.gargoylesoftware.htmlunit.javascript.host.StringCustom;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.intl.Intl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.htmlunit.corejs.javascript.BaseFunction;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.IdFunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.UniqueTag;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptEngine {
    private static final Log LOG = LogFactory.getLog(JavaScriptEngine.class);
    private final WebClient webClient_;
    private final HtmlUnitContextFactory contextFactory_;
    private final JavaScriptConfiguration jsConfig_;
    private transient ThreadLocal<Boolean> javaScriptRunning_;
    private transient ThreadLocal<List<PostponedAction>> postponedActions_;
    private transient boolean holdPostponedActions_;
    private transient JavaScriptExecutor javaScriptExecutor_;
    public static final String KEY_STARTING_SCOPE = "startingScope";

    public JavaScriptEngine(WebClient webClient) {
        this.webClient_ = webClient;
        this.contextFactory_ = new HtmlUnitContextFactory(webClient);
        this.initTransientFields();
        this.jsConfig_ = JavaScriptConfiguration.getInstance(webClient.getBrowserVersion());
    }

    public final WebClient getWebClient() {
        return this.webClient_;
    }

    public HtmlUnitContextFactory getContextFactory() {
        return this.contextFactory_;
    }

    public void initialize(final WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                try {
                    JavaScriptEngine.this.init(webWindow, cx);
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception while initializing JavaScript for the page", (Throwable)e);
                    throw new ScriptException(null, (Throwable)e);
                }
                return null;
            }
        };
        this.getContextFactory().call(action);
    }

    public JavaScriptExecutor getJavaScriptExecutor() {
        return this.javaScriptExecutor_;
    }

    private void init(WebWindow webWindow, Context context) throws Exception {
        Scriptable scriptable;
        WebClient webClient = webWindow.getWebClient();
        BrowserVersion browserVersion = webClient.getBrowserVersion();
        HashMap<Class<? extends Scriptable>, Scriptable> prototypes = new HashMap<Class<? extends Scriptable>, Scriptable>();
        HashMap<String, Scriptable> prototypesPerJSName = new HashMap<String, Scriptable>();
        Window window = new Window();
        window.setClassName("Window");
        context.initStandardObjects(window);
        ClassConfiguration windowConfig = this.jsConfig_.getClassConfiguration("Window");
        if (windowConfig.getJsConstructor() != null) {
            RecursiveFunctionObject functionObject = new RecursiveFunctionObject("Window", windowConfig.getJsConstructor(), window);
            ScriptableObject.defineProperty(window, "constructor", functionObject, 7);
        } else {
            JavaScriptEngine.defineConstructor(browserVersion, window, window, new Window());
        }
        JavaScriptEngine.deleteProperties(window, "java", "javax", "org", "com", "edu", "net", "JavaAdapter", "JavaImporter", "Continuation", "Packages", "getClass");
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_XML)) {
            JavaScriptEngine.deleteProperties(window, "XML", "XMLList", "Namespace", "QName");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_Iterator)) {
            JavaScriptEngine.deleteProperties(window, "Iterator", "StopIteration");
        }
        ScriptableObject errorObject = (ScriptableObject)ScriptableObject.getProperty((Scriptable)window, "Error");
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_ERROR_STACK_TRACE_LIMIT)) {
            errorObject.defineProperty("stackTraceLimit", 10, 0);
        } else {
            ScriptableObject.deleteProperty((Scriptable)errorObject, "stackTraceLimit");
        }
        Intl intl = new Intl();
        intl.setParentScope(window);
        window.defineProperty(intl.getClassName(), intl, 2);
        intl.defineProperties(browserVersion);
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_REFLECT)) {
            Reflect reflect = new Reflect();
            reflect.setParentScope(window);
            window.defineProperty(reflect.getClassName(), reflect, 2);
            reflect.defineProperties();
        }
        FallbackCaller fallbackCaller = new FallbackCaller();
        ScriptableObject.getObjectPrototype(window).setPrototype(fallbackCaller);
        for (ClassConfiguration classConfiguration : this.jsConfig_.getAll()) {
            boolean bl = Window.class.getName().equals(classConfiguration.getHostClass().getName());
            if (bl) {
                JavaScriptEngine.configureConstantsPropertiesAndFunctions(classConfiguration, window, browserVersion);
                HtmlUnitScriptable prototype = JavaScriptEngine.configureClass(classConfiguration, window, browserVersion);
                prototypesPerJSName.put(classConfiguration.getClassName(), prototype);
                continue;
            }
            HtmlUnitScriptable prototype2 = JavaScriptEngine.configureClass(classConfiguration, window, browserVersion);
            if (classConfiguration.isJsObject()) {
                HtmlUnitScriptable obj = classConfiguration.getHostClass().newInstance();
                prototype2.defineProperty("__proto__", prototype2, 2);
                obj.defineProperty("prototype", prototype2, 2);
                obj.setParentScope(window);
                obj.setClassName(classConfiguration.getClassName());
                ScriptableObject.defineProperty(window, obj.getClassName(), obj, 2);
                JavaScriptEngine.configureConstants(classConfiguration, obj);
            }
            prototypes.put(classConfiguration.getHostClass(), prototype2);
            prototypesPerJSName.put(classConfiguration.getClassName(), prototype2);
        }
        for (ClassConfiguration classConfiguration : this.jsConfig_.getAll()) {
            Member member = classConfiguration.getJsConstructor();
            String jsClassName = classConfiguration.getClassName();
            Scriptable prototype3 = (Scriptable)prototypesPerJSName.get(jsClassName);
            String hostClassSimpleName = classConfiguration.getHostClassSimpleName();
            if ("Image".equals(hostClassSimpleName) && browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_PROTOTYPE_SAME_AS_HTML_IMAGE)) {
                prototype3 = (Scriptable)prototypesPerJSName.get("HTMLImageElement");
            }
            if ("Option".equals(hostClassSimpleName) && browserVersion.hasFeature(BrowserVersionFeatures.JS_OPTION_PROTOTYPE_SAME_AS_HTML_OPTION)) {
                prototype3 = (Scriptable)prototypesPerJSName.get("HTMLOptionElement");
            }
            switch (hostClassSimpleName) {
                case "WebKitAnimationEvent": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("AnimationEvent");
                    break;
                }
                case "WebKitMutationObserver": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("MutationObserver");
                    break;
                }
                case "WebKitTransitionEvent": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("TransitionEvent");
                    break;
                }
                case "webkitAudioContext": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("AudioContext");
                    break;
                }
                case "webkitIDBCursor": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("IDBCursor");
                    break;
                }
                case "webkitIDBDatabase": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("IDBDatabase");
                    break;
                }
                case "webkitIDBFactory": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("IDBFactory");
                    break;
                }
                case "webkitIDBIndex": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("IDBIndex");
                    break;
                }
                case "webkitIDBKeyRange": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("IDBKeyRange");
                    break;
                }
                case "webkitIDBObjectStore": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("IDBObjectStore");
                    break;
                }
                case "webkitIDBRequest": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("IDBRequest");
                    break;
                }
                case "webkitIDBTransaction": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("IDBTransaction");
                    break;
                }
                case "webkitOfflineAudioContext": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("OfflineAudioContext");
                    break;
                }
                case "webkitURL": {
                    prototype3 = (Scriptable)prototypesPerJSName.get("URL");
                    break;
                }
            }
            if (prototype3 == null || !classConfiguration.isJsObject()) continue;
            if (member == null) {
                ScriptableObject constructor;
                if ("Window".equals(jsClassName)) {
                    constructor = (ScriptableObject)ScriptableObject.getProperty((Scriptable)window, "constructor");
                } else {
                    constructor = classConfiguration.getHostClass().newInstance();
                    ((SimpleScriptable)constructor).setClassName(classConfiguration.getClassName());
                }
                JavaScriptEngine.defineConstructor(browserVersion, window, prototype3, constructor);
                JavaScriptEngine.configureConstantsStaticPropertiesAndStaticFunctions(classConfiguration, constructor, browserVersion);
                continue;
            }
            BaseFunction function = "Window".equals(jsClassName) ? (BaseFunction)ScriptableObject.getProperty((Scriptable)window, "constructor") : new RecursiveFunctionObject(jsClassName, member, window);
            if ("WebKitAnimationEvent".equals(hostClassSimpleName) || "WebKitMutationObserver".equals(hostClassSimpleName) || "WebKitTransitionEvent".equals(hostClassSimpleName) || "webkitAudioContext".equals(hostClassSimpleName) || "webkitIDBCursor".equals(hostClassSimpleName) || "webkitIDBDatabase".equals(hostClassSimpleName) || "webkitIDBFactory".equals(hostClassSimpleName) || "webkitIDBIndex".equals(hostClassSimpleName) || "webkitIDBKeyRange".equals(hostClassSimpleName) || "webkitIDBObjectStore".equals(hostClassSimpleName) || "webkitIDBRequest".equals(hostClassSimpleName) || "webkitIDBTransaction".equals(hostClassSimpleName) || "webkitOfflineAudioContext".equals(hostClassSimpleName) || "webkitURL".equals(hostClassSimpleName) || "Image".equals(hostClassSimpleName) || "Option".equals(hostClassSimpleName)) {
                Object prototypeProperty = ScriptableObject.getProperty((Scriptable)window, prototype3.getClassName());
                if (function instanceof FunctionObject) {
                    ((FunctionObject)function).addAsConstructor(window, prototype3);
                }
                ScriptableObject.defineProperty(window, hostClassSimpleName, function, 2);
                if (!hostClassSimpleName.equals(prototype3.getClassName())) {
                    if (prototypeProperty == UniqueTag.NOT_FOUND) {
                        ScriptableObject.deleteProperty((Scriptable)window, prototype3.getClassName());
                    } else {
                        ScriptableObject.defineProperty(window, prototype3.getClassName(), prototypeProperty, 2);
                    }
                }
            } else if (function instanceof FunctionObject) {
                ((FunctionObject)function).addAsConstructor(window, prototype3);
            }
            JavaScriptEngine.configureConstantsStaticPropertiesAndStaticFunctions(classConfiguration, function, browserVersion);
        }
        window.setPrototype((Scriptable)prototypesPerJSName.get(Window.class.getSimpleName()));
        Scriptable objectPrototype = ScriptableObject.getObjectPrototype(window);
        for (Map.Entry entry : prototypesPerJSName.entrySet()) {
            String name = (String)entry.getKey();
            ClassConfiguration config = this.jsConfig_.getClassConfiguration(name);
            Scriptable prototype4 = (Scriptable)entry.getValue();
            if (!StringUtils.isEmpty(config.getExtendedClassName())) {
                Scriptable parentPrototype = (Scriptable)prototypesPerJSName.get(config.getExtendedClassName());
                prototype4.setPrototype(parentPrototype);
                continue;
            }
            prototype4.setPrototype(objectPrototype);
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_WINDOW_ACTIVEXOBJECT_HIDDEN) && null != (scriptable = (Scriptable)prototypesPerJSName.get("ActiveXObject"))) {
            Method method = ActiveXObject.class.getDeclaredMethod("jsConstructor", Context.class, Object[].class, Function.class, Boolean.TYPE);
            HiddenFunctionObject functionObject = new HiddenFunctionObject("ActiveXObject", method, window);
            functionObject.addAsConstructor(window, scriptable);
        }
        JavaScriptEngine.removePrototypeProperties(window, "String", "equals", "equalsIgnoreCase");
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_INCLUDES)) {
            JavaScriptEngine.removePrototypeProperties(window, "String", "includes");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_REPEAT)) {
            JavaScriptEngine.removePrototypeProperties(window, "String", "repeat");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_STARTS_ENDS_WITH)) {
            JavaScriptEngine.removePrototypeProperties(window, "String", "startsWith");
            JavaScriptEngine.removePrototypeProperties(window, "String", "endsWith");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_TRIM_LEFT_RIGHT)) {
            JavaScriptEngine.removePrototypeProperties(window, "String", "trimLeft");
            JavaScriptEngine.removePrototypeProperties(window, "String", "trimRight");
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.STRING_CONTAINS)) {
            ScriptableObject scriptableObject = (ScriptableObject)ScriptableObject.getClassPrototype(window, "String");
            scriptableObject.defineFunctionProperties(new String[]{"contains"}, StringCustom.class, 0);
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_FUNCTION_TOSOURCE)) {
            JavaScriptEngine.deleteProperties(window, "uneval");
            JavaScriptEngine.removePrototypeProperties(window, "Object", "toSource");
            JavaScriptEngine.removePrototypeProperties(window, "Array", "toSource");
            JavaScriptEngine.removePrototypeProperties(window, "Date", "toSource");
            JavaScriptEngine.removePrototypeProperties(window, "Function", "toSource");
            JavaScriptEngine.removePrototypeProperties(window, "Number", "toSource");
            JavaScriptEngine.removePrototypeProperties(window, "String", "toSource");
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_WINDOW_ACTIVEXOBJECT_HIDDEN)) {
            ((IdFunctionObject)ScriptableObject.getProperty((Scriptable)window, "Object")).delete("assign");
        }
        JavaScriptEngine.deleteProperties(window, "isXMLName");
        NativeFunctionToStringFunction.installFix(window, webClient.getBrowserVersion());
        ScriptableObject scriptableObject = (ScriptableObject)ScriptableObject.getClassPrototype(window, "Date");
        scriptableObject.defineFunctionProperties(new String[]{"toLocaleDateString", "toLocaleTimeString"}, DateCustom.class, 2);
        window.setPrototypes(prototypes, prototypesPerJSName);
        window.initialize(webWindow);
    }

    private static void defineConstructor(BrowserVersion browserVersion, Window window, Scriptable prototype, ScriptableObject constructor) {
        constructor.setParentScope(window);
        ScriptableObject.defineProperty(prototype, "constructor", constructor, 7);
        ScriptableObject.defineProperty(constructor, "prototype", prototype, 7);
        window.defineProperty(constructor.getClassName(), constructor, 2);
    }

    private static void deleteProperties(Scriptable scope, String ... propertiesToDelete) {
        for (String property : propertiesToDelete) {
            scope.delete(property);
        }
    }

    private static void removePrototypeProperties(Scriptable scope, String className, String ... properties) {
        ScriptableObject prototype = (ScriptableObject)ScriptableObject.getClassPrototype(scope, className);
        for (String property : properties) {
            prototype.delete(property);
        }
    }

    public static HtmlUnitScriptable configureClass(ClassConfiguration config, Scriptable window, BrowserVersion browserVersion) throws InstantiationException, IllegalAccessException {
        HtmlUnitScriptable prototype = config.getHostClass().newInstance();
        prototype.setParentScope(window);
        prototype.setClassName(config.getClassName());
        JavaScriptEngine.configureConstantsPropertiesAndFunctions(config, prototype, browserVersion);
        return prototype;
    }

    private static void configureConstantsStaticPropertiesAndStaticFunctions(ClassConfiguration config, ScriptableObject scriptable, BrowserVersion browserVersion) {
        JavaScriptEngine.configureConstants(config, scriptable);
        JavaScriptEngine.configureStaticProperties(config, browserVersion, scriptable);
        JavaScriptEngine.configureStaticFunctions(config, scriptable);
    }

    private static void configureConstantsPropertiesAndFunctions(ClassConfiguration config, ScriptableObject scriptable, BrowserVersion browserVersion) {
        JavaScriptEngine.configureConstants(config, scriptable);
        JavaScriptEngine.configureProperties(config, scriptable);
        JavaScriptEngine.configureFunctions(config, browserVersion, scriptable);
    }

    private static void configureFunctions(ClassConfiguration config, BrowserVersion browserVersion, ScriptableObject scriptable) {
        boolean attributes = false;
        for (Map.Entry<String, Method> functionInfo : config.getFunctionEntries()) {
            String functionName = functionInfo.getKey();
            Method method = functionInfo.getValue();
            FunctionObject functionObject = new FunctionObject(functionName, method, scriptable);
            scriptable.defineProperty(functionName, functionObject, 0);
        }
    }

    private static void configureConstants(ClassConfiguration config, ScriptableObject scriptable) {
        for (ClassConfiguration.ConstantInfo constantInfo : config.getConstants()) {
            scriptable.defineProperty(constantInfo.getName(), constantInfo.getValue(), constantInfo.getFlag());
        }
    }

    private static void configureProperties(ClassConfiguration config, ScriptableObject scriptable) {
        Map<String, ClassConfiguration.PropertyInfo> propertyMap = config.getPropertyMap();
        for (String propertyName : propertyMap.keySet()) {
            ClassConfiguration.PropertyInfo info = propertyMap.get(propertyName);
            Method readMethod = info.getReadMethod();
            Method writeMethod = info.getWriteMethod();
            scriptable.defineProperty(propertyName, null, readMethod, writeMethod, 0);
        }
    }

    private static void configureStaticProperties(ClassConfiguration config, BrowserVersion browserVersion, ScriptableObject scriptable) {
        for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : config.getStaticPropertyEntries()) {
            String propertyName = propertyEntry.getKey();
            Method readMethod = propertyEntry.getValue().getReadMethod();
            Method writeMethod = propertyEntry.getValue().getWriteMethod();
            boolean flag = false;
            scriptable.defineProperty(propertyName, null, readMethod, writeMethod, 0);
        }
    }

    private static void configureStaticFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        for (Map.Entry<String, Method> staticfunctionInfo : config.getStaticFunctionEntries()) {
            String functionName = staticfunctionInfo.getKey();
            Method method = staticfunctionInfo.getValue();
            FunctionObject staticFunctionObject = new FunctionObject(functionName, method, scriptable);
            scriptable.defineProperty(functionName, staticFunctionObject, 0);
        }
    }

    public synchronized void registerWindowAndMaybeStartEventLoop(WebWindow webWindow) {
        if (this.javaScriptExecutor_ == null) {
            this.javaScriptExecutor_ = BackgroundJavaScriptFactory.theFactory().createJavaScriptExecutor(this.webClient_);
        }
        this.javaScriptExecutor_.addWindow(webWindow);
    }

    public int pumpEventLoop(long timeoutMillis) {
        if (this.javaScriptExecutor_ == null) {
            return 0;
        }
        return this.javaScriptExecutor_.pumpEventLoop(timeoutMillis);
    }

    public void shutdown() {
        if (this.javaScriptExecutor_ != null) {
            this.javaScriptExecutor_.shutdown();
            this.javaScriptExecutor_ = null;
        }
        if (this.postponedActions_ != null) {
            this.postponedActions_.remove();
        }
        if (this.javaScriptRunning_ != null) {
            this.javaScriptRunning_.remove();
        }
        this.holdPostponedActions_ = false;
    }

    public Script compile(InteractivePage page, String sourceCode, String sourceName, int startLine) {
        Scriptable scope = JavaScriptEngine.getScope(page, null);
        return this.compile(page, scope, sourceCode, sourceName, startLine);
    }

    public Script compile(InteractivePage owningPage, Scriptable scope, String sourceCode, final String sourceName, final int startLine) {
        WebAssert.notNull("sourceCode", sourceCode);
        if (LOG.isTraceEnabled()) {
            String newline = System.getProperty("line.separator");
            LOG.trace((Object)("Javascript compile " + sourceName + newline + sourceCode + newline));
        }
        final String source = sourceCode;
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, owningPage){

            @Override
            public Object doRun(Context cx) {
                return cx.compileString(source, sourceName, startLine, null);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return source;
            }
        };
        return (Script)this.getContextFactory().call(action);
    }

    public Object execute(InteractivePage page, String sourceCode, String sourceName, int startLine) {
        Script script = this.compile(page, sourceCode, sourceName, startLine);
        if (script == null) {
            return null;
        }
        return this.execute(page, script);
    }

    public Object execute(InteractivePage page, Script script) {
        Scriptable scope = JavaScriptEngine.getScope(page, null);
        return this.execute(page, scope, script);
    }

    public Object execute(InteractivePage page, final Scriptable scope, final Script script) {
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, page){

            @Override
            public Object doRun(Context cx) {
                return script.exec(cx, scope);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return null;
            }
        };
        return this.getContextFactory().call(action);
    }

    public Object callFunction(InteractivePage page, Function javaScriptFunction, Scriptable thisObject, Object[] args, DomNode node) {
        Scriptable scope = JavaScriptEngine.getScope(page, node);
        return this.callFunction(page, javaScriptFunction, scope, thisObject, args);
    }

    public Object callFunction(InteractivePage page, final Function function, final Scriptable scope, final Scriptable thisObject, final Object[] args) {
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, page){

            @Override
            public Object doRun(Context cx) {
                if (ScriptRuntime.hasTopCall(cx)) {
                    return function.call(cx, scope, thisObject, args);
                }
                return ScriptRuntime.doTopCall(function, cx, scope, thisObject, args);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return cx.decompileFunction(function, 2);
            }
        };
        return this.getContextFactory().call(action);
    }

    private static Scriptable getScope(InteractivePage page, DomNode node) {
        if (node != null) {
            return node.getScriptableObject();
        }
        return page.getEnclosingWindow().getScriptableObject();
    }

    public boolean isScriptRunning() {
        return Boolean.TRUE.equals(this.javaScriptRunning_.get());
    }

    private void doProcessPostponedActions() {
        this.holdPostponedActions_ = false;
        try {
            this.getWebClient().loadDownloadedResponses();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<PostponedAction> actions2 = this.postponedActions_.get();
        if (actions2 != null) {
            this.postponedActions_.set(null);
            try {
                for (PostponedAction action : actions2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Processing PostponedAction " + action));
                    }
                    if (!action.isStillAlive()) continue;
                    action.execute();
                }
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx(e);
            }
        }
    }

    public void addPostponedAction(PostponedAction action) {
        List<PostponedAction> actions2 = this.postponedActions_.get();
        if (actions2 == null) {
            actions2 = new ArrayList<PostponedAction>();
            this.postponedActions_.set(actions2);
        }
        actions2.add(action);
    }

    protected void handleJavaScriptException(ScriptException scriptException, boolean triggerOnError) {
        Window w;
        WebWindow window;
        InteractivePage page = scriptException.getPage();
        if (triggerOnError && page != null && (window = page.getEnclosingWindow()) != null && (w = (Window)window.getScriptableObject()) != null) {
            try {
                w.triggerOnError(scriptException);
            }
            catch (Exception e) {
                this.handleJavaScriptException(new ScriptException(page, e, null), false);
            }
        }
        this.getWebClient().getJavaScriptErrorListener().scriptException(page, scriptException);
        if (this.getWebClient().getOptions().isThrowExceptionOnScriptError()) {
            throw scriptException;
        }
        LOG.info((Object)"Caught script exception", (Throwable)scriptException);
    }

    public void holdPosponedActions() {
        this.holdPostponedActions_ = true;
    }

    public void processPostponedActions() {
        this.doProcessPostponedActions();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.javaScriptRunning_ = new ThreadLocal();
        this.postponedActions_ = new ThreadLocal();
        this.holdPostponedActions_ = false;
    }

    public Class<? extends HtmlUnitScriptable> getJavaScriptClass(Class<?> c) {
        return this.jsConfig_.getDomJavaScriptMapping().get(c);
    }

    public JavaScriptConfiguration getJavaScriptConfiguration() {
        return this.jsConfig_;
    }

    public long getJavaScriptTimeout() {
        return this.getContextFactory().getTimeout();
    }

    public void setJavaScriptTimeout(long timeout) {
        this.getContextFactory().setTimeout(timeout);
    }

    private static class FallbackCaller
    extends ScriptableObject {
        private FallbackCaller() {
        }

        @Override
        public Object get(String name, Scriptable start) {
            if (start instanceof ScriptableWithFallbackGetter) {
                return ((ScriptableWithFallbackGetter)start).getWithFallback(name);
            }
            return NOT_FOUND;
        }

        @Override
        public String getClassName() {
            return "htmlUnitHelper-fallbackCaller";
        }
    }

    private abstract class HtmlUnitContextAction
    implements ContextAction {
        private final Scriptable scope_;
        private final InteractivePage page_;

        HtmlUnitContextAction(Scriptable scope, InteractivePage page) {
            this.scope_ = scope;
            this.page_ = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Object run(Context cx) {
            Boolean javaScriptAlreadyRunning = (Boolean)JavaScriptEngine.this.javaScriptRunning_.get();
            JavaScriptEngine.this.javaScriptRunning_.set(Boolean.TRUE);
            try {
                Object response;
                Object object;
                Stack<Scriptable> stack = (Stack<Scriptable>)cx.getThreadLocal(JavaScriptEngine.KEY_STARTING_SCOPE);
                if (null == stack) {
                    stack = new Stack<Scriptable>();
                    cx.putThreadLocal(JavaScriptEngine.KEY_STARTING_SCOPE, stack);
                }
                stack.push(this.scope_);
                try {
                    object = this.page_;
                    synchronized (object) {
                        block19: {
                            if (this.page_ == this.page_.getEnclosingWindow().getEnclosedPage()) break block19;
                            Object var6_7 = null;
                            return var6_7;
                        }
                        response = this.doRun(cx);
                    }
                }
                finally {
                    stack.pop();
                }
                if (!JavaScriptEngine.this.holdPostponedActions_) {
                    JavaScriptEngine.this.doProcessPostponedActions();
                }
                object = response;
                return object;
            }
            catch (Exception e) {
                JavaScriptEngine.this.handleJavaScriptException(new ScriptException(this.page_, e, this.getSourceCode(cx)), true);
                Object var4_9 = null;
                return var4_9;
            }
            catch (TimeoutError e) {
                JavaScriptEngine.this.getWebClient().getJavaScriptErrorListener().timeoutError(this.page_, e.getAllowedTime(), e.getExecutionTime());
                if (JavaScriptEngine.this.getWebClient().getOptions().isThrowExceptionOnScriptError()) {
                    throw new RuntimeException(e);
                }
                LOG.info((Object)"Caught script timeout error", (Throwable)e);
                Object var4_10 = null;
                return var4_10;
            }
            finally {
                JavaScriptEngine.this.javaScriptRunning_.set(javaScriptAlreadyRunning);
            }
        }

        protected abstract Object doRun(Context var1);

        protected abstract String getSourceCode(Context var1);
    }
}

