/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(domClass=HtmlScript.class)
public class HTMLScriptElement
extends HTMLElement {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLScriptElement() {
    }

    @JsxGetter
    public String getSrc() {
        HtmlScript tmpScript = (HtmlScript)this.getDomNodeOrDie();
        String src = tmpScript.getSrcAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED == src) {
            return src;
        }
        try {
            URL expandedSrc = ((HtmlPage)tmpScript.getPage()).getFullyQualifiedUrl(src);
            src = expandedSrc.toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return src;
    }

    @JsxSetter
    public void setSrc(String src) {
        this.getDomNodeOrDie().setAttribute("src", src);
    }

    @JsxGetter
    public String getText() {
        StringBuilder scriptCode = new StringBuilder();
        for (DomNode node : this.getDomNodeOrDie().getChildren()) {
            if (!(node instanceof DomText)) continue;
            DomText domText = (DomText)node;
            scriptCode.append(domText.getData());
        }
        return scriptCode.toString();
    }

    @JsxSetter
    public void setText(String text) {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        htmlElement.removeAllChildren();
        DomText textChild = new DomText(htmlElement.getPage(), text);
        htmlElement.appendChild(textChild);
        HtmlScript tmpScript = (HtmlScript)htmlElement;
        tmpScript.executeScriptIfNeeded();
    }

    @JsxGetter
    public String getType() {
        return this.getDomNodeOrDie().getAttribute("type");
    }

    @JsxSetter
    public void setType(String type) {
        this.getDomNodeOrDie().setAttribute("type", type);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getOnreadystatechange() {
        return this.getEventHandlerProp("onreadystatechange");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setOnreadystatechange(Object handler) {
        this.setEventHandlerProp("onreadystatechange", handler);
    }

    @JsxGetter
    public Object getOnload() {
        return this.getEventHandlerProp("onload");
    }

    @JsxSetter
    public void setOnload(Object handler) {
        this.setEventHandlerProp("onload", handler);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getReadyState() {
        HtmlScript tmpScript = (HtmlScript)this.getDomNodeOrDie();
        if (tmpScript.wasCreatedByJavascript()) {
            return Undefined.instance;
        }
        return tmpScript.getReadyState();
    }

    @Override
    public Object appendChild(Object childObject) {
        HtmlScript tmpScript = (HtmlScript)this.getDomNodeOrDie();
        boolean wasEmpty = tmpScript.getFirstChild() == null;
        Object result = super.appendChild(childObject);
        if (wasEmpty) {
            tmpScript.executeScriptIfNeeded();
        }
        return result;
    }

    @JsxGetter
    public boolean getAsync() {
        return this.getDomNodeOrDie().hasAttribute("async");
    }

    @JsxSetter
    public void setAsync(boolean async) {
        if (async) {
            this.getDomNodeOrDie().setAttribute("async", "");
        } else {
            this.getDomNodeOrDie().removeAttribute("async");
        }
    }
}

