/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin;

import java.util.Arrays;
import java.util.Map;
import org.apache.camel.component.linkedin.api.OAuthScope;
import org.apache.camel.component.linkedin.api.OAuthSecureStorage;
import org.apache.camel.component.linkedin.internal.LinkedInApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@UriParams
public class LinkedInConfiguration {
    @UriPath(enums="comments,companies,groups,jobs,people,posts,search")
    @Metadata(required="true")
    private LinkedInApiName apiName;
    @UriPath(enums="addActivity,addComment,addCompanyUpdateComment,addCompanyUpdateCommentAsCompany,addGroupMembership,addInvite,addJob,addJobBookmark,addPost,addShare,addUpdateComment,editJob,flagCategory,followCompany,followPost,getComment,getCompanies,getCompanyById,getCompanyByName,getCompanyUpdateComments,getCompanyUpdateLikes,getCompanyUpdates,getConnections,getConnectionsById,getConnectionsByUrl,getFollowedCompanies,getGroup,getGroupMemberships,getGroupMembershipSettings,getHistoricalFollowStatistics,getHistoricalStatusUpdateStatistics,getJob,getJobBookmarks,getNetworkStats,getNetworkUpdates,getNetworkUpdatesById,getNumberOfFollowers,getPerson,getPersonById,getPersonByUrl,getPost,getPostComments,getPosts,getStatistics,getSuggestedCompanies,getSuggestedGroupPosts,getSuggestedGroups,getSuggestedJobs,getUpdateComments,getUpdateLikes,isShareEnabled,isViewerShareEnabled,likeCompanyUpdate,likePost,likeUpdate,removeComment,removeGroupMembership,removeGroupSuggestion,removeJob,removeJobBookmark,removePost,searchCompanies,searchJobs,searchPeople,share,stopFollowingCompany,updateGroupMembership")
    @Metadata(required="true")
    private String methodName;
    @UriParam
    private String userName;
    @UriParam
    private String userPassword;
    @UriParam
    private OAuthSecureStorage secureStorage;
    @UriParam
    private String accessToken;
    @UriParam
    private Long expiryTime;
    @UriParam
    private String clientId;
    @UriParam
    private String clientSecret;
    @UriParam
    private OAuthScope[] scopes;
    @UriParam
    private String redirectUri;
    @UriParam
    private Map<String, Object> httpParams;
    @UriParam(defaultValue="true")
    private boolean lazyAuth = true;

    public LinkedInApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(LinkedInApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public OAuthSecureStorage getSecureStorage() {
        return this.secureStorage;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public Long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(Long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public void setSecureStorage(OAuthSecureStorage secureStorage) {
        this.secureStorage = secureStorage;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuthScope[] getScopes() {
        return this.scopes;
    }

    public void setScopes(OAuthScope[] scopes) {
        this.scopes = scopes;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public Map<String, Object> getHttpParams() {
        return this.httpParams;
    }

    public void setHttpParams(Map<String, Object> httpParams) {
        this.httpParams = httpParams;
    }

    public boolean isLazyAuth() {
        return this.lazyAuth;
    }

    public void setLazyAuth(boolean lazyAuth) {
        this.lazyAuth = lazyAuth;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkedInConfiguration) {
            LinkedInConfiguration other = (LinkedInConfiguration)obj;
            return (this.userName == null ? other.userName == null : this.userName.equals(other.userName)) && (this.userPassword == null ? other.userPassword == null : this.userPassword.equals(other.userPassword)) && this.secureStorage == other.secureStorage && (this.clientId == null ? other.clientId == null : this.clientId.equals(other.clientId)) && (this.clientSecret == null ? other.clientSecret == null : this.clientSecret.equals(other.clientSecret)) && (this.redirectUri == null ? other.redirectUri == null : this.redirectUri.equals(other.redirectUri)) && Arrays.equals((Object[])this.scopes, (Object[])other.scopes) && (this.httpParams == null ? other.httpParams == null : this.httpParams.equals(other.httpParams)) && this.lazyAuth == other.lazyAuth;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.userName).append(this.userPassword).append(this.secureStorage).append(this.clientId).append(this.clientSecret).append(this.redirectUri).append((Object[])this.scopes).append(this.httpParams).append(this.lazyAuth).toHashCode();
    }

    public void validate() throws IllegalArgumentException {
        ObjectHelper.notEmpty((String)this.userName, (String)"userName");
        if (ObjectHelper.isEmpty((Object)this.userPassword) && this.secureStorage == null) {
            throw new IllegalArgumentException("Property userPassword or secureStorage is required");
        }
        ObjectHelper.notEmpty((String)this.clientId, (String)"clientId");
        ObjectHelper.notEmpty((String)this.clientSecret, (String)"clientSecret");
        ObjectHelper.notEmpty((String)this.redirectUri, (String)"redirectUri");
    }
}

