/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin.internal;

import org.apache.camel.component.linkedin.api.OAuthSecureStorage;
import org.apache.camel.component.linkedin.api.OAuthToken;

public class CachingOAuthSecureStorage
implements OAuthSecureStorage {
    protected OAuthToken token;
    private final OAuthSecureStorage secureStorage;

    public CachingOAuthSecureStorage(OAuthSecureStorage secureStorage) {
        this.secureStorage = secureStorage;
    }

    @Override
    public OAuthToken getOAuthToken() {
        if (this.secureStorage != null && (this.token == null || this.token.getExpiryTime() < System.currentTimeMillis())) {
            this.token = this.secureStorage.getOAuthToken();
        }
        return this.token;
    }

    @Override
    public void saveOAuthToken(OAuthToken newToken) {
        this.token = newToken;
        if (this.secureStorage != null) {
            this.secureStorage.saveOAuthToken(newToken);
        }
    }
}

