/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.aegis;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.aegis.AegisContext;

public abstract class AbstractAegisProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private static Map<Type, AegisContext> classContexts = new WeakHashMap<Type, AegisContext>();
    protected boolean writeXsiType = true;
    protected boolean readXsiType = true;
    @Context
    protected ContextResolver<AegisContext> resolver;

    public void setWriteXsiType(boolean write) {
        this.writeXsiType = write;
    }

    public void setReadXsiType(boolean read) {
        this.readXsiType = read;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return this.isSupported(type, genericType, anns);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.isSupported(type, genericType, annotations);
    }

    @Override
    public long getSize(T o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    protected AegisContext getAegisContext(Class<?> plainClass, Type genericType) {
        AegisContext context;
        if (this.resolver != null && (context = this.resolver.getContext(plainClass)) != null) {
            return context;
        }
        if (genericType == null) {
            genericType = plainClass;
        }
        return this.getClassContext(genericType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AegisContext getClassContext(Type reflectionType) {
        Map<Type, AegisContext> map = classContexts;
        synchronized (map) {
            AegisContext context = classContexts.get(reflectionType);
            if (context == null) {
                context = new AegisContext();
                context.setWriteXsiTypes(this.writeXsiType);
                context.setReadXsiTypes(this.readXsiType);
                HashSet<Type> rootClasses = new HashSet<Type>();
                rootClasses.add(reflectionType);
                context.setRootClasses(rootClasses);
                context.initialize();
                classContexts.put(reflectionType, context);
            }
            return context;
        }
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] annotations) {
        return true;
    }

    static void clearContexts() {
        classContexts.clear();
    }
}

