/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.jsrjsonp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Produces(value={"application/json", "application/*+json"})
@Consumes(value={"application/json", "application/*+json"})
@Provider
public class JsrJsonpProvider
implements MessageBodyReader<JsonStructure>,
MessageBodyWriter<JsonStructure> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonStructure.class.isAssignableFrom(type) || JsonObject.class.isAssignableFrom(type) || JsonArray.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(JsonStructure t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(JsonStructure t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (entityStream == null) {
            throw new IOException("Initialized OutputStream should be provided");
        }
        try (JsonWriter writer = null;){
            writer = Json.createWriter((OutputStream)entityStream);
            writer.write(t);
        }
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonStructure.class.isAssignableFrom(type) || JsonObject.class.isAssignableFrom(type) || JsonArray.class.isAssignableFrom(type);
    }

    @Override
    public JsonStructure readFrom(Class<JsonStructure> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        if (entityStream == null) {
            throw new IOException("Initialized InputStream should be provided");
        }
        try (JsonReader reader = null;){
            reader = Json.createReader((InputStream)entityStream);
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
    }
}

