/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.common;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public final class JoseUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(JoseUtils.class);
    private static final String CLASSPATH_PREFIX = "classpath:";

    private JoseUtils() {
    }

    public static String[] getCompactParts(String compactContent) {
        if (compactContent.startsWith("\"") && compactContent.endsWith("\"")) {
            compactContent = compactContent.substring(1, compactContent.length() - 1);
        }
        return StringUtils.split(compactContent, "\\.");
    }

    public static void setJoseContextProperty(JoseHeaders headers) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        String context = (String)message.get("org.apache.cxf.jose.context");
        if (context != null) {
            headers.setHeader("org.apache.cxf.jose.context", context);
        }
    }

    public static void setJoseMessageContextProperty(JoseHeaders headers, String value) {
        headers.setHeader("org.apache.cxf.jose.context", value);
        Message message = PhaseInterceptorChain.getCurrentMessage();
        message.put("org.apache.cxf.jose.context", value);
    }

    public static void setMessageContextProperty(JoseHeaders headers) {
        String context = (String)headers.getHeader("org.apache.cxf.jose.context");
        if (context != null) {
            Message message = PhaseInterceptorChain.getCurrentMessage();
            message.put("org.apache.cxf.jose.context", context);
        }
    }

    public static void validateRequestContextProperty(JoseHeaders headers) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        Object requestContext = message.get("org.apache.cxf.jose.context");
        Object headerContext = headers.getHeader("org.apache.cxf.jose.context");
        if (requestContext == null && headerContext == null) {
            return;
        }
        if (requestContext == null && headerContext != null || requestContext != null && headerContext == null || !requestContext.equals(headerContext)) {
            LOG.warning("Invalid JOSE context property");
            throw new JoseException();
        }
    }

    public static String checkContentType(String contentType, String defaultType) {
        if (contentType != null) {
            String typeWithoutParams;
            int paramIndex = contentType.indexOf(59);
            String string = typeWithoutParams = paramIndex == -1 ? contentType : contentType.substring(0, paramIndex);
            if (typeWithoutParams.indexOf(47) == -1) {
                contentType = "application/" + contentType;
            }
        } else {
            contentType = defaultType;
        }
        return contentType;
    }

    public static String expandContentType(String contentType) {
        String typeWithoutParams;
        int paramIndex = contentType.indexOf(59);
        String string = typeWithoutParams = paramIndex == -1 ? contentType : contentType.substring(0, paramIndex);
        if (typeWithoutParams.indexOf(47) == -1) {
            contentType = "application/" + contentType;
        }
        return contentType;
    }

    public static String decodeToString(String encoded) {
        return new String(JoseUtils.decode(encoded), StandardCharsets.UTF_8);
    }

    public static byte[] decode(String encoded) {
        return CryptoUtils.decodeSequence(encoded);
    }

    public static boolean validateCriticalHeaders(JoseHeaders headers) {
        List<String> critical = headers.getCritical();
        if (critical == null) {
            return true;
        }
        if (critical.isEmpty() || JoseUtils.detectDoubleEntry(critical) || critical.contains("crit")) {
            return false;
        }
        return headers.asMap().keySet().containsAll(critical);
    }

    private static boolean detectDoubleEntry(List<?> list) {
        HashSet inputSet = new HashSet(list);
        return list.size() > inputSet.size();
    }

    public static void traceHeaders(JoseHeaders headers) {
        Message m = PhaseInterceptorChain.getCurrentMessage();
        if (MessageUtils.getContextualBoolean(m, "jose.debug", false)) {
            JsonMapObjectReaderWriter writer = new JsonMapObjectReaderWriter(true);
            String thePrefix = headers instanceof JwsHeaders ? "JWS" : (headers instanceof JweHeaders ? "JWE" : "JOSE");
            LOG.info(thePrefix + " Headers: \r\n" + writer.toJson(headers));
        }
    }

    public static InputStream getResourceStream(String loc, Bus bus) throws Exception {
        URL url = JoseUtils.getResourceURL(loc, bus);
        return url == null ? null : url.openStream();
    }

    public static URL getResourceURL(String loc, Bus bus) throws Exception {
        URL url;
        block5: {
            url = null;
            if (loc.startsWith(CLASSPATH_PREFIX)) {
                String path = loc.substring(CLASSPATH_PREFIX.length());
                url = JoseUtils.getClasspathResourceURL(path, JoseUtils.class, bus);
            } else {
                try {
                    url = new URL(loc);
                }
                catch (Exception ex) {
                    File file;
                    url = JoseUtils.getClasspathResourceURL(loc, JoseUtils.class, bus);
                    if (url != null || !(file = new File(loc)).exists()) break block5;
                    url = file.toURI().toURL();
                }
            }
        }
        if (url == null) {
            LOG.warning("No resource " + loc + " is available");
        }
        return url;
    }

    public static URL getClasspathResourceURL(String path, Class<?> callingClass, Bus bus) {
        URL url = ClassLoaderUtils.getResource(path, callingClass);
        return url == null ? JoseUtils.getResource(path, URL.class, bus) : url;
    }

    public static <T> T getResource(String path, Class<T> resourceClass, Bus bus) {
        ResourceManager rm;
        if (bus != null && (rm = bus.getExtension(ResourceManager.class)) != null) {
            return rm.resolveResource(path, resourceClass);
        }
        return null;
    }

    public static Properties loadProperties(String propertiesLocation, Bus bus) throws Exception {
        Properties props = new Properties();
        try (InputStream is = JoseUtils.getResourceStream(propertiesLocation, bus);){
            if (is == null) {
                throw new JoseException("The properties file " + propertiesLocation + " could not be read");
            }
            props.load(is);
        }
        return props;
    }

    public static boolean checkBooleanProperty(JoseHeaders headers, Properties props, Message m, String propertyName) {
        if (headers == null) {
            return false;
        }
        if (props.containsKey(propertyName)) {
            return PropertyUtils.isTrue(props.get(propertyName));
        }
        return MessageUtils.getContextualBoolean(m, propertyName, false);
    }
}

