/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class AbstractJwsJsonWriterProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJwsJsonWriterProvider.class);
    private List<JwsSignatureProvider> sigProviders;

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.setSignatureProviders(Collections.singletonList(signatureProvider));
    }

    public void setSignatureProviders(List<JwsSignatureProvider> signatureProviders) {
        this.sigProviders = signatureProviders;
    }

    protected List<String> getPropertyLocations() {
        Message m = JAXRSUtils.getCurrentMessage();
        Object propLocsProp = MessageUtils.getContextualProperty(m, "rs.security.signature.out.properties", "rs.security.signature.properties");
        if (propLocsProp == null) {
            if (this.sigProviders == null) {
                LOG.warning("JWS JSON init properties resource is not identified");
                throw new JwsException(JwsException.Error.NO_INIT_PROPERTIES);
            }
            return Collections.emptyList();
        }
        List<String> propLocs = null;
        if (propLocsProp instanceof String) {
            String[] props = ((String)propLocsProp).split(",");
            propLocs = Arrays.asList(props);
        } else {
            propLocs = CastUtils.cast((List)propLocsProp);
        }
        return propLocs;
    }

    protected List<JwsSignatureProvider> getInitializedSigProviders(List<String> propLocs, List<JwsHeaders> protectedHeaders) {
        if (this.sigProviders != null) {
            return this.sigProviders;
        }
        Message m = JAXRSUtils.getCurrentMessage();
        LinkedList<JwsSignatureProvider> theSigProviders = new LinkedList<JwsSignatureProvider>();
        for (int i = 0; i < propLocs.size(); ++i) {
            Properties props = JwsUtils.loadJwsProperties(m, propLocs.get(i));
            theSigProviders.add(JwsUtils.loadSignatureProvider(props, protectedHeaders.get(i)));
        }
        return theSigProviders;
    }

    protected void writeJws(JwsJsonProducer p, OutputStream os) throws IOException {
        byte[] bytes = StringUtils.toBytesUTF8(p.getJwsJsonSignedDocument());
        IOUtils.copy(new ByteArrayInputStream(bytes), os);
    }
}

