/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJweDecryptingFilter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;

@PreMatching
@Priority(value=1001)
public class JweContainerRequestFilter
extends AbstractJweDecryptingFilter
implements ContainerRequestFilter {
    @Override
    public void filter(ContainerRequestContext context) throws IOException {
        if (this.isMethodWithNoContent(context.getMethod()) || this.isCheckEmptyStream() && !context.hasEntity()) {
            return;
        }
        byte[] encryptedContent = IOUtils.readBytesFromStream(context.getEntityStream());
        if (encryptedContent.length == 0) {
            return;
        }
        JweDecryptionOutput out = this.decrypt(encryptedContent);
        byte[] bytes = out.getContent();
        context.setEntityStream(new ByteArrayInputStream(bytes));
        context.getHeaders().putSingle("Content-Length", Integer.toString(bytes.length));
        String ct = JoseUtils.checkContentType(out.getHeaders().getContentType(), this.getDefaultMediaType());
        if (ct != null) {
            context.getHeaders().putSingle("Content-Type", ct);
        }
        if (super.isValidateHttpHeaders()) {
            super.validateHttpHeadersIfNeeded(context.getHeaders(), out.getHeaders());
        }
    }

    protected boolean isMethodWithNoContent(String method) {
        return "DELETE".equals(method) || HttpUtils.isMethodWithNoRequestContent(method);
    }
}

