/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SimpleGroup;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.security.LoginSecurityContext;

public class JwtTokenSecurityContext
implements LoginSecurityContext {
    private final JwtToken token;
    private final Principal principal;
    private final Set<Principal> roles;

    public JwtTokenSecurityContext(JwtToken jwt, String roleClaim) {
        this.principal = new SimplePrincipal(jwt.getClaims().getSubject());
        this.token = jwt;
        if (roleClaim != null && jwt.getClaims().containsProperty(roleClaim)) {
            this.roles = new HashSet<Principal>();
            String role = jwt.getClaims().getStringProperty(roleClaim).trim();
            for (String r : role.split(",")) {
                this.roles.add(new SimpleGroup(r));
            }
        } else {
            this.roles = Collections.emptySet();
        }
    }

    public JwtToken getToken() {
        return this.token;
    }

    @Override
    public Subject getSubject() {
        return null;
    }

    @Override
    public Set<Principal> getUserRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    @Override
    public boolean isUserInRole(String role) {
        for (Principal principalRole : this.roles) {
            if (principalRole == this.principal || !principalRole.getName().equals(role)) continue;
            return true;
        }
        return false;
    }
}

