/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class JweCompactBuilder {
    private StringBuilder jweContentBuilder;
    private String encodedEncryptedContent;
    private String encodedAuthTag;

    public JweCompactBuilder(JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentNoTag, byte[] authenticationTag) {
        this(JweCompactBuilder.getHeadersJson(headers), encryptedContentEncryptionKey, cipherInitVector, encryptedContentNoTag, authenticationTag);
    }

    public JweCompactBuilder(String headersJson, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentNoTag, byte[] authenticationTag) {
        this.jweContentBuilder = JweCompactBuilder.startJweContent(new StringBuilder(), headersJson, encryptedContentEncryptionKey, cipherInitVector);
        this.encodedEncryptedContent = Base64UrlUtility.encode(encryptedContentNoTag);
        this.encodedAuthTag = Base64UrlUtility.encode(authenticationTag);
    }

    public JweCompactBuilder(JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentWithTag, int authTagLengthBits) {
        this.jweContentBuilder = JweCompactBuilder.startJweContent(new StringBuilder(), headers, encryptedContentEncryptionKey, cipherInitVector);
        this.encodedEncryptedContent = Base64UrlUtility.encodeChunk(encryptedContentWithTag, 0, encryptedContentWithTag.length - authTagLengthBits / 8);
        this.encodedAuthTag = Base64UrlUtility.encodeChunk(encryptedContentWithTag, encryptedContentWithTag.length - authTagLengthBits / 8, authTagLengthBits / 8);
    }

    public static String startJweContent(JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) {
        return JweCompactBuilder.startJweContent(new StringBuilder(), headers, encryptedContentEncryptionKey, cipherInitVector).toString();
    }

    public static StringBuilder startJweContent(StringBuilder sb, JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) {
        return JweCompactBuilder.startJweContent(sb, JweCompactBuilder.getHeadersJson(headers), encryptedContentEncryptionKey, cipherInitVector);
    }

    private static String getHeadersJson(JweHeaders headers) {
        return new JsonMapObjectReaderWriter().toJson(headers);
    }

    public static StringBuilder startJweContent(StringBuilder sb, String headersJson, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) {
        String encodedHeaders = Base64UrlUtility.encode(headersJson);
        String encodedContentEncryptionKey = Base64UrlUtility.encode(encryptedContentEncryptionKey);
        String encodedInitVector = Base64UrlUtility.encode(cipherInitVector);
        sb.append(encodedHeaders).append('.').append(encodedContentEncryptionKey == null ? "" : encodedContentEncryptionKey).append('.').append(encodedInitVector == null ? "" : encodedInitVector).append('.');
        return sb;
    }

    public static void startJweContent(OutputStream os, JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) throws IOException {
        byte[] jsonBytes = StringUtils.toBytesUTF8(JweCompactBuilder.getHeadersJson(headers));
        Base64UrlUtility.encodeAndStream(jsonBytes, 0, jsonBytes.length, os);
        byte[] dotBytes = new byte[]{46};
        os.write(dotBytes);
        Base64UrlUtility.encodeAndStream(encryptedContentEncryptionKey, 0, encryptedContentEncryptionKey.length, os);
        os.write(dotBytes);
        Base64UrlUtility.encodeAndStream(cipherInitVector, 0, cipherInitVector.length, os);
        os.write(dotBytes);
        os.flush();
    }

    public String getJweContent() {
        return this.jweContentBuilder.append(this.encodedEncryptedContent).append('.').append(this.encodedAuthTag).toString();
    }
}

