/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweJsonEncryptionEntry;

public class JweJsonProducer {
    protected static final Logger LOG = LogUtils.getL7dLogger(JweJsonProducer.class);
    private JsonMapObjectReaderWriter writer = new JsonMapObjectReaderWriter();
    private JweHeaders protectedHeader;
    private JweHeaders unprotectedHeader;
    private byte[] content;
    private byte[] aad;
    private boolean canBeFlat;

    public JweJsonProducer(JweHeaders protectedHeader, byte[] content) {
        this(protectedHeader, content, false);
    }

    public JweJsonProducer(JweHeaders protectedHeader, byte[] content, boolean canBeFlat) {
        this(protectedHeader, content, null, canBeFlat);
    }

    public JweJsonProducer(JweHeaders protectedHeader, byte[] content, byte[] aad, boolean canBeFlat) {
        this.protectedHeader = protectedHeader;
        this.content = content;
        this.aad = aad;
        this.canBeFlat = canBeFlat;
    }

    public JweJsonProducer(JweHeaders protectedHeader, JweHeaders unprotectedHeader, byte[] content, byte[] aad, boolean canBeFlat) {
        this(protectedHeader, content, aad, canBeFlat);
        this.unprotectedHeader = unprotectedHeader;
    }

    public JweJsonProducer(JweHeaders protectedHeader, JweHeaders unprotectedHeader, byte[] content) {
        this(protectedHeader, unprotectedHeader, content, null, false);
    }

    public String encryptWith(JweEncryptionProvider encryptor) {
        return this.encryptWith(Collections.singletonList(encryptor), null);
    }

    public String encryptWith(JweEncryptionProvider encryptor, JweHeaders recipientUnprotected) {
        return this.encryptWith(Collections.singletonList(encryptor), Collections.singletonList(recipientUnprotected));
    }

    public String encryptWith(List<JweEncryptionProvider> encryptors) {
        return this.encryptWith(encryptors, null);
    }

    public String encryptWith(List<JweEncryptionProvider> encryptors, List<JweHeaders> recipientUnprotected) {
        this.checkAndGetContentAlgorithm(encryptors);
        if (recipientUnprotected != null && recipientUnprotected.size() != encryptors.size()) {
            throw new IllegalArgumentException();
        }
        JweHeaders unionHeaders = new JweHeaders();
        if (this.protectedHeader != null) {
            unionHeaders.asMap().putAll(this.protectedHeader.asMap());
        }
        if (this.unprotectedHeader != null) {
            if (!Collections.disjoint(unionHeaders.asMap().keySet(), this.unprotectedHeader.asMap().keySet())) {
                LOG.warning("Protected and unprotected headers have duplicate values");
                throw new JweException(JweException.Error.INVALID_JSON_JWE);
            }
            JweJsonProducer.checkCriticalHeaders(this.unprotectedHeader);
            unionHeaders.asMap().putAll(this.unprotectedHeader.asMap());
        }
        ArrayList<JweJsonEncryptionEntry> entries = new ArrayList<JweJsonEncryptionEntry>(encryptors.size());
        LinkedHashMap<String, Object> jweJsonMap = new LinkedHashMap<String, Object>();
        byte[] cipherText = null;
        byte[] authTag = null;
        byte[] iv = null;
        for (int i = 0; i < encryptors.size(); ++i) {
            byte[] encryptedCek;
            JweEncryptionProvider encryptor = encryptors.get(i);
            JweHeaders perRecipientUnprotected = recipientUnprotected == null ? null : recipientUnprotected.get(i);
            JweHeaders jsonHeaders = null;
            if (perRecipientUnprotected != null && !perRecipientUnprotected.asMap().isEmpty()) {
                JweJsonProducer.checkCriticalHeaders(perRecipientUnprotected);
                if (!Collections.disjoint(unionHeaders.asMap().keySet(), perRecipientUnprotected.asMap().keySet())) {
                    LOG.warning("union and recipient unprotected headers have duplicate values");
                    throw new JweException(JweException.Error.INVALID_JSON_JWE);
                }
                jsonHeaders = new JweHeaders(new LinkedHashMap<String, Object>(unionHeaders.asMap()));
                jsonHeaders.asMap().putAll(perRecipientUnprotected.asMap());
            } else {
                jsonHeaders = unionHeaders;
            }
            jsonHeaders.setProtectedHeaders(this.protectedHeader);
            JweEncryptionInput input = this.createEncryptionInput(jsonHeaders);
            if (i > 0) {
                input.setContent(null);
                input.setContentEncryptionRequired(false);
            }
            JweEncryptionOutput state = encryptor.getEncryptionOutput(input);
            byte[] currentCipherText = state.getEncryptedContent();
            byte[] currentAuthTag = state.getAuthTag();
            byte[] currentIv = state.getIv();
            if (cipherText == null) {
                cipherText = currentCipherText;
            }
            if (authTag == null) {
                authTag = currentAuthTag;
            }
            if (iv == null) {
                iv = currentIv;
            }
            if ((encryptedCek = state.getContentEncryptionKey()).length == 0 && encryptor.getKeyAlgorithm() != null && !KeyAlgorithm.DIRECT.equals((Object)encryptor.getKeyAlgorithm())) {
                LOG.warning("Unexpected key encryption algorithm");
                throw new JweException(JweException.Error.INVALID_JSON_JWE);
            }
            String encodedCek = encryptedCek.length == 0 ? null : Base64UrlUtility.encode(encryptedCek);
            entries.add(new JweJsonEncryptionEntry(perRecipientUnprotected, encodedCek));
        }
        if (this.protectedHeader != null) {
            jweJsonMap.put("protected", Base64UrlUtility.encode(this.writer.toJson(this.protectedHeader)));
        }
        if (this.unprotectedHeader != null) {
            jweJsonMap.put("unprotected", this.unprotectedHeader);
        }
        if (entries.size() == 1 && this.canBeFlat) {
            String encryptedKey;
            JweHeaders unprotectedEntryHeader = ((JweJsonEncryptionEntry)entries.get(0)).getUnprotectedHeader();
            if (unprotectedEntryHeader != null && !unprotectedEntryHeader.asMap().isEmpty()) {
                jweJsonMap.put("header", unprotectedEntryHeader);
            }
            if ((encryptedKey = ((JweJsonEncryptionEntry)entries.get(0)).getEncodedEncryptedKey()) != null) {
                jweJsonMap.put("encrypted_key", encryptedKey);
            }
        } else {
            jweJsonMap.put("recipients", entries);
        }
        if (this.aad != null) {
            jweJsonMap.put("aad", Base64UrlUtility.encode(this.aad));
        }
        jweJsonMap.put("iv", Base64UrlUtility.encode(iv));
        jweJsonMap.put("ciphertext", Base64UrlUtility.encode(cipherText));
        jweJsonMap.put("tag", Base64UrlUtility.encode(authTag));
        return this.writer.toJson(jweJsonMap);
    }

    protected JweEncryptionInput createEncryptionInput(JweHeaders jsonHeaders) {
        return new JweEncryptionInput(jsonHeaders, this.content, this.aad);
    }

    private String checkAndGetContentAlgorithm(List<JweEncryptionProvider> encryptors) {
        HashSet<String> set = new HashSet<String>();
        for (JweEncryptionProvider encryptor : encryptors) {
            set.add(encryptor.getContentAlgorithm().getJwaName());
        }
        if (set.size() != 1) {
            LOG.warning("Invalid content encryption algorithm");
            throw new JweException(JweException.Error.INVALID_CONTENT_ALGORITHM);
        }
        return (String)set.iterator().next();
    }

    private static void checkCriticalHeaders(JweHeaders unprotected) {
        if (unprotected.asMap().containsKey("crit")) {
            LOG.warning("Unprotected headers contain critical headers");
            throw new JweException(JweException.Error.INVALID_JSON_JWE);
        }
    }
}

