/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwk;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.common.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.common.PrivateKeyPasswordProvider;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.PbesHmacAesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.PbesHmacAesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkException;
import org.apache.cxf.rs.security.jose.jwk.JwkReaderWriter;
import org.apache.cxf.rs.security.jose.jwk.KeyOperation;
import org.apache.cxf.rs.security.jose.jwk.KeyType;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.rt.security.crypto.MessageDigestUtils;

public final class JwkUtils {
    private static final Map<KeyType, List<String>> JWK_REQUIRED_FIELDS_MAP = new HashMap<KeyType, List<String>>();

    private JwkUtils() {
    }

    public static String getThumbprint(String keySequence) {
        return JwkUtils.getThumbprint(JwkUtils.readJwkKey(keySequence));
    }

    public static String getThumbprint(JsonWebKey key) {
        List<String> fields = JwkUtils.getRequiredFields(key.getKeyType());
        JsonWebKey thumbprintKey = new JsonWebKey();
        for (String f : fields) {
            thumbprintKey.setProperty(f, key.getProperty(f));
        }
        String json = new JsonMapObjectReaderWriter().toJson(thumbprintKey);
        byte[] digest = MessageDigestUtils.createDigest(json, "SHA-256");
        return Base64UrlUtility.encode(digest);
    }

    public static List<String> getRequiredFields(KeyType keyType) {
        return JWK_REQUIRED_FIELDS_MAP.get((Object)keyType);
    }

    public static JsonWebKey readJwkKey(URI uri) throws IOException {
        return JwkUtils.readJwkKey(uri.toURL().openStream());
    }

    public static JsonWebKeys readJwkSet(URI uri) throws IOException {
        return JwkUtils.readJwkSet(uri.toURL().openStream());
    }

    public static JsonWebKey readJwkKey(InputStream is) throws IOException {
        return JwkUtils.readJwkKey(IOUtils.readStringFromStream(is));
    }

    public static JsonWebKeys readJwkSet(InputStream is) throws IOException {
        return JwkUtils.readJwkSet(IOUtils.readStringFromStream(is));
    }

    public static JsonWebKey readJwkKey(String jwkJson) {
        return new JwkReaderWriter().jsonToJwk(jwkJson);
    }

    public static JsonWebKeys readJwkSet(String jwksJson) {
        return new JwkReaderWriter().jsonToJwkSet(jwksJson);
    }

    public static String jwkKeyToJson(JsonWebKey jwkKey) {
        return new JwkReaderWriter().jwkToJson(jwkKey);
    }

    public static void jwkKeyToJson(JsonWebKey jwkKey, OutputStream os) throws IOException {
        IOUtils.copy(new ByteArrayInputStream(StringUtils.toBytesUTF8(JwkUtils.jwkKeyToJson(jwkKey))), os);
    }

    public static String jwkSetToJson(JsonWebKeys jwkSet) {
        return new JwkReaderWriter().jwkSetToJson(jwkSet);
    }

    public static void jwkSetToJson(JsonWebKeys jwkSet, OutputStream os) throws IOException {
        IOUtils.copy(new ByteArrayInputStream(StringUtils.toBytesUTF8(JwkUtils.jwkSetToJson(jwkSet))), os);
    }

    public static String encodeJwkKey(JsonWebKey jwkKey) {
        return Base64UrlUtility.encode(JwkUtils.jwkKeyToJson(jwkKey));
    }

    public static String encodeJwkSet(JsonWebKeys jwkSet) {
        return Base64UrlUtility.encode(JwkUtils.jwkSetToJson(jwkSet));
    }

    public static JsonWebKey decodeJwkKey(String jwkJson) {
        return JwkUtils.readJwkKey(JoseUtils.decodeToString(jwkJson));
    }

    public static JsonWebKeys decodeJwkSet(String jwksJson) {
        return JwkUtils.readJwkSet(JoseUtils.decodeToString(jwksJson));
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, char[] password) {
        return JwkUtils.encryptJwkSet(jwkSet, JwkUtils.createDefaultEncryption(password));
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, JweEncryptionProvider jwe) {
        return jwe.encrypt(StringUtils.toBytesUTF8(new JwkReaderWriter().jwkSetToJson(jwkSet)), JwkUtils.toJweHeaders("jwk-set+json"));
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, PublicKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, StringUtils.toBytesUTF8(JwkUtils.jwkSetToJson(jwkSet)), "jwk-set+json");
    }

    public static String signJwkSet(JsonWebKeys jwkSet, PrivateKey key, SignatureAlgorithm algo) {
        return JwsUtils.sign(key, algo, JwkUtils.jwkSetToJson(jwkSet), "jwk-set+json");
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, SecretKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, StringUtils.toBytesUTF8(JwkUtils.jwkSetToJson(jwkSet)), "jwk-set+json");
    }

    public static JsonWebKeys decryptJwkSet(String jsonJwkSet, char[] password) {
        return JwkUtils.decryptJwkSet(jsonJwkSet, JwkUtils.createDefaultDecryption(password));
    }

    public static JsonWebKeys decryptJwkSet(String jsonJwkSet, JweDecryptionProvider jwe) {
        return new JwkReaderWriter().jsonToJwkSet(jwe.decrypt(jsonJwkSet).getContentText());
    }

    public static JsonWebKeys decryptJwkSet(PrivateKey key, KeyAlgorithm keyAlgo, ContentAlgorithm ctAlgo, String jsonJwkSet) {
        return JwkUtils.readJwkSet(JwkUtils.toString(JweUtils.decrypt(key, keyAlgo, ctAlgo, jsonJwkSet)));
    }

    public static JsonWebKeys verifyJwkSet(PublicKey key, SignatureAlgorithm keyAlgo, String jsonJwk) {
        return JwkUtils.readJwkSet(JwsUtils.verify(key, keyAlgo, jsonJwk));
    }

    public static JsonWebKeys decryptJwkSet(SecretKey key, KeyAlgorithm keyAlgo, ContentAlgorithm ctAlgo, String jsonJwkSet) {
        return JwkUtils.readJwkSet(JwkUtils.toString(JweUtils.decrypt(key, keyAlgo, ctAlgo, jsonJwkSet)));
    }

    public static JsonWebKeys decryptJwkSet(InputStream is, char[] password) throws IOException {
        return JwkUtils.decryptJwkSet(is, JwkUtils.createDefaultDecryption(password));
    }

    public static JsonWebKeys decryptJwkSet(InputStream is, JweDecryptionProvider jwe) throws IOException {
        return new JwkReaderWriter().jsonToJwkSet(jwe.decrypt(IOUtils.readStringFromStream(is)).getContentText());
    }

    public static String encryptJwkKey(JsonWebKey jwkKey, char[] password) {
        return JwkUtils.encryptJwkKey(jwkKey, JwkUtils.createDefaultEncryption(password));
    }

    public static String encryptJwkKey(JsonWebKey jwkKey, JweEncryptionProvider jwe) {
        return jwe.encrypt(StringUtils.toBytesUTF8(new JwkReaderWriter().jwkToJson(jwkKey)), JwkUtils.toJweHeaders("jwk+json"));
    }

    public static String encryptJwkKey(JsonWebKey jwkKey, PublicKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, StringUtils.toBytesUTF8(JwkUtils.jwkKeyToJson(jwkKey)), "jwk+json");
    }

    public static String encryptJwkKey(JsonWebKey jwkKey, SecretKey key, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, StringUtils.toBytesUTF8(JwkUtils.jwkKeyToJson(jwkKey)), "jwk+json");
    }

    public static String signJwkKey(JsonWebKey jwkKey, PrivateKey key, SignatureAlgorithm algo) {
        return JwsUtils.sign(key, algo, JwkUtils.jwkKeyToJson(jwkKey), "jwk+json");
    }

    public static JsonWebKey decryptJwkKey(String jsonJwkKey, char[] password) {
        return JwkUtils.decryptJwkKey(jsonJwkKey, JwkUtils.createDefaultDecryption(password));
    }

    public static JsonWebKey decryptJwkKey(PrivateKey key, KeyAlgorithm keyAlgo, ContentAlgorithm ctAlgo, String jsonJwk) {
        return JwkUtils.readJwkKey(JwkUtils.toString(JweUtils.decrypt(key, keyAlgo, ctAlgo, jsonJwk)));
    }

    public static JsonWebKey verifyJwkKey(PublicKey key, SignatureAlgorithm keyAlgo, String jsonJwk) {
        return JwkUtils.readJwkKey(JwsUtils.verify(key, keyAlgo, jsonJwk));
    }

    public static JsonWebKey decryptJwkKey(SecretKey key, KeyAlgorithm keyAlgo, ContentAlgorithm ctAlgo, String jsonJwk) {
        return JwkUtils.readJwkKey(JwkUtils.toString(JweUtils.decrypt(key, keyAlgo, ctAlgo, jsonJwk)));
    }

    public static JsonWebKey decryptJwkKey(String jsonJwkKey, JweDecryptionProvider jwe) {
        return new JwkReaderWriter().jsonToJwk(jwe.decrypt(jsonJwkKey).getContentText());
    }

    public static JsonWebKey decryptJwkKey(InputStream is, char[] password) throws IOException {
        return JwkUtils.decryptJwkKey(is, JwkUtils.createDefaultDecryption(password));
    }

    public static JsonWebKey decryptJwkKey(InputStream is, JweDecryptionProvider jwe) throws IOException {
        return new JwkReaderWriter().jsonToJwk(jwe.decrypt(IOUtils.readStringFromStream(is)).getContentText());
    }

    public static JsonWebKeys loadPublicJwkSet(Message m, Properties props) {
        return JwkUtils.loadJwkSet(m, props, null);
    }

    public static JsonWebKeys loadJwkSet(Message m, Properties props, PrivateKeyPasswordProvider cb) {
        String key = (String)props.get("rs.security.keystore.file");
        JsonWebKeys jwkSet = null;
        if (key != null && m != null) {
            Object jwkSetProp = m.getExchange().get(key);
            if (jwkSetProp != null && !(jwkSetProp instanceof JsonWebKeys)) {
                throw new JwkException("Unexpected key store class: " + jwkSetProp.getClass().getName());
            }
            jwkSet = (JsonWebKeys)jwkSetProp;
        }
        if (jwkSet == null) {
            jwkSet = JwkUtils.loadJwkSet(props, m != null ? m.getExchange().getBus() : null, cb);
            if (key != null && m != null) {
                m.getExchange().put(key, jwkSet);
            }
        }
        return jwkSet;
    }

    public static JsonWebKeys loadJwkSet(Properties props, Bus bus, PrivateKeyPasswordProvider cb) {
        AesCbcHmacJweDecryption decryption = cb != null ? new AesCbcHmacJweDecryption(new PbesHmacAesWrapKeyDecryptionAlgorithm(cb.getPassword(props))) : null;
        return JwkUtils.loadJwkSet(props, bus, decryption);
    }

    public static JsonWebKeys loadJwkSet(Properties props, Bus bus, JweDecryptionProvider jwe) {
        String keyContent;
        block19: {
            keyContent = null;
            String keyStoreLoc = props.getProperty("rs.security.keystore.file");
            if (keyStoreLoc != null) {
                try {
                    InputStream is = JoseUtils.getResourceStream(keyStoreLoc, bus);
                    if (is == null) {
                        throw new JwkException("Error in loading keystore location: " + keyStoreLoc);
                    }
                    try (InputStream isResource = is;){
                        keyContent = IOUtils.readStringFromStream(isResource);
                        break block19;
                    }
                }
                catch (Exception ex) {
                    throw new JwkException(ex);
                }
            }
            keyContent = props.getProperty("rs.security.keystore.jwkset");
            if (keyContent == null) {
                keyContent = props.getProperty("rs.security.keystore.jwkkey");
            }
        }
        if (jwe != null) {
            keyContent = jwe.decrypt(keyContent).getContentText();
        }
        JwkReaderWriter reader = new JwkReaderWriter();
        if (props.getProperty("rs.security.keystore.jwkkey") == null) {
            return reader.jsonToJwkSet(keyContent);
        }
        JsonWebKey jwk = reader.jsonToJwk(keyContent);
        return new JsonWebKeys(jwk);
    }

    public static JsonWebKey loadJsonWebKey(Message m, Properties props, KeyOperation keyOper) {
        return JwkUtils.loadJsonWebKey(m, props, keyOper, null);
    }

    public static JsonWebKey loadJsonWebKey(Message m, Properties props, KeyOperation keyOper, String inHeaderKid) {
        List<JsonWebKey> keys;
        PrivateKeyPasswordProvider cb = KeyManagementUtils.loadPasswordProvider(m, props, keyOper);
        JsonWebKeys jwkSet = JwkUtils.loadJwkSet(m, props, cb);
        String kid = null;
        kid = inHeaderKid != null && MessageUtils.getContextualBoolean(m, "rs.security.accept.public.key", false) ? inHeaderKid : KeyManagementUtils.getKeyId(m, props, "rs.security.keystore.alias", keyOper);
        if (kid != null) {
            return jwkSet.getKey(kid);
        }
        if (keyOper != null && (keys = jwkSet.getKeyOperationMap().get((Object)keyOper)) != null && keys.size() == 1) {
            return keys.get(0);
        }
        return null;
    }

    public static List<JsonWebKey> loadJsonWebKeys(Message m, Properties props, KeyOperation keyOper) {
        List<JsonWebKey> keys;
        PrivateKeyPasswordProvider cb = KeyManagementUtils.loadPasswordProvider(m, props, keyOper);
        JsonWebKeys jwkSet = JwkUtils.loadJwkSet(m, props, cb);
        String kid = KeyManagementUtils.getKeyId(m, props, "rs.security.keystore.alias", keyOper);
        if (kid != null) {
            return Collections.singletonList(jwkSet.getKey(kid));
        }
        String kids = KeyManagementUtils.getKeyId(m, props, "rs.security.keystore.aliases", keyOper);
        if (kids != null) {
            String[] values = kids.split(",");
            ArrayList<JsonWebKey> keys2 = new ArrayList<JsonWebKey>(values.length);
            for (String value : values) {
                keys2.add(jwkSet.getKey(value));
            }
            return keys2;
        }
        if (keyOper != null && (keys = jwkSet.getKeyOperationMap().get((Object)keyOper)) != null && keys.size() == 1) {
            return Collections.singletonList(keys.get(0));
        }
        return null;
    }

    public static RSAPublicKey toRSAPublicKey(JsonWebKey jwk) {
        return JwkUtils.toRSAPublicKey(jwk, false);
    }

    public static RSAPublicKey toRSAPublicKey(JsonWebKey jwk, boolean checkX509) {
        String encodedModulus = (String)jwk.getProperty("n");
        String encodedPublicExponent = (String)jwk.getProperty("e");
        if (encodedModulus != null) {
            return CryptoUtils.getRSAPublicKey(encodedModulus, encodedPublicExponent);
        }
        if (checkX509) {
            List<X509Certificate> chain = JwkUtils.toX509CertificateChain(jwk);
            return (RSAPublicKey)chain.get(0).getPublicKey();
        }
        return null;
    }

    public static List<X509Certificate> toX509CertificateChain(JsonWebKey jwk) {
        List<String> base64EncodedChain = jwk.getX509Chain();
        return KeyManagementUtils.toX509CertificateChain(base64EncodedChain);
    }

    public static JsonWebKey fromECPublicKey(ECPublicKey pk, String curve) {
        return JwkUtils.fromECPublicKey(pk, curve, null);
    }

    public static JsonWebKey fromECPublicKey(ECPublicKey pk, String curve, String kid) {
        JsonWebKey jwk = JwkUtils.prepareECJwk(curve, kid);
        jwk.setProperty("x", Base64UrlUtility.encode(pk.getW().getAffineX().toByteArray()));
        jwk.setProperty("y", Base64UrlUtility.encode(pk.getW().getAffineY().toByteArray()));
        return jwk;
    }

    public static JsonWebKey fromECPrivateKey(ECPrivateKey pk, String curve) {
        return JwkUtils.fromECPrivateKey(pk, curve, null);
    }

    public static JsonWebKey fromECPrivateKey(ECPrivateKey pk, String curve, String kid) {
        JsonWebKey jwk = JwkUtils.prepareECJwk(curve, kid);
        jwk.setProperty("d", Base64UrlUtility.encode(pk.getS().toByteArray()));
        return jwk;
    }

    public static JsonWebKey fromRSAPublicKey(RSAPublicKey pk, String algo) {
        return JwkUtils.fromRSAPublicKey(pk, algo, null);
    }

    public static JsonWebKey fromRSAPublicKey(RSAPublicKey pk, String algo, String kid) {
        JsonWebKey jwk = JwkUtils.prepareRSAJwk(pk.getModulus(), algo, kid);
        String encodedPublicExponent = Base64UrlUtility.encode(pk.getPublicExponent().toByteArray());
        jwk.setProperty("e", encodedPublicExponent);
        return jwk;
    }

    public static JsonWebKey fromPublicKey(PublicKey key, Properties props, String algoProp) {
        JsonWebKey jwk = null;
        if (key instanceof RSAPublicKey) {
            String algo = props.getProperty(algoProp);
            jwk = JwkUtils.fromRSAPublicKey((RSAPublicKey)key, algo);
        } else {
            jwk = JwkUtils.fromECPublicKey((ECPublicKey)key, props.getProperty("rs.security.elliptic.curve"));
        }
        String kid = props.getProperty("rs.security.keystore.alias");
        if (kid != null) {
            jwk.setKeyId(kid);
        }
        return jwk;
    }

    public static JsonWebKey fromX509CertificateChain(List<X509Certificate> chain, String algo) {
        JsonWebKey jwk = new JsonWebKey();
        jwk.setAlgorithm(algo);
        List<String> encodedChain = KeyManagementUtils.encodeX509CertificateChain(chain);
        jwk.setX509Chain(encodedChain);
        return jwk;
    }

    public static RSAPrivateKey toRSAPrivateKey(JsonWebKey jwk) {
        String encodedModulus = (String)jwk.getProperty("n");
        String encodedPrivateExponent = (String)jwk.getProperty("d");
        String encodedPrimeP = (String)jwk.getProperty("p");
        if (encodedPrimeP == null) {
            return CryptoUtils.getRSAPrivateKey(encodedModulus, encodedPrivateExponent);
        }
        String encodedPublicExponent = (String)jwk.getProperty("e");
        if (encodedPublicExponent == null) {
            throw new JoseException("JWK without the public exponent can not be converted to RSAPrivateKey");
        }
        String encodedPrimeQ = (String)jwk.getProperty("q");
        String encodedPrimeExpP = (String)jwk.getProperty("dp");
        String encodedPrimeExpQ = (String)jwk.getProperty("dq");
        String encodedCrtCoefficient = (String)jwk.getProperty("qi");
        return CryptoUtils.getRSAPrivateKey(encodedModulus, encodedPublicExponent, encodedPrivateExponent, encodedPrimeP, encodedPrimeQ, encodedPrimeExpP, encodedPrimeExpQ, encodedCrtCoefficient);
    }

    public static JsonWebKey fromRSAPrivateKey(RSAPrivateKey pk, String algo) {
        return JwkUtils.fromRSAPrivateKey(pk, algo, null);
    }

    public static JsonWebKey fromRSAPrivateKey(RSAPrivateKey pk, String algo, String kid) {
        JsonWebKey jwk = JwkUtils.prepareRSAJwk(pk.getModulus(), algo, kid);
        String encodedPrivateExponent = Base64UrlUtility.encode(pk.getPrivateExponent().toByteArray());
        jwk.setProperty("d", encodedPrivateExponent);
        if (pk instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey pkCrt = (RSAPrivateCrtKey)pk;
            jwk.setProperty("e", Base64UrlUtility.encode(pkCrt.getPublicExponent().toByteArray()));
            jwk.setProperty("p", Base64UrlUtility.encode(pkCrt.getPrimeP().toByteArray()));
            jwk.setProperty("q", Base64UrlUtility.encode(pkCrt.getPrimeQ().toByteArray()));
            jwk.setProperty("dp", Base64UrlUtility.encode(pkCrt.getPrimeExponentP().toByteArray()));
            jwk.setProperty("dq", Base64UrlUtility.encode(pkCrt.getPrimeExponentQ().toByteArray()));
            jwk.setProperty("qi", Base64UrlUtility.encode(pkCrt.getCrtCoefficient().toByteArray()));
        }
        return jwk;
    }

    public static ECPublicKey toECPublicKey(JsonWebKey jwk) {
        String eCurve = (String)jwk.getProperty("crv");
        String encodedXCoord = (String)jwk.getProperty("x");
        String encodedYCoord = (String)jwk.getProperty("y");
        return CryptoUtils.getECPublicKey(eCurve, encodedXCoord, encodedYCoord);
    }

    public static ECPrivateKey toECPrivateKey(JsonWebKey jwk) {
        String eCurve = (String)jwk.getProperty("crv");
        String encodedPrivateKey = (String)jwk.getProperty("d");
        return CryptoUtils.getECPrivateKey(eCurve, encodedPrivateKey);
    }

    public static SecretKey toSecretKey(JsonWebKey jwk) {
        return CryptoUtils.createSecretKeySpec((String)jwk.getProperty("k"), AlgorithmUtils.toJavaName(jwk.getAlgorithm()));
    }

    public static JsonWebKey fromSecretKey(SecretKey secretKey, String algo) {
        return JwkUtils.fromSecretKey(secretKey, algo, null);
    }

    public static JsonWebKey fromSecretKey(SecretKey secretKey, String algo, String kid) {
        if (!AlgorithmUtils.isOctet(algo)) {
            throw new JwkException("Invalid algorithm");
        }
        JsonWebKey jwk = new JsonWebKey();
        jwk.setKeyType(KeyType.OCTET);
        if (kid != null) {
            jwk.setKeyId(kid);
        }
        jwk.setAlgorithm(algo);
        String encodedSecretKey = Base64UrlUtility.encode(secretKey.getEncoded());
        jwk.setProperty("k", encodedSecretKey);
        return jwk;
    }

    private static JweEncryptionProvider createDefaultEncryption(char[] password) {
        PbesHmacAesWrapKeyEncryptionAlgorithm keyEncryption = new PbesHmacAesWrapKeyEncryptionAlgorithm(password, KeyAlgorithm.PBES2_HS256_A128KW);
        return new AesCbcHmacJweEncryption(ContentAlgorithm.A128CBC_HS256, (KeyEncryptionProvider)keyEncryption);
    }

    private static JweDecryptionProvider createDefaultDecryption(char[] password) {
        PbesHmacAesWrapKeyDecryptionAlgorithm keyDecryption = new PbesHmacAesWrapKeyDecryptionAlgorithm(password);
        return new AesCbcHmacJweDecryption(keyDecryption);
    }

    private static JsonWebKey prepareRSAJwk(BigInteger modulus, String algo, String kid) {
        byte[] modulusBytes;
        int extraBytesLength;
        JsonWebKey jwk = new JsonWebKey();
        jwk.setKeyType(KeyType.RSA);
        if (algo != null) {
            if (!AlgorithmUtils.isRsa(algo)) {
                throw new JwkException("Invalid algorithm");
            }
            jwk.setAlgorithm(algo);
        }
        if (kid != null) {
            jwk.setKeyId(kid);
        }
        if ((extraBytesLength = (modulusBytes = modulus.toByteArray()).length - modulus.bitLength() / 8) > 0) {
            modulusBytes = Arrays.copyOfRange(modulusBytes, extraBytesLength, modulusBytes.length);
        }
        String encodedModulus = Base64UrlUtility.encode(modulusBytes);
        jwk.setProperty("n", encodedModulus);
        return jwk;
    }

    private static JsonWebKey prepareECJwk(String curve, String kid) {
        JsonWebKey jwk = new JsonWebKey();
        jwk.setKeyType(KeyType.EC);
        if (kid != null) {
            jwk.setKeyId(kid);
        }
        jwk.setProperty("crv", curve);
        return jwk;
    }

    private static String toString(byte[] bytes) {
        try {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static JweHeaders toJweHeaders(String ct) {
        return new JweHeaders(Collections.singletonMap("cty", ct));
    }

    public static void includeCertChain(JsonWebKey jwk, JoseHeaders headers, String algo) {
        List<String> chain;
        if (KeyType.RSA.equals((Object)jwk.getKeyType()) && (chain = CastUtils.cast((List)jwk.getProperty("x5c"))) != null) {
            headers.setX509Chain(chain);
        }
    }

    public static void includePublicKey(JsonWebKey jwk, JoseHeaders headers, String algo) {
        if (KeyType.RSA.equals((Object)jwk.getKeyType())) {
            JsonWebKey jwkPublic = JwkUtils.fromRSAPublicKey(JwkUtils.toRSAPublicKey(jwk), algo);
            if (jwk.getKeyId() != null) {
                jwkPublic.setKeyId(jwk.getKeyId());
            }
            headers.setJsonWebKey(jwkPublic);
        }
    }

    static {
        JWK_REQUIRED_FIELDS_MAP.put(KeyType.RSA, Arrays.asList("e", "kty", "n"));
        JWK_REQUIRED_FIELDS_MAP.put(KeyType.EC, Arrays.asList("crv", "kty", "x", "y"));
        JWK_REQUIRED_FIELDS_MAP.put(KeyType.OCTET, Arrays.asList("k", "kty"));
    }
}

