/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;

public class JwsJsonOutputStream
extends FilterOutputStream {
    private boolean flushed;
    private List<String> protectedHeaders;
    private List<JwsSignature> signatures;
    private ExecutorService executor;

    public JwsJsonOutputStream(OutputStream out, List<String> protectedHeaders, List<JwsSignature> signatures) {
        super(out);
        this.protectedHeaders = protectedHeaders;
        this.signatures = signatures;
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void write(int value) throws IOException {
        byte[] bytes = ByteBuffer.allocate(4).putInt(value).array();
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(final byte[] b, final int off, final int len) throws IOException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (JwsSignature signature : JwsJsonOutputStream.this.signatures) {
                    signature.update(b, off, len);
                }
            }
        });
        this.out.write(b, off, len);
        this.out.flush();
    }

    @Override
    public void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        this.out.write(StringUtils.toBytesUTF8("\",\"signatures\":["));
        this.shutdownExecutor();
        for (int i = 0; i < this.signatures.size(); ++i) {
            if (i > 0) {
                this.out.write(new byte[]{44});
            }
            this.out.write(StringUtils.toBytesUTF8("{\"protected\":\"" + this.protectedHeaders.get(i) + "\",\"signature\":\""));
            byte[] sign = this.signatures.get(i).sign();
            Base64UrlUtility.encodeAndStream(sign, 0, sign.length, this.out);
            this.out.write(StringUtils.toBytesUTF8("\"}"));
        }
        this.out.write(StringUtils.toBytesUTF8("]}"));
        this.flushed = true;
    }

    private void shutdownExecutor() {
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            try {
                this.executor.awaitTermination(1L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

