/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.client.AccessDeniedResponse;
import org.apache.cxf.rs.security.oauth2.client.ClientCodeStateManager;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextImpl;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextManager;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.grants.code.CodeVerifierTransformer;
import org.apache.cxf.rs.security.oauth2.grants.code.JwtRequestCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJoseJwtProducer;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

@PreMatching
@Priority(value=1001)
public class ClientCodeRequestFilter
implements ContainerRequestFilter {
    protected static final Logger LOG = LogUtils.getL7dLogger(ClientCodeRequestFilter.class);
    @Context
    private MessageContext mc;
    private String scopes;
    private String completeUri;
    private String startUri;
    private String authorizationServiceUri;
    private Consumer consumer;
    private ClientCodeStateManager clientStateManager;
    private ClientTokenContextManager clientTokenContextManager;
    private WebClient accessTokenServiceClient;
    private boolean decodeRequestParameters;
    private long expiryThreshold;
    private String redirectUri;
    private boolean setFormPostResponseMode;
    private boolean faultAccessDeniedResponses;
    private boolean applicationCanHandleAccessDenied;
    private CodeVerifierTransformer codeVerifierTransformer;
    private OAuthJoseJwtProducer codeRequestJoseProducer;
    private boolean useAuthorizationHeader = true;

    @Override
    public void filter(ContainerRequestContext rc) throws IOException {
        String referer;
        this.checkSecurityContextStart(rc);
        UriInfo ui = rc.getUriInfo();
        String absoluteRequestUri = ui.getAbsolutePath().toString();
        boolean sameRedirectUri = false;
        if (this.completeUri == null && (referer = rc.getHeaderString("Referer")) != null && referer.startsWith(this.authorizationServiceUri)) {
            this.completeUri = absoluteRequestUri;
            sameRedirectUri = true;
        }
        if (this.isStartUriMatched(ui, absoluteRequestUri, sameRedirectUri)) {
            ClientTokenContext request = this.getClientTokenContext(rc);
            if (request != null) {
                this.setClientCodeRequest(request);
                if (this.completeUri != null) {
                    rc.setRequestUri(URI.create(this.completeUri));
                }
                return;
            }
            Response codeResponse = this.createCodeResponse(rc, ui);
            rc.abortWith(codeResponse);
            return;
        }
        MultivaluedMap<String, String> requestParams = this.toRequestState(rc, ui);
        if (this.codeResponseQueryParamsAvailable(requestParams) && (this.completeUri == null || absoluteRequestUri.endsWith(this.completeUri))) {
            this.processCodeResponse(rc, ui, requestParams);
            this.checkSecurityContextEnd(rc, requestParams);
            return;
        }
        rc.abortWith(Response.status(401).build());
    }

    protected boolean isStartUriMatched(UriInfo ui, String absoluteRequestUri, boolean sameRedirectUri) {
        MultivaluedMap<String, String> queries;
        if (this.startUri == null && this.completeUri != null && !absoluteRequestUri.endsWith(this.completeUri)) {
            return true;
        }
        if ((this.completeUri == null || this.startUri != null && this.startUri.equals(this.completeUri)) && this.codeResponseQueryParamsAvailable(queries = ui.getQueryParameters())) {
            return false;
        }
        return this.startUri == null && !sameRedirectUri || this.startUri != null && absoluteRequestUri.endsWith(this.startUri);
    }

    private boolean codeResponseQueryParamsAvailable(MultivaluedMap<String, String> queries) {
        return queries.containsKey("code") || queries.containsKey("error");
    }

    protected void checkSecurityContextStart(ContainerRequestContext rc) {
        SecurityContext sc = rc.getSecurityContext();
        if (sc == null || sc.getUserPrincipal() == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    private void checkSecurityContextEnd(ContainerRequestContext rc, MultivaluedMap<String, String> requestParams) {
        SecurityContext sc = rc.getSecurityContext();
        if (sc == null || sc.getUserPrincipal() == null) {
            String codeParam = requestParams.getFirst("code");
            if (codeParam == null && requestParams.containsKey("error") && !this.faultAccessDeniedResponses) {
                if (!this.applicationCanHandleAccessDenied) {
                    String error = requestParams.getFirst("error");
                    rc.abortWith(Response.ok(new AccessDeniedResponse(error)).build());
                }
            } else {
                throw ExceptionUtils.toNotAuthorizedException(null, null);
            }
        }
    }

    private Response createCodeResponse(ContainerRequestContext rc, UriInfo ui) {
        MultivaluedMap<String, String> codeRequestState = this.toCodeRequestState(rc, ui);
        MultivaluedMap<String, String> redirectState = this.createRedirectState(rc, ui, codeRequestState);
        String theState = redirectState != null ? redirectState.getFirst("state") : null;
        String redirectScope = redirectState != null ? redirectState.getFirst("scope") : null;
        String theScope = redirectScope != null ? redirectScope : this.scopes;
        UriBuilder ub = OAuthClientUtils.getAuthorizationURIBuilder(this.authorizationServiceUri, this.consumer.getClientId(), this.getAbsoluteRedirectUri(ui).toString(), theState, theScope);
        this.setFormPostResponseMode(ub, redirectState);
        this.setCodeVerifier(ub, redirectState);
        this.setAdditionalCodeRequestParams(ub, redirectState, codeRequestState);
        URI uri = ub.build(new Object[0]);
        return Response.seeOther(uri).build();
    }

    protected void setFormPostResponseMode(UriBuilder ub, MultivaluedMap<String, String> redirectState) {
        if (this.setFormPostResponseMode) {
            ub.queryParam("response_mode", "form_post");
        }
    }

    protected void setCodeVerifier(UriBuilder ub, MultivaluedMap<String, String> redirectState) {
        if (this.codeVerifierTransformer != null) {
            String codeVerifier = redirectState.getFirst("code_verifier");
            ub.queryParam("code_challenge", this.codeVerifierTransformer.transformCodeVerifier(codeVerifier));
            ub.queryParam("code_challenge_method", this.codeVerifierTransformer.getChallengeMethod());
        }
    }

    protected void setAdditionalCodeRequestParams(UriBuilder ub, MultivaluedMap<String, String> redirectState, MultivaluedMap<String, String> codeRequestState) {
    }

    private URI getAbsoluteRedirectUri(UriInfo ui) {
        if (this.redirectUri != null) {
            return URI.create(this.redirectUri);
        }
        if (this.completeUri != null) {
            return this.completeUri.startsWith("http") ? URI.create(this.completeUri) : ui.getBaseUriBuilder().path(this.completeUri).build(new Object[0]);
        }
        return ui.getAbsolutePath();
    }

    protected void processCodeResponse(ContainerRequestContext rc, UriInfo ui, MultivaluedMap<String, String> requestParams) {
        MultivaluedMap<String, String> state = null;
        if (this.clientStateManager != null) {
            state = this.clientStateManager.fromRedirectState(this.mc, requestParams);
        }
        String codeParam = requestParams.getFirst("code");
        ClientAccessToken at = null;
        if (codeParam != null) {
            AuthorizationCodeGrant grant = this.prepareCodeGrant(codeParam, this.getAbsoluteRedirectUri(ui));
            if (state != null) {
                grant.setCodeVerifier(state.getFirst("code_verifier"));
            }
            at = OAuthClientUtils.getAccessToken(this.accessTokenServiceClient, this.consumer, (AccessTokenGrant)grant, this.useAuthorizationHeader);
        }
        ClientTokenContext tokenContext = this.initializeClientTokenContext(rc, at, requestParams, state);
        if (at != null && this.clientTokenContextManager != null) {
            this.clientTokenContextManager.setClientTokenContext(this.mc, tokenContext);
        }
        this.setClientCodeRequest(tokenContext);
    }

    private AuthorizationCodeGrant prepareCodeGrant(String codeParam, URI absoluteRedirectUri) {
        if (this.codeRequestJoseProducer == null) {
            return new AuthorizationCodeGrant(codeParam, absoluteRedirectUri);
        }
        JwtRequestCodeGrant grant = new JwtRequestCodeGrant(codeParam, absoluteRedirectUri, this.consumer.getClientId());
        grant.setClientSecret(this.consumer.getClientSecret());
        grant.setJoseProducer(this.codeRequestJoseProducer);
        return grant;
    }

    protected ClientTokenContext initializeClientTokenContext(ContainerRequestContext rc, ClientAccessToken at, MultivaluedMap<String, String> requestParams, MultivaluedMap<String, String> state) {
        ClientTokenContext tokenContext = this.createTokenContext(rc, at, requestParams, state);
        ((ClientTokenContextImpl)tokenContext).setToken(at);
        ((ClientTokenContextImpl)tokenContext).setState(state);
        return tokenContext;
    }

    protected ClientTokenContext createTokenContext(ContainerRequestContext rc, ClientAccessToken at, MultivaluedMap<String, String> requestParams, MultivaluedMap<String, String> state) {
        return new ClientTokenContextImpl();
    }

    private void setClientCodeRequest(ClientTokenContext request) {
        JAXRSUtils.getCurrentMessage().setContent(ClientTokenContext.class, request);
    }

    protected MultivaluedMap<String, String> createRedirectState(ContainerRequestContext rc, UriInfo ui, MultivaluedMap<String, String> codeRequestState) {
        if (this.clientStateManager == null) {
            return new MetadataMap<String, String>();
        }
        String codeVerifier = null;
        if (this.codeVerifierTransformer != null) {
            codeVerifier = Base64UrlUtility.encode(CryptoUtils.generateSecureRandomBytes(32));
            codeRequestState.putSingle("code_verifier", codeVerifier);
        }
        MultivaluedMap<String, String> redirectState = this.clientStateManager.toRedirectState(this.mc, codeRequestState);
        if (codeVerifier != null) {
            redirectState.putSingle("code_verifier", codeVerifier);
        }
        return redirectState;
    }

    protected MultivaluedMap<String, String> toCodeRequestState(ContainerRequestContext rc, UriInfo ui) {
        MultivaluedMap<String, String> state = this.toRequestState(rc, ui);
        if (state == null) {
            state = new MetadataMap<String, String>();
        }
        return state;
    }

    protected MultivaluedMap<String, String> toRequestState(ContainerRequestContext rc, UriInfo ui) {
        MetadataMap<String, String> requestState = new MetadataMap<String, String>();
        requestState.putAll((Map<String, String>)ui.getQueryParameters(this.decodeRequestParameters));
        if (MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(rc.getMediaType())) {
            String body = FormUtils.readBody(rc.getEntityStream(), StandardCharsets.UTF_8.name());
            FormUtils.populateMapFromString(requestState, JAXRSUtils.getCurrentMessage(), body, StandardCharsets.UTF_8.name(), this.decodeRequestParameters);
        }
        return requestState;
    }

    public void setScopeList(List<String> list) {
        this.setScopes(String.join((CharSequence)" ", list));
    }

    public void setScopes(String scopes) {
        this.scopes = scopes.trim();
    }

    public void setStartUri(String relStartUri) {
        this.startUri = relStartUri;
    }

    public void setAuthorizationServiceUri(String authorizationServiceUri) {
        this.authorizationServiceUri = authorizationServiceUri;
    }

    public void setCompleteUri(String completeUri) {
        this.completeUri = completeUri;
    }

    public void setAccessTokenServiceClient(WebClient accessTokenServiceClient) {
        this.accessTokenServiceClient = accessTokenServiceClient;
    }

    public void setClientCodeStateManager(ClientCodeStateManager manager) {
        this.clientStateManager = manager;
    }

    public void setClientTokenContextManager(ClientTokenContextManager clientTokenContextManager) {
        this.clientTokenContextManager = clientTokenContextManager;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public void setDecodeRequestParameters(boolean decodeRequestParameters) {
        this.decodeRequestParameters = decodeRequestParameters;
    }

    protected ClientTokenContext getClientTokenContext(ContainerRequestContext rc) {
        ClientAccessToken newAt;
        ClientTokenContext ctx = null;
        if (this.clientTokenContextManager != null && (ctx = this.clientTokenContextManager.getClientTokenContext(this.mc)) != null && (newAt = this.refreshAccessTokenIfExpired(ctx.getToken())) != null) {
            ((ClientTokenContextImpl)ctx).setToken(newAt);
            this.clientTokenContextManager.setClientTokenContext(this.mc, ctx);
        }
        return ctx;
    }

    private ClientAccessToken refreshAccessTokenIfExpired(ClientAccessToken at) {
        if (at.getRefreshToken() != null && (this.expiryThreshold > 0L && OAuthUtils.isExpired(at.getIssuedAt(), at.getExpiresIn() - this.expiryThreshold) || OAuthUtils.isExpired(at.getIssuedAt(), at.getExpiresIn()))) {
            return OAuthClientUtils.refreshAccessToken(this.accessTokenServiceClient, this.consumer, at);
        }
        return null;
    }

    public void setExpiryThreshold(long expiryThreshold) {
        this.expiryThreshold = expiryThreshold;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setSetFormPostResponseMode(boolean setFormPostResponseMode) {
        this.setFormPostResponseMode = setFormPostResponseMode;
    }

    public void setBlockAccessDeniedResponses(boolean blockAccessDeniedResponses) {
        this.faultAccessDeniedResponses = blockAccessDeniedResponses;
    }

    public void setApplicationCanHandleAccessDenied(boolean applicationCanHandleAccessDenied) {
        this.applicationCanHandleAccessDenied = applicationCanHandleAccessDenied;
    }

    public void setCodeVerifierTransformer(CodeVerifierTransformer codeVerifierTransformer) {
        this.codeVerifierTransformer = codeVerifierTransformer;
    }

    public void setCodeRequestJoseProducer(OAuthJoseJwtProducer codeRequestJoseProducer) {
        this.codeRequestJoseProducer = codeRequestJoseProducer;
    }

    public void setUseAuthorizationHeader(boolean useAuthorizationHeader) {
        this.useAuthorizationHeader = useAuthorizationHeader;
    }
}

