/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.MapKeyColumn;
import javax.persistence.OrderColumn;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.oauth2.common.AuthenticationMethod;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

@XmlRootElement
@Entity
public class UserSubject
implements Serializable {
    private static final long serialVersionUID = -1469694589163385689L;
    private String login;
    private String id;
    private List<String> roles = new LinkedList<String>();
    private Map<String, String> properties = new HashMap<String, String>();
    private AuthenticationMethod am;

    public UserSubject() {
        this.id = this.newId();
    }

    public UserSubject(String login) {
        this();
        this.login = login;
    }

    public UserSubject(String login, List<String> roles) {
        this();
        this.login = login;
        this.roles = roles;
    }

    public UserSubject(String login, String id) {
        this.login = login;
        this.id = id != null ? id : this.newId();
    }

    public UserSubject(String login, String id, List<String> roles) {
        this.login = login;
        this.id = id != null ? id : this.newId();
        this.roles = roles;
    }

    public UserSubject(UserSubject sub) {
        this(sub.getLogin(), sub.getId(), sub.getRoles());
        this.properties = sub.getProperties();
        this.am = sub.getAuthenticationMethod();
    }

    private String newId() {
        return Base64UrlUtility.encode(CryptoUtils.generateSecureRandomBytes(16));
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="name")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Id
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.am;
    }

    public void setAuthenticationMethod(AuthenticationMethod method) {
        this.am = method;
    }
}

