/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Ehcache;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AbstractCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.DefaultEHCacheOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public class DefaultEHCacheCodeDataProvider
extends DefaultEHCacheOAuthDataProvider
implements AuthorizationCodeDataProvider {
    public static final String CODE_GRANT_CACHE_KEY = "cxf.oauth2.codegrant.cache";
    private long codeLifetime = 600L;
    private Ehcache codeGrantCache;

    protected DefaultEHCacheCodeDataProvider() {
        this("cxf-oauth2-ehcache.xml", BusFactory.getThreadDefaultBus(true));
    }

    protected DefaultEHCacheCodeDataProvider(String configFileURL, Bus bus) {
        this(configFileURL, bus, "cxf.oauth2.client.cache", CODE_GRANT_CACHE_KEY, "cxf.oauth2.accesstoken.cache", "cxf.oauth2.refreshtoken.cache");
    }

    protected DefaultEHCacheCodeDataProvider(String configFileURL, Bus bus, String clientCacheKey, String codeCacheKey, String accessTokenKey, String refreshTokenKey) {
        super(configFileURL, bus, clientCacheKey, accessTokenKey, refreshTokenKey);
        this.codeGrantCache = DefaultEHCacheCodeDataProvider.createCache(this.cacheManager, codeCacheKey);
    }

    @Override
    protected void doRemoveClient(Client c) {
        this.removeClientCodeGrants(c);
        super.doRemoveClient(c);
    }

    protected void removeClientCodeGrants(Client c) {
        for (ServerAuthorizationCodeGrant grant : this.getCodeGrants(c, null)) {
            this.removeCodeGrant(grant.getCode());
        }
    }

    @Override
    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = this.doCreateCodeGrant(reg);
        this.saveCodeGrant(grant);
        return grant;
    }

    protected ServerAuthorizationCodeGrant doCreateCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        return AbstractCodeDataProvider.initCodeGrant(reg, this.codeLifetime);
    }

    @Override
    public List<ServerAuthorizationCodeGrant> getCodeGrants(Client c, UserSubject sub) {
        List<String> keys = CastUtils.cast(this.codeGrantCache.getKeys());
        ArrayList<ServerAuthorizationCodeGrant> grants = new ArrayList<ServerAuthorizationCodeGrant>(keys.size());
        for (String key : keys) {
            ServerAuthorizationCodeGrant grant = this.getCodeGrant(key);
            if (!AbstractCodeDataProvider.isCodeMatched(grant, c, sub)) continue;
            grants.add(grant);
        }
        return grants;
    }

    @Override
    public ServerAuthorizationCodeGrant removeCodeGrant(String code) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = this.getCodeGrant(code);
        if (grant != null) {
            this.codeGrantCache.remove((Serializable)((Object)code));
        }
        return grant;
    }

    public ServerAuthorizationCodeGrant getCodeGrant(String code) throws OAuthServiceException {
        return DefaultEHCacheCodeDataProvider.getCacheValue(this.codeGrantCache, code, ServerAuthorizationCodeGrant.class);
    }

    protected void saveCodeGrant(ServerAuthorizationCodeGrant grant) {
        DefaultEHCacheCodeDataProvider.putCacheValue(this.codeGrantCache, grant.getCode(), grant, grant.getExpiresIn());
    }

    public void setCodeLifetime(long codeLifetime) {
        this.codeLifetime = codeLifetime;
    }
}

