/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.jwt;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public abstract class AbstractJwtBearerGrant
implements AccessTokenGrant {
    private static final long serialVersionUID = 5754722119855372511L;
    private String assertion;
    private String scope;
    private boolean encoded;
    private String grantType;

    protected AbstractJwtBearerGrant(String grantType, String assertion, boolean encoded, String scope) {
        this.grantType = grantType;
        this.assertion = assertion;
        this.encoded = encoded;
        this.scope = scope;
    }

    @Override
    public String getType() {
        return this.grantType;
    }

    protected MultivaluedMap<String, String> initMap() {
        MetadataMap<String, String> map = new MetadataMap<String, String>();
        map.putSingle("grant_type", this.grantType);
        return map;
    }

    protected void addScope(MultivaluedMap<String, String> map) {
        if (this.scope != null) {
            map.putSingle("scope", this.scope);
        }
    }

    protected String encodeAssertion() {
        if (this.encoded) {
            return this.assertion;
        }
        try {
            return Base64UrlUtility.encode(this.assertion);
        }
        catch (Exception ex) {
            throw new OAuthServiceException(ex.getMessage(), (Throwable)ex);
        }
    }
}

