/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AbstractOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.bearer.BearerAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;

public class JPAOAuthDataProvider
extends AbstractOAuthDataProvider {
    private static final String CLIENT_QUERY = "SELECT client FROM Client client INNER JOIN client.resourceOwnerSubject ros";
    private EntityManagerFactory entityManagerFactory;

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    @Override
    public Client doGetClient(final String clientId) throws OAuthServiceException {
        return this.execute(new EntityManagerOperation<Client>(){

            @Override
            public Client execute(EntityManager em) {
                return (Client)em.find(Client.class, (Object)clientId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(EntityManagerOperation<T> operation) {
        T value;
        EntityManager em = this.getEntityManager();
        try {
            value = operation.execute(em);
        }
        finally {
            this.closeIfNeeded(em);
        }
        return value;
    }

    protected <T> T executeInTransaction(EntityManagerOperation<T> operation) {
        T value;
        EntityManager em = this.getEntityManager();
        EntityTransaction transaction = null;
        try {
            transaction = this.beginIfNeeded(em);
            value = operation.execute(em);
            this.flushIfNeeded(em);
            this.commitIfNeeded(em);
        }
        catch (RuntimeException e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            this.closeIfNeeded(em);
        }
        return value;
    }

    @Override
    public void setClient(final Client client) {
        this.executeInTransaction(new EntityManagerOperation<Void>(){

            @Override
            public Void execute(EntityManager em) {
                boolean clientExists;
                if (client.getResourceOwnerSubject() != null) {
                    UserSubject sub = (UserSubject)em.find(UserSubject.class, (Object)client.getResourceOwnerSubject().getId());
                    if (sub == null) {
                        em.persist((Object)client.getResourceOwnerSubject());
                    } else {
                        client.setResourceOwnerSubject(sub);
                    }
                }
                boolean bl = clientExists = (Long)em.createQuery("SELECT count(client) from Client client where client.clientId = :id", Long.class).setParameter("id", (Object)client.getClientId()).getSingleResult() > 0L;
                if (clientExists) {
                    em.merge((Object)client);
                } else {
                    em.persist((Object)client);
                }
                return null;
            }
        });
    }

    @Override
    protected void doRemoveClient(final Client c) {
        this.executeInTransaction(new EntityManagerOperation<Void>(){

            @Override
            public Void execute(EntityManager em) {
                Client clientToRemove = (Client)em.getReference(Client.class, (Object)c.getClientId());
                em.remove((Object)clientToRemove);
                return null;
            }
        });
    }

    @Override
    public List<Client> getClients(final UserSubject resourceOwner) {
        return this.execute(new EntityManagerOperation<List<Client>>(){

            @Override
            public List<Client> execute(EntityManager em) {
                return JPAOAuthDataProvider.this.getClientsQuery(resourceOwner, em).getResultList();
            }
        });
    }

    @Override
    public List<ServerAccessToken> getAccessTokens(final Client c, final UserSubject sub) {
        return this.execute(new EntityManagerOperation<List<ServerAccessToken>>(){

            @Override
            public List<ServerAccessToken> execute(EntityManager em) {
                return CastUtils.cast(JPAOAuthDataProvider.this.getTokensQuery(c, sub, em).getResultList());
            }
        });
    }

    @Override
    public List<RefreshToken> getRefreshTokens(final Client c, final UserSubject sub) {
        return this.execute(new EntityManagerOperation<List<RefreshToken>>(){

            @Override
            public List<RefreshToken> execute(EntityManager em) {
                return JPAOAuthDataProvider.this.getRefreshTokensQuery(c, sub, em).getResultList();
            }
        });
    }

    @Override
    public ServerAccessToken getAccessToken(final String accessToken) throws OAuthServiceException {
        return this.execute(new EntityManagerOperation<ServerAccessToken>(){

            @Override
            public ServerAccessToken execute(EntityManager em) {
                TypedQuery query = em.createQuery("SELECT t FROM BearerAccessToken t WHERE t.tokenKey = :tokenKey", BearerAccessToken.class).setParameter("tokenKey", (Object)accessToken);
                if (query.getResultList().isEmpty()) {
                    return null;
                }
                return (ServerAccessToken)query.getSingleResult();
            }
        });
    }

    @Override
    protected void doRevokeAccessToken(final ServerAccessToken at) {
        this.executeInTransaction(new EntityManagerOperation<Void>(){

            @Override
            public Void execute(EntityManager em) {
                ServerAccessToken tokenToRemove = (ServerAccessToken)em.getReference(at.getClass(), (Object)at.getTokenKey());
                em.remove((Object)tokenToRemove);
                return null;
            }
        });
    }

    @Override
    protected void linkRefreshTokenToAccessToken(RefreshToken rt, final ServerAccessToken at) {
        super.linkRefreshTokenToAccessToken(rt, at);
        this.executeInTransaction(new EntityManagerOperation<Void>(){

            @Override
            public Void execute(EntityManager em) {
                em.merge((Object)at);
                return null;
            }
        });
    }

    @Override
    protected RefreshToken getRefreshToken(final String refreshTokenKey) {
        return this.execute(new EntityManagerOperation<RefreshToken>(){

            @Override
            public RefreshToken execute(EntityManager em) {
                return (RefreshToken)em.find(RefreshToken.class, (Object)refreshTokenKey);
            }
        });
    }

    @Override
    protected void doRevokeRefreshToken(final RefreshToken rt) {
        this.executeInTransaction(new EntityManagerOperation<Void>(){

            @Override
            public Void execute(EntityManager em) {
                RefreshToken tokentoRemove = (RefreshToken)em.getReference(RefreshToken.class, (Object)rt.getTokenKey());
                em.remove((Object)tokentoRemove);
                return null;
            }
        });
    }

    @Override
    protected ServerAccessToken doCreateAccessToken(AccessTokenRegistration atReg) {
        ServerAccessToken at = super.doCreateAccessToken(atReg);
        if (at.getAudiences() != null) {
            at.setAudiences(new ArrayList<String>(at.getAudiences()));
        }
        if (at.getExtraProperties() != null) {
            at.setExtraProperties(new HashMap<String, String>(at.getExtraProperties()));
        }
        if (at.getScopes() != null) {
            at.setScopes(new ArrayList<OAuthPermission>(at.getScopes()));
        }
        if (at.getParameters() != null) {
            at.setParameters(new HashMap<String, String>(at.getParameters()));
        }
        return at;
    }

    @Override
    protected void saveAccessToken(final ServerAccessToken serverToken) {
        this.executeInTransaction(new EntityManagerOperation<Void>(){

            @Override
            public Void execute(EntityManager em) {
                LinkedList<OAuthPermission> perms = new LinkedList<OAuthPermission>();
                for (OAuthPermission perm : serverToken.getScopes()) {
                    OAuthPermission permSaved = (OAuthPermission)em.find(OAuthPermission.class, (Object)perm.getPermission());
                    if (permSaved != null) {
                        perms.add(permSaved);
                        continue;
                    }
                    em.persist((Object)perm);
                    perms.add(perm);
                }
                serverToken.setScopes(perms);
                if (serverToken.getSubject() != null) {
                    UserSubject sub = (UserSubject)em.find(UserSubject.class, (Object)serverToken.getSubject().getId());
                    if (sub == null) {
                        em.persist((Object)serverToken.getSubject());
                    } else {
                        sub = (UserSubject)em.merge((Object)serverToken.getSubject());
                        serverToken.setSubject(sub);
                    }
                }
                if (serverToken.getClient() != null) {
                    serverToken.setClient((Client)em.find(Client.class, (Object)serverToken.getClient().getClientId()));
                }
                em.persist((Object)serverToken);
                return null;
            }
        });
    }

    @Override
    protected void saveRefreshToken(RefreshToken refreshToken) {
        this.persistEntity(refreshToken);
    }

    protected void persistEntity(final Object entity) {
        this.executeInTransaction(new EntityManagerOperation<Void>(){

            @Override
            public Void execute(EntityManager em) {
                em.persist(entity);
                return null;
            }
        });
    }

    protected void removeEntity(final Object entity) {
        this.executeInTransaction(new EntityManagerOperation<Void>(){

            @Override
            public Void execute(EntityManager em) {
                em.remove(entity);
                return null;
            }
        });
    }

    protected TypedQuery<Client> getClientsQuery(UserSubject resourceOwnerSubject, EntityManager entityManager) {
        if (resourceOwnerSubject == null) {
            return entityManager.createQuery(CLIENT_QUERY, Client.class);
        }
        return entityManager.createQuery("SELECT client FROM Client client INNER JOIN client.resourceOwnerSubject ros WHERE ros.login = :login", Client.class).setParameter("login", (Object)resourceOwnerSubject.getLogin());
    }

    protected TypedQuery<BearerAccessToken> getTokensQuery(Client c, UserSubject resourceOwnerSubject, EntityManager entityManager) {
        if (c == null && resourceOwnerSubject == null) {
            return entityManager.createQuery("SELECT t FROM BearerAccessToken t", BearerAccessToken.class);
        }
        if (c == null) {
            return entityManager.createQuery("SELECT t FROM BearerAccessToken t JOIN t.subject s WHERE s.login = :login", BearerAccessToken.class).setParameter("login", (Object)resourceOwnerSubject.getLogin());
        }
        if (resourceOwnerSubject == null) {
            return entityManager.createQuery("SELECT t FROM BearerAccessToken t JOIN t.client c WHERE c.clientId = :clientId", BearerAccessToken.class).setParameter("clientId", (Object)c.getClientId());
        }
        return entityManager.createQuery("SELECT t FROM BearerAccessToken t JOIN t.subject s JOIN t.client c WHERE s.login = :login AND c.clientId = :clientId", BearerAccessToken.class).setParameter("login", (Object)resourceOwnerSubject.getLogin()).setParameter("clientId", (Object)c.getClientId());
    }

    protected TypedQuery<RefreshToken> getRefreshTokensQuery(Client c, UserSubject resourceOwnerSubject, EntityManager entityManager) {
        if (c == null && resourceOwnerSubject == null) {
            return entityManager.createQuery("SELECT t FROM RefreshToken t", RefreshToken.class);
        }
        if (c == null) {
            return entityManager.createQuery("SELECT t FROM RefreshToken t JOIN t.subject s WHERE s.login = :login", RefreshToken.class).setParameter("login", (Object)resourceOwnerSubject.getLogin());
        }
        if (resourceOwnerSubject == null) {
            return entityManager.createQuery("SELECT t FROM RefreshToken t JOIN t.client c WHERE c.clientId = :clientId", RefreshToken.class).setParameter("clientId", (Object)c.getClientId());
        }
        return entityManager.createQuery("SELECT t FROM RefreshToken t JOIN t.subject s JOIN t.client c WHERE s.login = :login AND c.clientId = :clientId", RefreshToken.class).setParameter("login", (Object)resourceOwnerSubject.getLogin()).setParameter("clientId", (Object)c.getClientId());
    }

    protected EntityManager getEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    protected EntityTransaction beginIfNeeded(EntityManager em) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        return tx;
    }

    protected void flushIfNeeded(EntityManager em) {
        em.flush();
    }

    protected void commitIfNeeded(EntityManager em) {
        em.getTransaction().commit();
    }

    protected void closeIfNeeded(EntityManager em) {
        em.close();
    }

    public static interface EntityManagerOperation<T> {
        public T execute(EntityManager var1);
    }
}

