/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

public final class AuthorizationUtils {
    private AuthorizationUtils() {
    }

    public static String[] getBasicAuthUserInfo(MessageContext mc) {
        String[] parts = AuthorizationUtils.getAuthorizationParts(mc);
        if (parts.length == 2) {
            return AuthorizationUtils.getBasicAuthParts(parts[1]);
        }
        return null;
    }

    public static String[] getBasicAuthParts(String basicAuthData) {
        String authDecoded = null;
        try {
            authDecoded = new String(Base64Utility.decode(basicAuthData));
        }
        catch (Exception ex) {
            throw ExceptionUtils.toNotAuthorizedException(ex, null);
        }
        String[] authInfo = authDecoded.split(":");
        if (authInfo.length == 2) {
            return authInfo;
        }
        throw ExceptionUtils.toNotAuthorizedException(null, null);
    }

    public static String[] getAuthorizationParts(MessageContext mc) {
        return AuthorizationUtils.getAuthorizationParts(mc, Collections.singleton("Basic"));
    }

    public static String[] getAuthorizationParts(MessageContext mc, Set<String> challenges) {
        return AuthorizationUtils.getAuthorizationParts(mc, challenges, null);
    }

    public static String[] getAuthorizationParts(MessageContext mc, Set<String> challenges, String realm) {
        String[] parts;
        List<String> headers = mc.getHttpHeaders().getRequestHeader("Authorization");
        if (headers != null && headers.size() == 1 && (parts = headers.get(0).split(" ")).length > 0 && (challenges == null || challenges.isEmpty() || challenges.contains(parts[0]) || challenges.size() == 1 && challenges.contains("*"))) {
            return parts;
        }
        AuthorizationUtils.throwAuthorizationFailure(challenges, realm);
        return null;
    }

    public static void throwAuthorizationFailure(Set<String> challenges) {
        AuthorizationUtils.throwAuthorizationFailure(challenges, null);
    }

    public static void throwAuthorizationFailure(Set<String> challenges, String realm) {
        AuthorizationUtils.throwAuthorizationFailure(challenges, realm, null);
    }

    public static void throwAuthorizationFailure(Set<String> challenges, String realm, Throwable cause) {
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder(401);
        StringBuilder sb = new StringBuilder();
        for (String challenge : challenges) {
            if ("*".equals(challenge)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(challenge);
        }
        if (sb.length() > 0) {
            if (realm != null) {
                sb.append(" realm=\"" + realm + "\"");
            }
            rb.header("WWW-Authenticate", sb.toString());
        }
        Response r = null;
        r = cause != null ? rb.entity(cause.getMessage()).build() : rb.build();
        throw ExceptionUtils.toNotAuthorizedException(cause, r);
    }
}

