/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.component.lucene.LuceneComponent;
import org.apache.camel.component.lucene.LuceneConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.lucene.analysis.Analyzer;

public class LuceneComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private LuceneConfiguration getOrCreateConfig(LuceneComponent target) {
        if (target.getConfig() == null) {
            target.setConfig(new LuceneConfiguration());
        }
        return target.getConfig();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        LuceneComponent target = (LuceneComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "analyzer": {
                this.getOrCreateConfig(target).setAnalyzer(LuceneComponentConfigurer.property(camelContext, Analyzer.class, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(LuceneComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "config": {
                target.setConfig(LuceneComponentConfigurer.property(camelContext, LuceneConfiguration.class, value));
                return true;
            }
            case "indexdir": 
            case "indexDir": {
                this.getOrCreateConfig(target).setIndexDir(LuceneComponentConfigurer.property(camelContext, File.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(LuceneComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxhits": 
            case "maxHits": {
                this.getOrCreateConfig(target).setMaxHits(LuceneComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "srcdir": 
            case "srcDir": {
                this.getOrCreateConfig(target).setSrcDir(LuceneComponentConfigurer.property(camelContext, File.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "analyzer": {
                return Analyzer.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "config": {
                return LuceneConfiguration.class;
            }
            case "indexdir": 
            case "indexDir": {
                return File.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxhits": 
            case "maxHits": {
                return Integer.TYPE;
            }
            case "srcdir": 
            case "srcDir": {
                return File.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        LuceneComponent target = (LuceneComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "analyzer": {
                return this.getOrCreateConfig(target).getAnalyzer();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "config": {
                return target.getConfig();
            }
            case "indexdir": 
            case "indexDir": {
                return this.getOrCreateConfig(target).getIndexDir();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxhits": 
            case "maxHits": {
                return this.getOrCreateConfig(target).getMaxHits();
            }
            case "srcdir": 
            case "srcDir": {
                return this.getOrCreateConfig(target).getSrcDir();
            }
        }
        return null;
    }
}

