/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.component.lucene.LuceneComponent;
import org.apache.camel.component.lucene.LuceneOperation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

@UriParams
public class LuceneConfiguration {
    private transient URI uri;
    private transient String authority;
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriPath
    @Metadata(required=true)
    private LuceneOperation operation;
    @UriParam
    private File srcDir;
    @UriParam
    private File indexDir;
    @UriParam
    private Analyzer analyzer;
    @UriParam
    private int maxHits;

    public LuceneConfiguration() {
    }

    public LuceneConfiguration(URI uri) {
        this.uri = uri;
    }

    public void parseURI(URI uri, Map<String, Object> parameters, LuceneComponent component) throws Exception {
        String protocol = uri.getScheme();
        if (!protocol.equalsIgnoreCase("lucene")) {
            throw new IllegalArgumentException("Unrecognized Lucene protocol: " + protocol + " for uri: " + uri);
        }
        this.uri = uri;
        this.authority = uri.getAuthority();
        if (!this.isValidAuthority()) {
            throw new URISyntaxException(uri.toASCIIString(), "Incorrect URI syntax and/or Operation specified for the Lucene endpoint. Please specify the syntax as \"lucene:[Endpoint Name]:[Operation]?[Query]\"");
        }
        this.setHost(this.retrieveTokenFromAuthority("hostname"));
        String op = this.retrieveTokenFromAuthority("operation");
        if (op != null) {
            op = op.toLowerCase();
        }
        this.setOperation(LuceneOperation.valueOf(op));
        this.srcDir = component.resolveAndRemoveReferenceParameter(parameters, "srcDir", File.class, null);
        this.indexDir = component.resolveAndRemoveReferenceParameter(parameters, "indexDir", File.class, new File("file:///./indexDirectory"));
        this.analyzer = component.resolveAndRemoveReferenceParameter(parameters, "analyzer", Analyzer.class, new StandardAnalyzer());
        this.setMaxHits(component.getAndRemoveParameter(parameters, "maxHits", Integer.class, 10));
    }

    private boolean isValidAuthority() {
        return this.authority.contains(":") && this.authority.split(":")[0] != null && !this.insertOrQueryCheck();
    }

    private boolean insertOrQueryCheck() {
        return !this.authority.split(":")[1].equalsIgnoreCase("insert") && !this.authority.split(":")[1].equalsIgnoreCase("query");
    }

    private String retrieveTokenFromAuthority(String token) {
        String retval = token.equalsIgnoreCase("hostname") ? this.uri.getAuthority().split(":")[0] : this.uri.getAuthority().split(":")[1];
        return retval;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public LuceneOperation getOperation() {
        return this.operation;
    }

    public void setOperation(LuceneOperation operation) {
        this.operation = operation;
    }

    public File getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public File getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(File indexDir) {
        this.indexDir = indexDir;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void setMaxHits(int maxHits) {
        this.maxHits = maxHits;
    }
}

