/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack.io;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LumberjackSessionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LumberjackSessionHandler.class);
    private static final int ACK_UNSET = -1;
    private volatile int version = -1;
    private volatile int windowSize = 1;
    private volatile int nextAck = -1;

    LumberjackSessionHandler() {
    }

    void versionRead(int version) {
        if (this.version == -1) {
            if (version != 49 && version != 50) {
                throw new RuntimeException("Unsupported frame version=" + version);
            }
            LOG.debug("Lumberjack protocol version is {}", (Object)Character.valueOf((char)version));
            this.version = version;
        } else if (this.version != version) {
            throw new IllegalStateException("Protocol version changed during session from " + this.version + " to " + version);
        }
    }

    void windowSizeRead(int windowSize) {
        LOG.debug("Lumberjack window size is {}", (Object)windowSize);
        this.windowSize = windowSize;
        this.nextAck = -1;
    }

    void notifyMessageProcessed(ChannelHandlerContext ctx, int sequenceNumber) {
        if (this.nextAck == -1) {
            this.nextAck = sequenceNumber + this.windowSize - 1;
        }
        if (sequenceNumber == this.nextAck) {
            LOG.debug("Sequence number is {}. Sending ACK", (Object)sequenceNumber);
            ByteBuf response = ctx.alloc().heapBuffer(6, 6);
            response.writeByte(this.version);
            response.writeByte(65);
            response.writeInt(sequenceNumber);
            ctx.writeAndFlush(response);
        }
    }
}

