/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.lumberjack.LumberjackEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.jsse.SSLContextParameters;

@Component(value="lumberjack")
public class LumberjackComponent
extends DefaultComponent
implements SSLContextParametersAware {
    static final int DEFAULT_PORT = 5044;
    @Metadata(label="security")
    private SSLContextParameters sslContextParameters;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public LumberjackComponent() {
        this(LumberjackEndpoint.class);
    }

    protected LumberjackComponent(Class<? extends LumberjackEndpoint> endpointClass) {
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        int port;
        String host;
        int separatorIndex = remaining.indexOf(58);
        if (separatorIndex >= 0) {
            host = remaining.substring(0, separatorIndex);
            port = Integer.parseInt(remaining.substring(separatorIndex + 1));
        } else {
            host = remaining;
            port = 5044;
        }
        LumberjackEndpoint answer = new LumberjackEndpoint(uri, this, host, port);
        this.setProperties(answer, parameters);
        if (answer.getSslContextParameters() == null) {
            answer.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return answer;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    @Override
    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    @Override
    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

