/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.lzf;

import com.ning.compress.lzf.LZFInputStream;
import com.ning.compress.lzf.LZFOutputStream;
import com.ning.compress.lzf.parallel.PLZFOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;

@Dataformat(value="lzf")
public class LZFDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private boolean parallelCompression;

    @Override
    public String getDataFormatName() {
        return "lzf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        FilterOutputStream compressedOutput = this.parallelCompression ? new PLZFOutputStream(stream) : new LZFOutputStream(stream);
        try {
            IOHelper.copy(is, compressedOutput);
        }
        catch (Throwable throwable) {
            IOHelper.close(is, compressedOutput);
            throw throwable;
        }
        IOHelper.close(is, compressedOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        LZFInputStream compressedInput = null;
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange(exchange);
        try {
            compressedInput = new LZFInputStream(inputStream);
            IOHelper.copy(compressedInput, osb);
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close(osb, compressedInput, inputStream);
            throw throwable;
        }
        IOHelper.close(osb, compressedInput, inputStream);
        return object;
    }

    public boolean isUsingParallelCompression() {
        return this.parallelCompression;
    }

    public void setUsingParallelCompression(boolean parallelCompression) {
        this.parallelCompression = parallelCompression;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

