/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.SearchTerm;
import org.apache.camel.Converter;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.mail.NowSearchTerm;
import org.apache.camel.component.mail.SearchTermBuilder;
import org.apache.camel.component.mail.SimpleSearchTerm;
import org.apache.camel.converter.IOConverter;

@Converter
public final class MailConverters {
    private static final String NOW_DATE_FORMAT = "yyyy-MM-dd HH:mm:SS";
    private static final Pattern NOW_PATTERN = Pattern.compile("now\\s?(\\+|\\-)\\s?(.*)");

    private MailConverters() {
    }

    @Converter
    public static String toString(Message message) throws MessagingException, IOException {
        MimeMultipart multipart;
        Object content = message.getContent();
        if (content instanceof MimeMultipart && (multipart = (MimeMultipart)content).getCount() > 0) {
            BodyPart part = multipart.getBodyPart(0);
            content = part.getContent();
        }
        if (content != null) {
            return content.toString();
        }
        return null;
    }

    @Converter
    public static String toString(Multipart multipart) throws MessagingException, IOException {
        int size = multipart.getCount();
        for (int i = 0; i < size; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            if (!part.getContentType().toLowerCase().startsWith("text")) continue;
            return part.getContent().toString();
        }
        return null;
    }

    @Converter
    public static InputStream toInputStream(Message message) throws IOException, MessagingException {
        return message.getInputStream();
    }

    @Converter
    public static InputStream toInputStream(Multipart multipart) throws IOException, MessagingException {
        String s = MailConverters.toString(multipart);
        if (s == null) {
            return null;
        }
        return IOConverter.toInputStream((String)s, null);
    }

    public static SearchTerm toSearchTerm(SimpleSearchTerm simple, TypeConverter typeConverter) throws ParseException, NoTypeConversionAvailableException {
        Date date;
        long offset;
        String s;
        SearchTermBuilder builder = new SearchTermBuilder();
        if (simple.isUnseen()) {
            builder = builder.unseen();
        }
        if (simple.getSubjectOrBody() != null) {
            String text = simple.getSubjectOrBody();
            builder = builder.subject(text).body(SearchTermBuilder.Op.or, text);
        }
        if (simple.getSubject() != null) {
            builder = builder.subject(simple.getSubject());
        }
        if (simple.getBody() != null) {
            builder = builder.body(simple.getBody());
        }
        if (simple.getFrom() != null) {
            builder = builder.from(simple.getFrom());
        }
        if (simple.getTo() != null) {
            builder = builder.recipient(Message.RecipientType.TO, simple.getTo());
        }
        if (simple.getFromSentDate() != null) {
            s = simple.getFromSentDate();
            if (s.startsWith("now")) {
                offset = MailConverters.extractOffset(s, typeConverter);
                builder = builder.and(new NowSearchTerm(SearchTermBuilder.Comparison.GE.asNum(), true, offset));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(NOW_DATE_FORMAT);
                date = sdf.parse(s);
                builder = builder.sent(SearchTermBuilder.Comparison.GE, date);
            }
        }
        if (simple.getToSentDate() != null) {
            s = simple.getToSentDate();
            if (s.startsWith("now")) {
                offset = MailConverters.extractOffset(s, typeConverter);
                builder = builder.and(new NowSearchTerm(SearchTermBuilder.Comparison.LE.asNum(), true, offset));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(NOW_DATE_FORMAT);
                date = sdf.parse(s);
                builder = builder.sent(SearchTermBuilder.Comparison.LE, date);
            }
        }
        if (simple.getFromReceivedDate() != null) {
            s = simple.getFromReceivedDate();
            if (s.startsWith("now")) {
                long offset2 = MailConverters.extractOffset(s, typeConverter);
                builder = builder.and(new NowSearchTerm(SearchTermBuilder.Comparison.GE.asNum(), false, offset2));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(NOW_DATE_FORMAT);
                date = sdf.parse(s);
                builder = builder.received(SearchTermBuilder.Comparison.GE, date);
            }
        }
        if (simple.getToReceivedDate() != null) {
            s = simple.getToReceivedDate();
            if (s.startsWith("now")) {
                long offset3 = MailConverters.extractOffset(s, typeConverter);
                builder = builder.and(new NowSearchTerm(SearchTermBuilder.Comparison.LE.asNum(), false, offset3));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(NOW_DATE_FORMAT);
                date = sdf.parse(s);
                builder = builder.received(SearchTermBuilder.Comparison.LE, date);
            }
        }
        return builder.build();
    }

    private static long extractOffset(String now, TypeConverter typeConverter) throws NoTypeConversionAvailableException {
        Matcher matcher = NOW_PATTERN.matcher(now);
        if (matcher.matches()) {
            String op = matcher.group(1);
            String remainder = matcher.group(2);
            long offset = (Long)typeConverter.mandatoryConvertTo(Long.TYPE, (Object)remainder);
            if ("+".equals(op)) {
                return offset;
            }
            return -1L * offset;
        }
        return 0L;
    }
}

