/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MailProducer.class);
    private final JavaMailSender sender;

    public MailProducer(MailEndpoint endpoint, JavaMailSender sender) {
        super((Endpoint)endpoint);
        this.sender = sender;
    }

    public void process(Exchange exchange) {
        try {
            MimeMessage mimeMessage;
            Object body = exchange.getIn().getBody();
            if (body instanceof MimeMessage) {
                mimeMessage = (MimeMessage)body;
            } else {
                mimeMessage = new MimeMessage(this.sender.getSession());
                this.getEndpoint().getBinding().populateMailMessage(this.getEndpoint(), mimeMessage, exchange);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending MimeMessage: {}", (Object)MailUtils.dumpMessage(mimeMessage));
            }
            this.sender.send(mimeMessage);
            exchange.getIn().setHeader("CamelMailMessageId", (Object)mimeMessage.getMessageID());
        }
        catch (MessagingException e) {
            exchange.setException((Throwable)e);
        }
        catch (IOException e) {
            exchange.setException((Throwable)e);
        }
    }

    public MailEndpoint getEndpoint() {
        return (MailEndpoint)super.getEndpoint();
    }
}

