/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.NamedNode;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.NodeIdFactory;

@XmlType(name="optionalIdentifiedDefinition")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public abstract class OptionalIdentifiedDefinition<T extends OptionalIdentifiedDefinition<T>>
implements NamedNode,
IdAware {
    private String id;
    private Boolean customId;
    private DescriptionDefinition description;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @XmlAttribute
    @Metadata(description="The id of this node")
    public void setId(String id) {
        this.id = id;
        this.customId = true;
    }

    @Override
    public void setGeneratedId(String id) {
        this.id = id;
        this.customId = null;
    }

    public DescriptionDefinition getDescription() {
        return this.description;
    }

    @XmlElement
    @Metadata(description="The description for this node")
    public void setDescription(DescriptionDefinition description) {
        this.description = description;
    }

    @Override
    public NamedNode getParent() {
        return null;
    }

    public T description(String text) {
        if (text != null) {
            if (this.description == null) {
                this.description = new DescriptionDefinition();
            }
            this.description.setText(text);
        }
        return (T)this;
    }

    public T description(String id, String text, String lang) {
        if (id != null) {
            this.setId(id);
        }
        if (text != null) {
            if (this.description == null) {
                this.description = new DescriptionDefinition();
            }
            this.description.setText(text);
        }
        if (lang != null) {
            if (this.description == null) {
                this.description = new DescriptionDefinition();
            }
            this.description.setLang(lang);
        }
        return (T)this;
    }

    public T id(String id) {
        this.setId(id);
        return (T)this;
    }

    public String idOrCreate(NodeIdFactory factory) {
        if (this.id == null) {
            this.setGeneratedId(factory.createId(this));
        }
        return this.id;
    }

    public Boolean getCustomId() {
        return this.customId;
    }

    @XmlAttribute
    public void setCustomId(Boolean customId) {
        this.customId = customId;
    }

    public boolean hasCustomIdAssigned() {
        return this.customId != null && this.customId != false;
    }

    @Override
    public String getDescriptionText() {
        return this.description != null ? this.description.getText() : null;
    }
}

