/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.component.micrometer.MicrometerEndpoint;
import org.apache.camel.spi.Language;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public abstract class AbstractMicrometerProducer<T extends Meter>
extends DefaultProducer {
    private static final String HEADER_PATTERN = "CamelMetrics*";

    public AbstractMicrometerProducer(MicrometerEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public MicrometerEndpoint getEndpoint() {
        return (MicrometerEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) {
        Message in = exchange.getIn();
        String defaultMetricsName = this.simple(exchange, this.getEndpoint().getMetricsName(), String.class);
        String finalMetricsName = this.getStringHeader(in, "CamelMetricsName", defaultMetricsName);
        Iterable<Tag> defaultTags = this.getEndpoint().getTags();
        Iterable<Tag> headerTags = this.getTagHeader(in, "CamelMetricsTags", Tags.empty());
        Tags finalTags = Tags.concat(defaultTags, headerTags).stream().map(tag -> Tag.of(this.simple(exchange, tag.getKey(), String.class), this.simple(exchange, tag.getValue(), String.class))).reduce(Tags.empty(), (rec$, xva$0) -> ((Tags)rec$).and((Tag)xva$0), Tags::and).and(Tags.of("camelContext", this.getEndpoint().getCamelContext().getName()));
        try {
            this.doProcess(exchange, finalMetricsName, finalTags);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        finally {
            this.clearMetricsHeaders(in);
        }
    }

    protected abstract Function<MeterRegistry, T> registrar(String var1, Iterable<Tag> var2);

    protected void doProcess(Exchange exchange, String name, Iterable<Tag> tags) {
        this.doProcess(exchange, this.getEndpoint(), this.getOrRegisterMeter(name, tags));
    }

    protected T getOrRegisterMeter(String name, Iterable<Tag> tags) {
        MeterRegistry registry = this.getEndpoint().getRegistry();
        return (T)((Meter)this.registrar(name, tags).apply(registry));
    }

    protected abstract void doProcess(Exchange var1, MicrometerEndpoint var2, T var3);

    protected <C> C simple(Exchange exchange, String expression, Class<C> clazz) {
        Language language;
        Expression simple;
        if (expression != null && (simple = (language = exchange.getContext().resolveLanguage("simple")).createExpression(expression)) != null) {
            return simple.evaluate(exchange, clazz);
        }
        return this.getEndpoint().getCamelContext().getTypeConverter().convertTo(clazz, expression);
    }

    protected String getStringHeader(Message in, String header, String defaultValue) {
        String headerValue = in.getHeader(header, String.class);
        return ObjectHelper.isNotEmpty(headerValue) ? headerValue : defaultValue;
    }

    protected Double getDoubleHeader(Message in, String header, Double defaultValue) {
        return in.getHeader(header, defaultValue, Double.class);
    }

    protected Iterable<Tag> getTagHeader(Message in, String header, Iterable<Tag> defaultTags) {
        return in.getHeader(header, defaultTags, Iterable.class);
    }

    protected boolean clearMetricsHeaders(Message in) {
        return in.removeHeaders(HEADER_PATTERN);
    }
}

