/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.micrometer.AbstractMicrometerProducer;
import org.apache.camel.component.micrometer.MicrometerEndpoint;

public class CounterProducer
extends AbstractMicrometerProducer<Counter> {
    public CounterProducer(MicrometerEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected Function<MeterRegistry, Counter> registrar(String name, Iterable<Tag> tags) {
        return meterRegistry -> meterRegistry.counter(name, tags);
    }

    @Override
    protected void doProcess(Exchange exchange, MicrometerEndpoint endpoint, Counter counter) {
        Message in = exchange.getIn();
        Double increment = this.simple(exchange, endpoint.getIncrement(), Double.class);
        Double decrement = this.simple(exchange, endpoint.getDecrement(), Double.class);
        Double finalIncrement = this.getDoubleHeader(in, "CamelMetricsCounterIncrement", increment);
        Double finalDecrement = this.getDoubleHeader(in, "CamelMetricsCounterDecrement", decrement);
        if (finalIncrement != null) {
            counter.increment(finalIncrement);
        } else if (finalDecrement != null) {
            counter.increment(-finalDecrement.doubleValue());
        } else {
            counter.increment();
        }
    }
}

