/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.time.Duration;
import java.util.function.Predicate;
import org.apache.camel.component.micrometer.MicrometerConstants;

public class DistributionStatisticConfigFilter
implements MeterFilter {
    private Predicate<Meter.Id> appliesTo = MicrometerConstants.ALWAYS;
    private Long maximumExpectedValue;
    private Long minimumExpectedValue;
    private Boolean publishPercentileHistogram = true;
    private Integer percentilePrecision;
    private Integer bufferLength;
    private Duration expiry;
    private double[] percentiles;
    private long[] slas;

    @Override
    public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
        if (MicrometerConstants.CAMEL_METERS.and(this.appliesTo).test(id)) {
            return DistributionStatisticConfig.builder().percentilesHistogram(this.publishPercentileHistogram).percentiles(this.percentiles).percentilePrecision(this.percentilePrecision).maximumExpectedValue(this.maximumExpectedValue).minimumExpectedValue(this.minimumExpectedValue).sla(this.slas).bufferLength(this.bufferLength).expiry(this.expiry).build().merge(config);
        }
        return config;
    }

    public DistributionStatisticConfigFilter andAppliesTo(Predicate<Meter.Id> appliesTo) {
        this.appliesTo = this.appliesTo.and(appliesTo);
        return this;
    }

    public DistributionStatisticConfigFilter orAppliesTo(Predicate<Meter.Id> appliesTo) {
        this.appliesTo = this.appliesTo.or(appliesTo);
        return this;
    }

    public DistributionStatisticConfigFilter setMaximumExpectedValue(Long maximumExpectedValue) {
        this.maximumExpectedValue = maximumExpectedValue;
        return this;
    }

    public DistributionStatisticConfigFilter setMinimumExpectedValue(Long minimumExpectedValue) {
        this.minimumExpectedValue = minimumExpectedValue;
        return this;
    }

    public DistributionStatisticConfigFilter setMaximumExpectedDuration(Duration maximumExpectedDuration) {
        this.maximumExpectedValue = maximumExpectedDuration.toNanos();
        return this;
    }

    public DistributionStatisticConfigFilter setMinimumExpectedDuration(Duration minimumExpectedDuration) {
        this.minimumExpectedValue = minimumExpectedDuration.toNanos();
        return this;
    }

    public DistributionStatisticConfigFilter setPublishPercentileHistogram(Boolean publishPercentileHistogram) {
        this.publishPercentileHistogram = publishPercentileHistogram;
        return this;
    }

    public DistributionStatisticConfigFilter setBufferLength(Integer bufferLength) {
        this.bufferLength = bufferLength;
        return this;
    }

    public DistributionStatisticConfigFilter setExpiry(Duration expiry) {
        this.expiry = expiry;
        return this;
    }

    public DistributionStatisticConfigFilter setPercentiles(double[] percentiles) {
        this.percentiles = percentiles;
        return this;
    }

    public DistributionStatisticConfigFilter setPercentilePrecision(Integer percentilePrecision) {
        this.percentilePrecision = percentilePrecision;
        return this;
    }

    public DistributionStatisticConfigFilter setSlas(long[] slas) {
        this.slas = slas;
        return this;
    }
}

