/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.component.micrometer.AbstractMicrometerProducer;
import org.apache.camel.component.micrometer.MicrometerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionSummaryProducer
extends AbstractMicrometerProducer<DistributionSummary> {
    private static final Logger LOG = LoggerFactory.getLogger(DistributionSummaryProducer.class);

    public DistributionSummaryProducer(MicrometerEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected Function<MeterRegistry, DistributionSummary> registrar(String name, Iterable<Tag> tags) {
        return meterRegistry -> meterRegistry.summary(name, tags);
    }

    @Override
    protected void doProcess(Exchange exchange, MicrometerEndpoint endpoint, DistributionSummary summary) {
        Double value = this.simple(exchange, endpoint.getValue(), Double.class);
        Double finalValue = this.getDoubleHeader(exchange.getIn(), "CamelMetricsHistogramValue", value);
        if (finalValue != null) {
            summary.record(finalValue);
        } else {
            LOG.warn("Cannot update histogram \"{}\" with null value", (Object)summary.getId().getName());
        }
    }
}

