/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Set;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MicrometerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MicrometerUtils.class);

    public static Meter.Type getByName(String meterName) {
        switch (meterName) {
            case "summary": {
                return Meter.Type.DISTRIBUTION_SUMMARY;
            }
            case "counter": {
                return Meter.Type.COUNTER;
            }
            case "timer": {
                return Meter.Type.TIMER;
            }
        }
        throw new RuntimeCamelException("Unsupported meter type " + meterName);
    }

    public static String getName(Meter.Type type) {
        switch (type) {
            case DISTRIBUTION_SUMMARY: {
                return "summary";
            }
            case COUNTER: {
                return "counter";
            }
            case TIMER: {
                return "timer";
            }
        }
        throw new RuntimeCamelException("Unsupported meter type " + (Object)((Object)type));
    }

    public static MeterRegistry getOrCreateMeterRegistry(Registry camelRegistry, String registryName) {
        LOG.debug("Looking up MeterRegistry from Camel Registry for name \"{}\"", (Object)registryName);
        MeterRegistry result = MicrometerUtils.getMeterRegistryFromCamelRegistry(camelRegistry, registryName);
        if (result == null) {
            LOG.debug("MeterRegistry not found from Camel Registry for name \"{}\"", (Object)registryName);
            LOG.info("Creating new default MeterRegistry");
            result = MicrometerUtils.createMeterRegistry();
        }
        return result;
    }

    public static MeterRegistry getMeterRegistryFromCamelRegistry(Registry camelRegistry, String registryName) {
        MeterRegistry registry = camelRegistry.lookupByNameAndType(registryName, MeterRegistry.class);
        if (registry != null) {
            return registry;
        }
        Set<MeterRegistry> registries = camelRegistry.findByType(MeterRegistry.class);
        if (registries.size() == 1) {
            return registries.iterator().next();
        }
        return null;
    }

    public static MeterRegistry createMeterRegistry() {
        return new SimpleMeterRegistry();
    }
}

