/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerEventNotifierService;
import org.apache.camel.spi.CamelEvent;

public interface MicrometerRouteEventNotifierNamingStrategy {
    public static final Predicate<Meter.Id> EVENT_NOTIFIERS = id -> MicrometerEventNotifierService.class.getSimpleName().equals(id.getTag("serviceName"));
    public static final MicrometerRouteEventNotifierNamingStrategy DEFAULT = new MicrometerRouteEventNotifierNamingStrategy(){

        @Override
        public String getRouteAddedName() {
            return "CamelRoutesAdded";
        }

        @Override
        public String getRouteRunningName() {
            return "CamelRoutesRunning";
        }
    };

    public String getRouteAddedName();

    public String getRouteRunningName();

    default public Tags getTags(CamelContext camelContext) {
        return Tags.of("serviceName", MicrometerEventNotifierService.class.getSimpleName(), "camelContext", camelContext.getName(), "eventType", CamelEvent.RouteEvent.class.getSimpleName());
    }
}

