/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.messagehistory;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import org.apache.camel.Message;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryNamingStrategy;
import org.apache.camel.support.DefaultMessageHistory;

public class MicrometerMessageHistory
extends DefaultMessageHistory {
    private final Route route;
    private final Timer.Sample sample;
    private final MeterRegistry meterRegistry;
    private final MicrometerMessageHistoryNamingStrategy namingStrategy;

    public MicrometerMessageHistory(MeterRegistry meterRegistry, Route route, NamedNode namedNode, MicrometerMessageHistoryNamingStrategy namingStrategy, long timestamp, Message message) {
        super(route.getId(), namedNode, timestamp, message);
        this.meterRegistry = meterRegistry;
        this.route = route;
        this.namingStrategy = namingStrategy;
        this.sample = Timer.start(meterRegistry);
    }

    @Override
    public void nodeProcessingDone() {
        super.nodeProcessingDone();
        Timer timer = Timer.builder(this.namingStrategy.getName(this.route, this.getNode())).tags(this.namingStrategy.getTags(this.route, this.getNode())).description(this.getNode().getDescriptionText()).register(this.meterRegistry);
        this.sample.stop(timer);
    }

    @Override
    public String toString() {
        return "MicrometerMessageHistory[routeId=" + this.getRouteId() + ", node=" + this.getNode().getId() + ']';
    }
}

