/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.messagehistory;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistory;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryNamingStrategy;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryService;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceSupport;

public class MicrometerMessageHistoryFactory
extends ServiceSupport
implements CamelContextAware,
StaticService,
NonManagedService,
MessageHistoryFactory {
    private CamelContext camelContext;
    private MeterRegistry meterRegistry;
    private boolean copyMessage;
    private String nodePattern;
    private boolean prettyPrint = true;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private MicrometerMessageHistoryNamingStrategy namingStrategy = MicrometerMessageHistoryNamingStrategy.DEFAULT;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    public MicrometerMessageHistoryNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerMessageHistoryNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    @Override
    public boolean isCopyMessage() {
        return this.copyMessage;
    }

    @Override
    public void setCopyMessage(boolean copyMessage) {
        this.copyMessage = copyMessage;
    }

    @Override
    public String getNodePattern() {
        return this.nodePattern;
    }

    @Override
    public void setNodePattern(String nodePattern) {
        this.nodePattern = nodePattern;
    }

    @Override
    public MessageHistory newMessageHistory(String routeId, NamedNode namedNode, long timestamp, Exchange exchange) {
        Route route;
        if (this.nodePattern != null) {
            String[] parts;
            String name = namedNode.getShortName();
            for (String part : parts = this.nodePattern.split(",")) {
                boolean match = PatternHelper.matchPattern(name, part);
                if (match) continue;
                return null;
            }
        }
        Message msg = null;
        if (this.copyMessage) {
            msg = exchange.getMessage().copy();
        }
        if ((route = this.camelContext.getRoute(routeId)) != null) {
            return new MicrometerMessageHistory(this.getMeterRegistry(), route, namedNode, this.getNamingStrategy(), timestamp, msg);
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.meterRegistry == null) {
            this.meterRegistry = MicrometerUtils.getOrCreateMeterRegistry(this.camelContext.getRegistry(), "metricsRegistry");
        }
        try {
            MicrometerMessageHistoryService messageHistoryService = this.camelContext.hasService(MicrometerMessageHistoryService.class);
            if (messageHistoryService == null) {
                messageHistoryService = new MicrometerMessageHistoryService();
                messageHistoryService.setMeterRegistry(this.getMeterRegistry());
                messageHistoryService.setPrettyPrint(this.isPrettyPrint());
                messageHistoryService.setDurationUnit(this.getDurationUnit());
                messageHistoryService.setMatchingTags(Tags.of("serviceName", MicrometerMessageHistoryService.class.getSimpleName()));
                this.camelContext.addService(messageHistoryService);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    protected void doStop() {
    }
}

