/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.nio.charset.CharacterCodingException;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class MinaUdpProtocolCodecFactory
implements ProtocolCodecFactory {
    private final CamelContext context;

    public MinaUdpProtocolCodecFactory(CamelContext context) {
        this.context = context;
    }

    public ProtocolEncoder getEncoder() throws Exception {
        return new ProtocolEncoder(){

            public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
                ByteBuffer buf = MinaUdpProtocolCodecFactory.this.toByteBuffer(message);
                buf.flip();
                out.write(buf);
            }

            public void dispose(IoSession session) throws Exception {
            }
        };
    }

    public ProtocolDecoder getDecoder() throws Exception {
        return new ProtocolDecoder(){

            public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
                byte[] bytes = (byte[])MinaUdpProtocolCodecFactory.this.context.getTypeConverter().mandatoryConvertTo(byte[].class, (Object)in);
                out.write(bytes);
            }

            public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
            }

            public void dispose(IoSession session) throws Exception {
            }
        };
    }

    private ByteBuffer toByteBuffer(Object message) throws CharacterCodingException, NoTypeConversionAvailableException {
        byte[] value = (byte[])this.context.getTypeConverter().tryConvertTo(byte[].class, message);
        if (value != null) {
            ByteBuffer answer = ByteBuffer.allocate((int)value.length).setAutoExpand(false);
            answer.put(value);
            return answer;
        }
        return (ByteBuffer)this.context.getTypeConverter().mandatoryConvertTo(ByteBuffer.class, message);
    }
}

