/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina2;

import java.nio.charset.CharacterCodingException;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class Mina2UdpProtocolCodecFactory
implements ProtocolCodecFactory {
    private final CamelContext context;

    public Mina2UdpProtocolCodecFactory(CamelContext context) {
        this.context = context;
    }

    @Override
    public ProtocolEncoder getEncoder(IoSession session) throws Exception {
        return new ProtocolEncoder(){

            @Override
            public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
                IoBuffer buf = Mina2UdpProtocolCodecFactory.this.toIoBuffer(message);
                buf.flip();
                out.write(buf);
            }

            @Override
            public void dispose(IoSession session) throws Exception {
            }
        };
    }

    @Override
    public ProtocolDecoder getDecoder(IoSession session) throws Exception {
        return new ProtocolDecoder(){

            @Override
            public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
                byte[] bytes = (byte[])Mina2UdpProtocolCodecFactory.this.context.getTypeConverter().convertTo(byte[].class, (Object)in);
                out.write(bytes);
            }

            @Override
            public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
            }

            @Override
            public void dispose(IoSession session) throws Exception {
            }
        };
    }

    private IoBuffer toIoBuffer(Object message) throws CharacterCodingException, NoTypeConversionAvailableException {
        byte[] value = (byte[])this.context.getTypeConverter().tryConvertTo(byte[].class, message);
        if (value != null) {
            IoBuffer answer = IoBuffer.allocate(value.length).setAutoExpand(true);
            answer.put(value);
            return answer;
        }
        return (IoBuffer)this.context.getTypeConverter().mandatoryConvertTo(IoBuffer.class, message);
    }
}

