/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.mllp.MllpAcknowledgementReceiveException;
import org.apache.camel.component.mllp.MllpAcknowledgementTimeoutException;
import org.apache.camel.component.mllp.MllpApplicationErrorAcknowledgementException;
import org.apache.camel.component.mllp.MllpApplicationRejectAcknowledgementException;
import org.apache.camel.component.mllp.MllpCommitErrorAcknowledgementException;
import org.apache.camel.component.mllp.MllpCommitRejectAcknowledgementException;
import org.apache.camel.component.mllp.MllpConfiguration;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpInvalidAcknowledgementException;
import org.apache.camel.component.mllp.MllpInvalidMessageException;
import org.apache.camel.component.mllp.MllpNegativeAcknowledgementException;
import org.apache.camel.component.mllp.MllpSocketException;
import org.apache.camel.component.mllp.MllpWriteException;
import org.apache.camel.component.mllp.internal.Hl7Util;
import org.apache.camel.component.mllp.internal.MllpSocketBuffer;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="MLLP Producer")
public class MllpTcpClientProducer
extends DefaultProducer
implements Runnable {
    final Logger log;
    final MllpSocketBuffer mllpBuffer;
    Socket socket;
    ScheduledExecutorService idleTimeoutExecutor;
    private String cachedLocalAddress;
    private String cachedRemoteAddress;
    private String cachedCombinedAddress;

    public MllpTcpClientProducer(MllpEndpoint endpoint) throws SocketException {
        super(endpoint);
        this.log = LoggerFactory.getLogger((String)String.format("%s.%s.%d", this.getClass().getName(), endpoint.getHostname(), endpoint.getPort()));
        this.log.trace("Constructing MllpTcpClientProducer for endpoint URI {}", (Object)endpoint.getEndpointUri());
        this.mllpBuffer = new MllpSocketBuffer(endpoint);
    }

    @ManagedAttribute(description="Last activity time")
    public Date getLastActivityTime() {
        return this.getEndpoint().getLastConnectionActivityTime();
    }

    @ManagedAttribute(description="Connection")
    public String getConnectionAddress() {
        if (this.cachedCombinedAddress != null) {
            return this.cachedCombinedAddress;
        }
        return MllpSocketBuffer.formatAddressString(null, null);
    }

    @ManagedOperation(description="Close Connection")
    public void closeConnection() {
        this.log.info("Close Connection for address {} called via JMX", (Object)this.getConnectionAddress());
        this.mllpBuffer.closeSocket(this.socket);
    }

    @ManagedOperation(description="Reset Connection")
    public void resetConnection() {
        this.log.info("Reset Connection for address {} requested via JMX", (Object)this.getConnectionAddress());
        this.mllpBuffer.resetSocket(this.socket);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.getConfiguration().hasIdleTimeout()) {
            String fullEndpointKey = this.getEndpoint().getEndpointKey();
            String endpointKey = fullEndpointKey.contains("?") ? fullEndpointKey.substring(0, fullEndpointKey.indexOf(63)) : fullEndpointKey;
            this.idleTimeoutExecutor = Executors.newSingleThreadScheduledExecutor(new IdleTimeoutThreadFactory(endpointKey));
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.idleTimeoutExecutor != null) {
            this.idleTimeoutExecutor.shutdown();
            this.idleTimeoutExecutor = null;
        }
        this.mllpBuffer.resetSocket(this.socket);
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void process(Exchange exchange) throws MllpException {
        block38: {
            this.log.trace("process({}) [{}] - entering", (Object)exchange.getExchangeId(), (Object)this.socket);
            this.getEndpoint().updateLastConnectionActivityTicks();
            Message message = exchange.getMessage();
            this.getEndpoint().checkBeforeSendProperties(exchange, this.socket, this.log);
            try {
                byte[] hl7MessageBytes;
                block39: {
                    String exceptionMessage;
                    this.checkConnection();
                    if (this.cachedLocalAddress != null) {
                        message.setHeader("CamelMllpLocalAddress", this.cachedLocalAddress);
                    }
                    if (this.cachedRemoteAddress != null) {
                        message.setHeader("CamelMllpRemoteAddress", this.cachedRemoteAddress);
                    }
                    hl7MessageBytes = null;
                    Object messageBody = message.getBody();
                    if (messageBody == null) {
                        String exceptionMessage2 = String.format("process(%s) [%s] - message body is null", exchange.getExchangeId(), this.socket);
                        exchange.setException(new MllpInvalidMessageException(exceptionMessage2, hl7MessageBytes));
                        return;
                    }
                    if (messageBody instanceof byte[]) {
                        hl7MessageBytes = (byte[])messageBody;
                    } else if (messageBody instanceof String) {
                        String stringBody = (String)messageBody;
                        hl7MessageBytes = stringBody.getBytes(this.getConfiguration().getCharset(exchange));
                        if (this.getConfiguration().hasCharsetName()) {
                            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)this.getConfiguration().getCharsetName());
                        }
                    }
                    this.log.debug("process({}) [{}] - sending message to external system", (Object)exchange.getExchangeId(), (Object)this.socket);
                    try {
                        this.mllpBuffer.setEnvelopedMessage(hl7MessageBytes);
                        this.mllpBuffer.writeTo(this.socket);
                    }
                    catch (MllpSocketException writeEx) {
                        this.log.debug("process({}) [{}] - exception encountered writing payload - attempting reconnect", new Object[]{exchange.getExchangeId(), this.socket, writeEx});
                        try {
                            this.checkConnection();
                            this.log.trace("process({}) [{}] - reconnected succeeded - resending payload", (Object)exchange.getExchangeId(), (Object)this.socket);
                            try {
                                this.mllpBuffer.writeTo(this.socket);
                            }
                            catch (MllpSocketException retryWriteEx) {
                                exceptionMessage = String.format("process(%s) [%s] - exception encountered attempting to write payload after reconnect", exchange.getExchangeId(), this.socket);
                                this.log.warn(exceptionMessage, (Throwable)retryWriteEx);
                                exchange.setException(new MllpWriteException(exceptionMessage, this.mllpBuffer.toByteArrayAndReset(), retryWriteEx));
                            }
                        }
                        catch (IOException reconnectEx) {
                            exceptionMessage = String.format("process(%s) [%s] - exception encountered attempting to reconnect", exchange.getExchangeId(), this.socket);
                            this.log.warn(exceptionMessage, (Throwable)reconnectEx);
                            exchange.setException(new MllpWriteException(exceptionMessage, this.mllpBuffer.toByteArrayAndReset(), writeEx));
                            this.mllpBuffer.resetSocket(this.socket);
                        }
                    }
                    if (this.getConfiguration().getExchangePattern() == ExchangePattern.InOnly) {
                        this.log.debug("process({}) [{}] - not checking acknowledgement from external system", (Object)exchange.getExchangeId(), (Object)this.socket);
                        return;
                    }
                    if (exchange.getException() != null) break block38;
                    this.log.debug("process({}) [{}] - reading acknowledgement from external system", (Object)exchange.getExchangeId(), (Object)this.socket);
                    try {
                        this.mllpBuffer.reset();
                        this.mllpBuffer.readFrom(this.socket);
                    }
                    catch (MllpSocketException receiveAckEx) {
                        this.log.debug("process({}) [{}] - exception encountered reading acknowledgement - attempting reconnect", new Object[]{exchange.getExchangeId(), this.socket, receiveAckEx});
                        try {
                            this.checkConnection();
                        }
                        catch (IOException reconnectEx) {
                            exceptionMessage = String.format("process(%s) [%s] - exception encountered attempting to reconnect after acknowledgement read failure", exchange.getExchangeId(), this.socket);
                            this.log.warn(exceptionMessage, (Throwable)reconnectEx);
                            exchange.setException(new MllpAcknowledgementReceiveException(exceptionMessage, hl7MessageBytes, (Throwable)receiveAckEx));
                            this.mllpBuffer.resetSocket(this.socket);
                        }
                        if (exchange.getException() != null) break block39;
                        this.log.trace("process({}) [{}] - resending payload after successful reconnect", (Object)exchange.getExchangeId(), (Object)this.socket);
                        try {
                            this.mllpBuffer.setEnvelopedMessage(hl7MessageBytes);
                            this.mllpBuffer.writeTo(this.socket);
                        }
                        catch (MllpSocketException writeRetryEx) {
                            exceptionMessage = String.format("process(%s) [%s] - exception encountered attempting to write payload after read failure and successful reconnect", exchange.getExchangeId(), this.socket);
                            this.log.warn(exceptionMessage, (Throwable)writeRetryEx);
                            exchange.setException(new MllpWriteException(exceptionMessage, hl7MessageBytes, receiveAckEx));
                        }
                        if (exchange.getException() == null) {
                            String exceptionMessageFormat;
                            this.log.trace("process({}) [{}] - resend succeeded - reading acknowledgement from external system", (Object)exchange.getExchangeId(), (Object)this.socket);
                            try {
                                this.mllpBuffer.reset();
                                this.mllpBuffer.readFrom(this.socket);
                            }
                            catch (MllpSocketException secondReceiveEx) {
                                exceptionMessageFormat = this.mllpBuffer.isEmpty() ? "process(%s) [%s] - exception encountered reading MLLP Acknowledgement after successful reconnect and resend" : "process(%s) [%s] - exception encountered reading complete MLLP Acknowledgement after successful reconnect and resend";
                                String exceptionMessage3 = String.format(exceptionMessageFormat, exchange.getExchangeId(), this.socket);
                                this.log.warn(exceptionMessage3, (Throwable)secondReceiveEx);
                                exchange.setException(new MllpAcknowledgementReceiveException(exceptionMessage3, hl7MessageBytes, this.mllpBuffer.toByteArrayAndReset(), receiveAckEx));
                            }
                            catch (SocketTimeoutException secondReadTimeoutEx) {
                                exceptionMessageFormat = this.mllpBuffer.isEmpty() ? "process(%s) [%s] - timeout receiving MLLP Acknowledgment after successful reconnect and resend" : "process(%s) [%s] - timeout receiving complete MLLP Acknowledgment after successful reconnect and resend";
                                String exceptionMessage4 = String.format(exceptionMessageFormat, exchange.getExchangeId(), this.socket);
                                this.log.warn(exceptionMessage4, (Throwable)secondReadTimeoutEx);
                                exchange.setException(new MllpAcknowledgementTimeoutException(exceptionMessage4, hl7MessageBytes, this.mllpBuffer.toByteArrayAndReset(), receiveAckEx));
                                this.mllpBuffer.resetSocket(this.socket);
                            }
                        }
                    }
                    catch (SocketTimeoutException timeoutEx) {
                        String exceptionMessageFormat = this.mllpBuffer.isEmpty() ? "process(%s) [%s] - timeout receiving MLLP Acknowledgment" : "process(%s) [%s] - timeout receiving complete MLLP Acknowledgment";
                        exceptionMessage = String.format(exceptionMessageFormat, exchange.getExchangeId(), this.socket);
                        this.log.warn(exceptionMessage, (Throwable)timeoutEx);
                        exchange.setException(new MllpAcknowledgementTimeoutException(exceptionMessage, hl7MessageBytes, this.mllpBuffer.toByteArrayAndReset(), timeoutEx));
                        this.mllpBuffer.resetSocket(this.socket);
                    }
                }
                if (exchange.getException() != null) break block38;
                if (this.mllpBuffer.hasCompleteEnvelope()) {
                    String exceptionMessage;
                    byte[] acknowledgementBytes = this.mllpBuffer.toMllpPayload();
                    this.log.debug("process({}) [{}] - populating message headers with the acknowledgement from the external system", (Object)exchange.getExchangeId(), (Object)this.socket);
                    message.setHeader("CamelMllpAcknowledgement", acknowledgementBytes);
                    if (acknowledgementBytes != null && acknowledgementBytes.length > 0) {
                        message.setHeader("CamelMllpAcknowledgementString", new String(acknowledgementBytes, this.getConfiguration().getCharset(exchange, acknowledgementBytes)));
                    } else {
                        message.setHeader("CamelMllpAcknowledgementString", "");
                    }
                    if (this.getConfiguration().isValidatePayload() && (exceptionMessage = Hl7Util.generateInvalidPayloadExceptionMessage(acknowledgementBytes)) != null) {
                        exchange.setException(new MllpInvalidAcknowledgementException(exceptionMessage, hl7MessageBytes, acknowledgementBytes));
                    }
                    if (exchange.getException() != null) break block38;
                    this.log.debug("process({}) [{}] - processing the acknowledgement from the external system", (Object)exchange.getExchangeId(), (Object)this.socket);
                    try {
                        message.setHeader("CamelMllpAcknowledgementType", this.processAcknowledgment(hl7MessageBytes, acknowledgementBytes));
                    }
                    catch (MllpNegativeAcknowledgementException nackEx) {
                        message.setHeader("CamelMllpAcknowledgementType", nackEx.getAcknowledgmentType());
                        exchange.setException(nackEx);
                    }
                    this.getEndpoint().checkAfterSendProperties(exchange, this.socket, this.log);
                    break block38;
                }
                String exceptionMessage = String.format("process(%s) [%s] - invalid acknowledgement received", exchange.getExchangeId(), this.socket);
                exchange.setException(new MllpInvalidAcknowledgementException(exceptionMessage, hl7MessageBytes, this.mllpBuffer.toByteArrayAndReset()));
            }
            catch (IOException ioEx) {
                this.log.debug("process({}) [{}] - IOException encountered checking connection", new Object[]{exchange.getExchangeId(), this.socket, ioEx});
                exchange.setException(ioEx);
                this.mllpBuffer.resetSocket(this.socket);
            }
            finally {
                this.mllpBuffer.reset();
            }
        }
        this.log.trace("process({}) [{}] - exiting", (Object)exchange.getExchangeId(), (Object)this.socket);
    }

    private String processAcknowledgment(byte[] hl7MessageBytes, byte[] hl7AcknowledgementBytes) throws MllpException {
        String acknowledgementType = "";
        if (hl7AcknowledgementBytes != null && hl7AcknowledgementBytes.length > 3) {
            byte fieldDelim = hl7AcknowledgementBytes[3];
            int msaStartIndex = -1;
            for (int i = 0; i < hl7AcknowledgementBytes.length; ++i) {
                if (13 != hl7AcknowledgementBytes[i]) continue;
                int bM = 77;
                int bS = 83;
                int bC = 67;
                int bA = 65;
                int bE = 69;
                int bR = 82;
                if (hl7AcknowledgementBytes.length <= i + 7 || 77 != hl7AcknowledgementBytes[i + 1] || 83 != hl7AcknowledgementBytes[i + 2] || 65 != hl7AcknowledgementBytes[i + 3] || fieldDelim != hl7AcknowledgementBytes[i + 4]) continue;
                msaStartIndex = i + 1;
                if (65 != hl7AcknowledgementBytes[i + 5] && 67 != hl7AcknowledgementBytes[i + 5]) {
                    String errorMessage = String.format("processAcknowledgment(hl7MessageBytes[%d], hl7AcknowledgementBytes[%d]) - unsupported acknowledgement type: '%s'", hl7MessageBytes == null ? -1 : hl7MessageBytes.length, hl7AcknowledgementBytes.length, new String(hl7AcknowledgementBytes, i + 5, 2));
                    throw new MllpInvalidAcknowledgementException(errorMessage, hl7MessageBytes, hl7AcknowledgementBytes);
                }
                switch (hl7AcknowledgementBytes[i + 6]) {
                    case 65: {
                        if (65 == hl7AcknowledgementBytes[i + 5]) {
                            acknowledgementType = "AA";
                            break;
                        }
                        acknowledgementType = "CA";
                        break;
                    }
                    case 69: {
                        if (65 == hl7AcknowledgementBytes[i + 5]) {
                            throw new MllpApplicationErrorAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                        }
                        throw new MllpCommitErrorAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                    }
                    case 82: {
                        if (65 == hl7AcknowledgementBytes[i + 5]) {
                            throw new MllpApplicationRejectAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                        }
                        throw new MllpCommitRejectAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                    }
                    default: {
                        String errorMessage = "Unsupported acknowledgement type: " + new String(hl7AcknowledgementBytes, i + 5, 2);
                        throw new MllpInvalidAcknowledgementException(errorMessage, hl7MessageBytes, hl7AcknowledgementBytes);
                    }
                }
                break;
            }
            if (-1 == msaStartIndex && this.getConfiguration().isValidatePayload()) {
                throw new MllpInvalidAcknowledgementException("MSA Not found in acknowledgement", hl7MessageBytes, hl7AcknowledgementBytes);
            }
        }
        return acknowledgementType;
    }

    void checkConnection() throws IOException {
        if (null == this.socket || this.socket.isClosed() || !this.socket.isConnected()) {
            SocketAddress remoteSocketAddress;
            if (this.socket == null) {
                this.log.debug("checkConnection() - Socket is null - attempting to establish connection");
            } else if (this.socket.isClosed()) {
                this.log.info("checkConnection() - Socket {} is closed - attempting to establish new connection", (Object)this.socket);
            } else if (!this.socket.isConnected()) {
                this.log.info("checkConnection() - Socket {} is not connected - attempting to establish new connection", (Object)this.socket);
            }
            Socket newSocket = new Socket();
            if (this.getConfiguration().hasKeepAlive()) {
                newSocket.setKeepAlive(this.getConfiguration().getKeepAlive());
            }
            if (this.getConfiguration().hasTcpNoDelay()) {
                newSocket.setTcpNoDelay(this.getConfiguration().getTcpNoDelay());
            }
            if (this.getConfiguration().hasReceiveBufferSize()) {
                newSocket.setReceiveBufferSize(this.getConfiguration().getReceiveBufferSize());
            }
            if (this.getConfiguration().hasSendBufferSize()) {
                newSocket.setSendBufferSize(this.getConfiguration().getSendBufferSize());
            }
            if (this.getConfiguration().hasReuseAddress()) {
                newSocket.setReuseAddress(this.getConfiguration().getReuseAddress());
            }
            newSocket.setSoLinger(false, -1);
            InetSocketAddress socketAddress = null == this.getEndpoint().getHostname() ? new InetSocketAddress(this.getEndpoint().getPort()) : new InetSocketAddress(this.getEndpoint().getHostname(), this.getEndpoint().getPort());
            newSocket.connect(socketAddress, this.getConfiguration().getConnectTimeout());
            this.log.info("checkConnection() - established new connection {}", (Object)newSocket);
            this.getEndpoint().updateLastConnectionEstablishedTicks();
            this.socket = newSocket;
            SocketAddress localSocketAddress = this.socket.getLocalSocketAddress();
            if (localSocketAddress != null) {
                this.cachedLocalAddress = localSocketAddress.toString();
            }
            if ((remoteSocketAddress = this.socket.getRemoteSocketAddress()) != null) {
                this.cachedRemoteAddress = remoteSocketAddress.toString();
            }
            this.cachedCombinedAddress = MllpSocketBuffer.formatAddressString(localSocketAddress, remoteSocketAddress);
            if (this.getConfiguration().hasIdleTimeout()) {
                this.log.debug("Scheduling initial idle producer connection check of {} in {} milliseconds", (Object)this.getConnectionAddress(), (Object)this.getConfiguration().getIdleTimeout());
                this.idleTimeoutExecutor.schedule(this, (long)this.getConfiguration().getIdleTimeout().intValue(), TimeUnit.MILLISECONDS);
            }
        } else {
            this.log.debug("checkConnection() - Connection {} is still valid - no new connection required", (Object)this.socket);
        }
    }

    @Override
    public synchronized void run() {
        if (this.getConfiguration().hasIdleTimeout() && null != this.socket && !this.socket.isClosed() && this.socket.isConnected()) {
            if (this.getEndpoint().hasLastConnectionActivityTicks()) {
                long idleTime = System.currentTimeMillis() - this.getEndpoint().getLastConnectionActivityTicks();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Checking {} for idle connection: {} - {}", new Object[]{this.getConnectionAddress(), idleTime, this.getConfiguration().getIdleTimeout()});
                }
                if (idleTime >= (long)this.getConfiguration().getIdleTimeout().intValue()) {
                    this.log.info("MLLP Connection idle time of '{}' milliseconds met or exceeded the idle producer timeout of '{}' milliseconds - resetting connection", (Object)idleTime, (Object)this.getConfiguration().getIdleTimeout());
                    this.mllpBuffer.resetSocket(this.socket);
                } else {
                    long minDelay = 100L;
                    long delay = Long.min(Long.max(minDelay, (long)this.getConfiguration().getIdleTimeout().intValue() - idleTime), this.getConfiguration().getIdleTimeout().intValue());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Scheduling idle producer connection check of {} in {} milliseconds", (Object)this.getConnectionAddress(), (Object)delay);
                    }
                    this.idleTimeoutExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
                }
            } else {
                this.log.debug("No activity detected since initial connection - scheduling idle producer connection check in {} milliseconds", (Object)this.getConfiguration().getIdleTimeout());
                this.idleTimeoutExecutor.schedule(this, (long)this.getConfiguration().getIdleTimeout().intValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public MllpEndpoint getEndpoint() {
        return (MllpEndpoint)super.getEndpoint();
    }

    public MllpConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    static class IdleTimeoutThreadFactory
    implements ThreadFactory {
        final String endpointKey;

        IdleTimeoutThreadFactory(String endpointKey) {
            this.endpointKey = endpointKey;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread timeoutThread = Executors.defaultThreadFactory().newThread(r);
            timeoutThread.setName(String.format("%s[%s]-idle-timeout-thread", MllpTcpClientProducer.class.getSimpleName(), this.endpointKey));
            return timeoutThread;
        }
    }
}

