/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.nio.charset.Charset;
import org.apache.camel.Exchange;
import org.apache.camel.component.mllp.MllpProtocolConstants;
import org.apache.camel.component.mllp.internal.Hl7Util;
import org.apache.camel.support.ExchangeHelper;

public final class MllpCharsetHelper {
    private MllpCharsetHelper() {
    }

    public static Charset getCharset(Exchange exchange, Charset defaultCharset) {
        String exchangeCharsetName = ExchangeHelper.getCharsetName(exchange, false);
        if (exchangeCharsetName != null && !exchangeCharsetName.isEmpty()) {
            try {
                if (Charset.isSupported(exchangeCharsetName)) {
                    return Charset.forName(exchangeCharsetName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultCharset;
    }

    public static Charset getCharset(Exchange exchange, byte[] hl7Bytes, Hl7Util hl7Util, Charset defaultCharset) {
        String exchangeCharsetName;
        String msh18 = hl7Util.findMsh18(hl7Bytes, defaultCharset);
        if (msh18 != null && !msh18.isEmpty()) {
            if (MllpProtocolConstants.MSH18_VALUES.containsKey(msh18)) {
                return MllpProtocolConstants.MSH18_VALUES.get(msh18);
            }
            try {
                if (Charset.isSupported(msh18)) {
                    return Charset.forName(msh18);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((exchangeCharsetName = ExchangeHelper.getCharsetName(exchange, false)) != null && !exchangeCharsetName.isEmpty()) {
            try {
                if (Charset.isSupported(exchangeCharsetName)) {
                    return Charset.forName(exchangeCharsetName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultCharset;
    }
}

