/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.mllp.MllpComponent;
import org.apache.camel.component.mllp.MllpConfiguration;
import org.apache.camel.component.mllp.MllpIdleTimeoutStrategy;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class MllpComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private MllpConfiguration getOrCreateConfiguration(MllpComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new MllpConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        MllpComponent target = (MllpComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accepttimeout": 
            case "acceptTimeout": {
                this.getOrCreateConfiguration(target).setAcceptTimeout(MllpComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "autoack": 
            case "autoAck": {
                this.getOrCreateConfiguration(target).setAutoAck(MllpComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(MllpComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "backlog": {
                this.getOrCreateConfiguration(target).setBacklog(MllpComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "bindretryinterval": 
            case "bindRetryInterval": {
                this.getOrCreateConfiguration(target).setBindRetryInterval(MllpComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "bindtimeout": 
            case "bindTimeout": {
                this.getOrCreateConfiguration(target).setBindTimeout(MllpComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                this.getOrCreateConfiguration(target).setBridgeErrorHandler(MllpComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "charsetname": 
            case "charsetName": {
                this.getOrCreateConfiguration(target).setCharsetName(MllpComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(MllpComponentConfigurer.property(camelContext, MllpConfiguration.class, value));
                return true;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                this.getOrCreateConfiguration(target).setConnectTimeout(MllpComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "defaultcharset": 
            case "defaultCharset": {
                target.setDefaultCharset(MllpComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                this.getOrCreateConfiguration(target).setExchangePattern(MllpComponentConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "hl7headers": 
            case "hl7Headers": {
                this.getOrCreateConfiguration(target).setHl7Headers(MllpComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "idletimeout": 
            case "idleTimeout": {
                this.getOrCreateConfiguration(target).setIdleTimeout(MllpComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "idletimeoutstrategy": 
            case "idleTimeoutStrategy": {
                this.getOrCreateConfiguration(target).setIdleTimeoutStrategy(MllpComponentConfigurer.property(camelContext, MllpIdleTimeoutStrategy.class, value));
                return true;
            }
            case "keepalive": 
            case "keepAlive": {
                this.getOrCreateConfiguration(target).setKeepAlive(MllpComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(MllpComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lenientbind": 
            case "lenientBind": {
                this.getOrCreateConfiguration(target).setLenientBind(MllpComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "logphi": 
            case "logPhi": {
                target.setLogPhi(MllpComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "logphimaxbytes": 
            case "logPhiMaxBytes": {
                target.setLogPhiMaxBytes(MllpComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxconcurrentconsumers": 
            case "maxConcurrentConsumers": {
                this.getOrCreateConfiguration(target).setMaxConcurrentConsumers(MllpComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "readtimeout": 
            case "readTimeout": {
                this.getOrCreateConfiguration(target).setReadTimeout(MllpComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                this.getOrCreateConfiguration(target).setReceiveBufferSize(MllpComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "receivetimeout": 
            case "receiveTimeout": {
                this.getOrCreateConfiguration(target).setReceiveTimeout(MllpComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "requireendofdata": 
            case "requireEndOfData": {
                this.getOrCreateConfiguration(target).setRequireEndOfData(MllpComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "reuseaddress": 
            case "reuseAddress": {
                this.getOrCreateConfiguration(target).setReuseAddress(MllpComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                this.getOrCreateConfiguration(target).setSendBufferSize(MllpComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "stringpayload": 
            case "stringPayload": {
                this.getOrCreateConfiguration(target).setStringPayload(MllpComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                this.getOrCreateConfiguration(target).setTcpNoDelay(MllpComponentConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "validatepayload": 
            case "validatePayload": {
                this.getOrCreateConfiguration(target).setValidatePayload(MllpComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accepttimeout": 
            case "acceptTimeout": {
                return Integer.TYPE;
            }
            case "autoack": 
            case "autoAck": {
                return Boolean.TYPE;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "backlog": {
                return Integer.class;
            }
            case "bindretryinterval": 
            case "bindRetryInterval": {
                return Integer.TYPE;
            }
            case "bindtimeout": 
            case "bindTimeout": {
                return Integer.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "charsetname": 
            case "charsetName": {
                return String.class;
            }
            case "configuration": {
                return MllpConfiguration.class;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return Integer.TYPE;
            }
            case "defaultcharset": 
            case "defaultCharset": {
                return String.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "hl7headers": 
            case "hl7Headers": {
                return Boolean.TYPE;
            }
            case "idletimeout": 
            case "idleTimeout": {
                return Integer.class;
            }
            case "idletimeoutstrategy": 
            case "idleTimeoutStrategy": {
                return MllpIdleTimeoutStrategy.class;
            }
            case "keepalive": 
            case "keepAlive": {
                return Boolean.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "lenientbind": 
            case "lenientBind": {
                return Boolean.TYPE;
            }
            case "logphi": 
            case "logPhi": {
                return Boolean.class;
            }
            case "logphimaxbytes": 
            case "logPhiMaxBytes": {
                return Integer.class;
            }
            case "maxconcurrentconsumers": 
            case "maxConcurrentConsumers": {
                return Integer.TYPE;
            }
            case "readtimeout": 
            case "readTimeout": {
                return Integer.TYPE;
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                return Integer.class;
            }
            case "receivetimeout": 
            case "receiveTimeout": {
                return Integer.TYPE;
            }
            case "requireendofdata": 
            case "requireEndOfData": {
                return Boolean.TYPE;
            }
            case "reuseaddress": 
            case "reuseAddress": {
                return Boolean.class;
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                return Integer.class;
            }
            case "stringpayload": 
            case "stringPayload": {
                return Boolean.TYPE;
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                return Boolean.class;
            }
            case "validatepayload": 
            case "validatePayload": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        MllpComponent target = (MllpComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accepttimeout": 
            case "acceptTimeout": {
                return this.getOrCreateConfiguration(target).getAcceptTimeout();
            }
            case "autoack": 
            case "autoAck": {
                return this.getOrCreateConfiguration(target).isAutoAck();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "backlog": {
                return this.getOrCreateConfiguration(target).getBacklog();
            }
            case "bindretryinterval": 
            case "bindRetryInterval": {
                return this.getOrCreateConfiguration(target).getBindRetryInterval();
            }
            case "bindtimeout": 
            case "bindTimeout": {
                return this.getOrCreateConfiguration(target).getBindTimeout();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return this.getOrCreateConfiguration(target).isBridgeErrorHandler();
            }
            case "charsetname": 
            case "charsetName": {
                return this.getOrCreateConfiguration(target).getCharsetName();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return this.getOrCreateConfiguration(target).getConnectTimeout();
            }
            case "defaultcharset": 
            case "defaultCharset": {
                return target.getDefaultCharset();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return this.getOrCreateConfiguration(target).getExchangePattern();
            }
            case "hl7headers": 
            case "hl7Headers": {
                return this.getOrCreateConfiguration(target).isHl7Headers();
            }
            case "idletimeout": 
            case "idleTimeout": {
                return this.getOrCreateConfiguration(target).getIdleTimeout();
            }
            case "idletimeoutstrategy": 
            case "idleTimeoutStrategy": {
                return this.getOrCreateConfiguration(target).getIdleTimeoutStrategy();
            }
            case "keepalive": 
            case "keepAlive": {
                return this.getOrCreateConfiguration(target).getKeepAlive();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "lenientbind": 
            case "lenientBind": {
                return this.getOrCreateConfiguration(target).isLenientBind();
            }
            case "logphi": 
            case "logPhi": {
                return target.getLogPhi();
            }
            case "logphimaxbytes": 
            case "logPhiMaxBytes": {
                return target.getLogPhiMaxBytes();
            }
            case "maxconcurrentconsumers": 
            case "maxConcurrentConsumers": {
                return this.getOrCreateConfiguration(target).getMaxConcurrentConsumers();
            }
            case "readtimeout": 
            case "readTimeout": {
                return this.getOrCreateConfiguration(target).getReadTimeout();
            }
            case "receivebuffersize": 
            case "receiveBufferSize": {
                return this.getOrCreateConfiguration(target).getReceiveBufferSize();
            }
            case "receivetimeout": 
            case "receiveTimeout": {
                return this.getOrCreateConfiguration(target).getReceiveTimeout();
            }
            case "requireendofdata": 
            case "requireEndOfData": {
                return this.getOrCreateConfiguration(target).isRequireEndOfData();
            }
            case "reuseaddress": 
            case "reuseAddress": {
                return this.getOrCreateConfiguration(target).getReuseAddress();
            }
            case "sendbuffersize": 
            case "sendBufferSize": {
                return this.getOrCreateConfiguration(target).getSendBufferSize();
            }
            case "stringpayload": 
            case "stringPayload": {
                return this.getOrCreateConfiguration(target).isStringPayload();
            }
            case "tcpnodelay": 
            case "tcpNoDelay": {
                return this.getOrCreateConfiguration(target).getTcpNoDelay();
            }
            case "validatepayload": 
            case "validatePayload": {
                return this.getOrCreateConfiguration(target).isValidatePayload();
            }
        }
        return null;
    }
}

