/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.mllp.MllpAcknowledgementDeliveryException;
import org.apache.camel.component.mllp.MllpAcknowledgementGenerationException;
import org.apache.camel.component.mllp.MllpCharsetHelper;
import org.apache.camel.component.mllp.MllpComponent;
import org.apache.camel.component.mllp.MllpConfiguration;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.component.mllp.MllpInvalidAcknowledgementException;
import org.apache.camel.component.mllp.MllpInvalidMessageException;
import org.apache.camel.component.mllp.MllpReceiveException;
import org.apache.camel.component.mllp.MllpSocketException;
import org.apache.camel.component.mllp.internal.Hl7Util;
import org.apache.camel.component.mllp.internal.MllpSocketBuffer;
import org.apache.camel.component.mllp.internal.TcpServerAcceptThread;
import org.apache.camel.component.mllp.internal.TcpServerBindThread;
import org.apache.camel.component.mllp.internal.TcpServerConsumerValidationRunnable;
import org.apache.camel.component.mllp.internal.TcpSocketConsumerRunnable;
import org.apache.camel.processor.mllp.Hl7AcknowledgementGenerationException;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="MLLP Producer")
public class MllpTcpServerConsumer
extends DefaultConsumer {
    final Logger log;
    final ExecutorService validationExecutor;
    final ExecutorService consumerExecutor;
    final Charset charset;
    final Hl7Util hl7Util;
    final boolean logPhi;
    TcpServerBindThread bindThread;
    TcpServerAcceptThread acceptThread;
    Map<TcpSocketConsumerRunnable, Long> consumerRunnables = new ConcurrentHashMap<TcpSocketConsumerRunnable, Long>();

    public MllpTcpServerConsumer(MllpEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.log = LoggerFactory.getLogger((String)String.format("%s.%d", this.getClass().getName(), endpoint.getPort()));
        this.charset = Charset.forName(endpoint.getConfiguration().getCharsetName());
        MllpComponent component = endpoint.getComponent();
        this.logPhi = component.getLogPhi();
        this.hl7Util = new Hl7Util(component.getLogPhiMaxBytes(), this.logPhi);
        this.validationExecutor = Executors.newCachedThreadPool();
        this.consumerExecutor = new ThreadPoolExecutor(1, this.getConfiguration().getMaxConcurrentConsumers(), this.getConfiguration().getAcceptTimeout(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
    }

    @ManagedAttribute(description="Last activity time")
    public Map<String, Date> getLastActivityTimes() {
        HashMap<String, Date> answer = new HashMap<String, Date>();
        for (Map.Entry<TcpSocketConsumerRunnable, Long> entry : this.consumerRunnables.entrySet()) {
            TcpSocketConsumerRunnable consumerRunnable = entry.getKey();
            if (consumerRunnable == null) continue;
            answer.put(consumerRunnable.getCombinedAddress(), new Date(entry.getValue()));
        }
        return answer;
    }

    @ManagedOperation(description="Close Connections")
    public void closeConnections() {
        for (TcpSocketConsumerRunnable consumerRunnable : this.consumerRunnables.keySet()) {
            if (consumerRunnable == null) continue;
            this.log.info("Close Connection called via JMX for address {}", (Object)consumerRunnable.getCombinedAddress());
            consumerRunnable.closeSocket();
        }
    }

    @ManagedOperation(description="Reset Connections")
    public void resetConnections() {
        for (TcpSocketConsumerRunnable consumerRunnable : this.consumerRunnables.keySet()) {
            if (consumerRunnable == null) continue;
            this.log.info("Reset Connection called via JMX for address {}", (Object)consumerRunnable.getCombinedAddress());
            consumerRunnable.resetSocket();
        }
    }

    @Override
    public MllpEndpoint getEndpoint() {
        return (MllpEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStop() throws Exception {
        this.log.trace("doStop()");
        for (TcpSocketConsumerRunnable consumerClientSocketThread : this.consumerRunnables.keySet()) {
            consumerClientSocketThread.stop();
        }
        if (this.acceptThread != null) {
            this.acceptThread.interrupt();
            this.acceptThread = null;
        }
        if (this.bindThread != null) {
            this.bindThread.interrupt();
            this.bindThread = null;
        }
        super.doStop();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.bindThread == null || !this.bindThread.isAlive()) {
            this.bindThread = new TcpServerBindThread(this);
            if (this.getConfiguration().isLenientBind()) {
                this.log.debug("doStart() - starting bind thread");
                this.bindThread.start();
            } else {
                this.log.debug("doStart() - attempting to bind to port {}", (Object)this.getEndpoint().getPort());
                this.bindThread.run();
                if (this.acceptThread == null) {
                    throw new BindException("Failed to bind to port " + this.getEndpoint().getPort());
                }
            }
        }
        super.doStart();
    }

    @Override
    protected void doShutdown() throws Exception {
        super.doShutdown();
        this.consumerExecutor.shutdownNow();
        if (this.acceptThread != null) {
            this.acceptThread.interrupt();
        }
        this.validationExecutor.shutdownNow();
    }

    public void handleMessageTimeout(String message, byte[] payload, Throwable cause) {
        this.getExceptionHandler().handleException(new MllpInvalidMessageException(message, payload, cause, this.logPhi));
    }

    public void handleMessageException(String message, byte[] payload, Throwable cause) {
        this.getExceptionHandler().handleException(new MllpReceiveException(message, payload, cause, this.logPhi));
    }

    public MllpConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public Map<TcpSocketConsumerRunnable, Long> getConsumerRunnables() {
        return this.consumerRunnables;
    }

    public void validateConsumer(Socket clientSocket) {
        MllpSocketBuffer mllpBuffer = new MllpSocketBuffer(this.getEndpoint());
        TcpServerConsumerValidationRunnable client = new TcpServerConsumerValidationRunnable(this, clientSocket, mllpBuffer);
        try {
            this.log.debug("validateConsumer({}) - submitting client for validation", (Object)clientSocket);
            this.validationExecutor.submit(client);
        }
        catch (RejectedExecutionException rejectedExecutionEx) {
            this.log.warn("validateConsumer({}) - cannot validate client - max validations already active", (Object)clientSocket);
            mllpBuffer.resetSocket(clientSocket);
        }
    }

    public void startAcceptThread(ServerSocket serverSocket) {
        this.acceptThread = new TcpServerAcceptThread(this, serverSocket);
        this.acceptThread.start();
    }

    public void startConsumer(Socket clientSocket, MllpSocketBuffer mllpBuffer) {
        TcpSocketConsumerRunnable client = new TcpSocketConsumerRunnable(this, clientSocket, mllpBuffer, this.hl7Util, this.logPhi);
        this.consumerRunnables.put(client, System.currentTimeMillis());
        try {
            this.log.info("startConsumer({}) - starting consumer", (Object)clientSocket);
            this.consumerExecutor.submit(client);
            this.getEndpoint().updateLastConnectionEstablishedTicks();
        }
        catch (RejectedExecutionException rejectedExecutionEx) {
            this.log.warn("startConsumer({}) - cannot start consumer - max consumers already active", (Object)clientSocket);
            mllpBuffer.resetSocket(clientSocket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(byte[] hl7MessageBytes, TcpSocketConsumerRunnable consumerRunnable) {
        long now = System.currentTimeMillis();
        this.getEndpoint().updateLastConnectionActivityTicks(now);
        this.consumerRunnables.put(consumerRunnable, now);
        this.log.debug("processMessage(hl7MessageBytes[{}], {}) - populating the exchange with received payload", (Object)(hl7MessageBytes == null ? -1 : hl7MessageBytes.length), (Object)consumerRunnable.getSocket());
        Exchange exchange = this.createExchange(false);
        exchange.setPattern(ExchangePattern.InOut);
        if (this.getConfiguration().hasCharsetName()) {
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)this.getConfiguration().getCharsetName());
        }
        try {
            String exceptionMessage;
            this.createUoW(exchange);
            if (exchange.hasProperties() || exchange.getProperty("CamelMllpAutoAcknowledge") == null) {
                exchange.setProperty("CamelMllpAutoAcknowledge", (Object)this.getConfiguration().isAutoAck());
            }
            Message message = exchange.getIn();
            if (consumerRunnable.hasLocalAddress()) {
                message.setHeader("CamelMllpLocalAddress", consumerRunnable.getLocalAddress());
            }
            if (consumerRunnable.hasRemoteAddress()) {
                message.setHeader("CamelMllpRemoteAddress", consumerRunnable.getRemoteAddress());
            }
            if (this.getConfiguration().isValidatePayload() && (exceptionMessage = this.hl7Util.generateInvalidPayloadExceptionMessage(hl7MessageBytes)) != null) {
                exchange.setException(new MllpInvalidMessageException(exceptionMessage, hl7MessageBytes, this.logPhi));
            }
            this.populateHl7DataHeaders(exchange, message, hl7MessageBytes);
            if (this.getConfiguration().isStringPayload()) {
                if (hl7MessageBytes != null && hl7MessageBytes.length > 0) {
                    message.setBody(new String(hl7MessageBytes, MllpCharsetHelper.getCharset(exchange, hl7MessageBytes, this.hl7Util, this.charset)));
                } else {
                    message.setBody("", String.class);
                }
            } else {
                message.setBody(hl7MessageBytes, byte[].class);
            }
            this.log.debug("processMessage(hl7MessageBytes[{}], {}) - calling processor", (Object)(hl7MessageBytes == null ? -1 : hl7MessageBytes.length), (Object)consumerRunnable.getSocket());
            try {
                this.getProcessor().process(exchange);
                this.sendAcknowledgement(hl7MessageBytes, exchange, consumerRunnable);
            }
            catch (Exception unexpectedEx) {
                String resetMessage = "processMessage(byte[], TcpSocketConsumerRunnable) - Unexpected exception processing exchange";
                consumerRunnable.resetSocket(resetMessage);
                this.getExceptionHandler().handleException(resetMessage, exchange, unexpectedEx);
            }
        }
        catch (Exception uowEx) {
            this.getExceptionHandler().handleException("processMessage(byte[], TcpSocketConsumerRunnable) - Unexpected exception creating Unit of Work", exchange, uowEx);
        }
        finally {
            this.doneUoW(exchange);
            this.releaseExchange(exchange, false);
        }
    }

    void populateHl7DataHeaders(Exchange exchange, Message message, byte[] hl7MessageBytes) {
        if (this.getConfiguration().isHl7Headers() && exchange != null && exchange.getException() == null) {
            if (hl7MessageBytes == null || hl7MessageBytes.length < 8) {
                return;
            }
            byte fieldSeparator = hl7MessageBytes[3];
            int endOfMSH = -1;
            ArrayList<Integer> fieldSeparatorIndexes = new ArrayList<Integer>(10);
            for (int i = 0; i < hl7MessageBytes.length; ++i) {
                if (fieldSeparator == hl7MessageBytes[i]) {
                    fieldSeparatorIndexes.add(i);
                    continue;
                }
                if (13 != hl7MessageBytes[i]) continue;
                if (fieldSeparator != hl7MessageBytes[i - 1]) {
                    fieldSeparatorIndexes.add(i);
                }
                endOfMSH = i;
                break;
            }
            if (-1 == endOfMSH) {
                this.log.warn("Population of message headers failed - unable to find the end of the MSH segment");
            } else {
                this.log.debug("Populating the HL7 message headers");
                Charset charset = MllpCharsetHelper.getCharset(exchange, this.charset);
                block14: for (int i = 2; i < fieldSeparatorIndexes.size(); ++i) {
                    String headerName;
                    int startingFieldSeparatorIndex = (Integer)fieldSeparatorIndexes.get(i - 1);
                    int endingFieldSeparatorIndex = (Integer)fieldSeparatorIndexes.get(i);
                    if (endingFieldSeparatorIndex - startingFieldSeparatorIndex <= 1) continue;
                    switch (i) {
                        case 2: {
                            headerName = "CamelMllpSendingApplication";
                            break;
                        }
                        case 3: {
                            headerName = "CamelMllpSendingFacility";
                            break;
                        }
                        case 4: {
                            headerName = "CamelMllpReceivingApplication";
                            break;
                        }
                        case 5: {
                            headerName = "CamelMllpReceivingFacility";
                            break;
                        }
                        case 6: {
                            headerName = "CamelMllpTimestamp";
                            break;
                        }
                        case 7: {
                            headerName = "CamelMllpSecurity";
                            break;
                        }
                        case 8: {
                            headerName = "CamelMllpMessageType";
                            break;
                        }
                        case 9: {
                            headerName = "CamelMllpMessageControlId";
                            break;
                        }
                        case 10: {
                            headerName = "CamelMllpProcessingId";
                            break;
                        }
                        case 11: {
                            headerName = "CamelMllpVersionId";
                            break;
                        }
                        case 17: {
                            headerName = "CamelMllpCharset";
                            break;
                        }
                        default: {
                            continue block14;
                        }
                    }
                    String headerValue = i == 17 && this.getConfiguration().hasCharsetName() ? this.getConfiguration().getCharsetName() : new String(hl7MessageBytes, startingFieldSeparatorIndex + 1, endingFieldSeparatorIndex - startingFieldSeparatorIndex - 1, charset);
                    message.setHeader(headerName, headerValue);
                    if (i != 8) continue;
                    String componentSeparator = new String(hl7MessageBytes, 4, 1, charset);
                    String[] components = headerValue.split(Pattern.quote(componentSeparator), 3);
                    message.setHeader("CamelMllpEventType", components[0]);
                    if (2 > components.length) continue;
                    message.setHeader("CamelMllpTriggerEvent", components[1]);
                }
            }
        } else {
            this.log.trace("HL7 Message headers disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAcknowledgement(byte[] originalHl7MessageBytes, Exchange exchange, TcpSocketConsumerRunnable consumerRunnable) {
        Exception exchangeEx;
        this.log.trace("sendAcknowledgement(originalHl7MessageBytes[{}], Exchange[{}], {}) - entering", new Object[]{originalHl7MessageBytes == null ? -1 : originalHl7MessageBytes.length, exchange.getExchangeId(), consumerRunnable.getSocket()});
        this.getEndpoint().checkBeforeSendProperties(exchange, consumerRunnable.getSocket(), this.log);
        byte[] acknowledgementMessageBytes = exchange.getProperty("CamelMllpAcknowledgement", byte[].class);
        if (acknowledgementMessageBytes == null) {
            acknowledgementMessageBytes = exchange.getProperty("CamelMllpAcknowledgementString", byte[].class);
        }
        String acknowledgementMessageType = null;
        if (null == acknowledgementMessageBytes) {
            boolean autoAck = exchange.getProperty("CamelMllpAutoAcknowledge", (Object)true, Boolean.TYPE);
            if (!autoAck) {
                if (this.getConfiguration().getExchangePattern() == ExchangePattern.InOut) {
                    Object acknowledgementBytesProperty = exchange.getProperty("CamelMllpAcknowledgement");
                    Object acknowledgementStringProperty = exchange.getProperty("CamelMllpAcknowledgementString");
                    String exceptionMessage = acknowledgementBytesProperty == null && acknowledgementStringProperty == null ? "Automatic Acknowledgement is disabled and the CamelMllpAcknowledgement and CamelMllpAcknowledgementString exchange properties are null" : "Automatic Acknowledgement is disabled and neither the CamelMllpAcknowledgement(type = " + acknowledgementBytesProperty.getClass().getSimpleName() + ") nor the" + "CamelMllpAcknowledgementString" + "(type = " + acknowledgementBytesProperty.getClass().getSimpleName() + ") exchange properties can be converted to byte[]";
                    Object invalidAckEx = new MllpInvalidAcknowledgementException(exceptionMessage, originalHl7MessageBytes, acknowledgementMessageBytes, this.logPhi);
                    exchange.setProperty("CamelMllpAcknowledgementException", invalidAckEx);
                    this.getExceptionHandler().handleException((Throwable)invalidAckEx);
                }
            } else {
                String acknowledgmentTypeProperty = exchange.getProperty("CamelMllpAcknowledgementType", String.class);
                String msa3 = exchange.getProperty("CamelMllpAcknowledgementMsaText", String.class);
                exchangeEx = exchange.getException();
                try {
                    if (null == acknowledgmentTypeProperty) {
                        if (null == exchangeEx) {
                            acknowledgementMessageType = "AA";
                        } else {
                            acknowledgementMessageType = "AE";
                            if (msa3 == null || msa3.isEmpty()) {
                                msa3 = exchangeEx.getClass().getName();
                            }
                        }
                    } else {
                        switch (acknowledgmentTypeProperty) {
                            case "AA": {
                                acknowledgementMessageType = "AA";
                                break;
                            }
                            case "AE": {
                                acknowledgementMessageType = "AE";
                                if (exchangeEx == null || msa3 == null || !msa3.isEmpty()) break;
                                msa3 = exchangeEx.getClass().getName();
                                break;
                            }
                            case "AR": {
                                acknowledgementMessageType = "AR";
                                if (exchangeEx == null || msa3 == null || !msa3.isEmpty()) break;
                                msa3 = exchangeEx.getClass().getName();
                                break;
                            }
                            default: {
                                exchange.setException(new Hl7AcknowledgementGenerationException(this.hl7Util, "Unsupported acknowledgment type: " + acknowledgmentTypeProperty));
                                return;
                            }
                        }
                    }
                    this.hl7Util.generateAcknowledgementPayload(consumerRunnable.getMllpBuffer(), originalHl7MessageBytes, acknowledgementMessageType, msa3);
                }
                catch (MllpAcknowledgementGenerationException ackGenerationException) {
                    exchange.setProperty("CamelMllpAcknowledgementException", (Object)ackGenerationException);
                    this.getExceptionHandler().handleException(ackGenerationException);
                }
            }
        } else {
            consumerRunnable.getMllpBuffer().setEnvelopedMessage(acknowledgementMessageBytes);
            int bM = 77;
            int bS = 83;
            int bA = 65;
            int bE = 69;
            int bR = 82;
            byte fieldSeparator = originalHl7MessageBytes[3];
            for (int i = 0; i < originalHl7MessageBytes.length; ++i) {
                String acknowledgementTypeProperty;
                if (13 != i || i + 7 >= originalHl7MessageBytes.length || 77 != originalHl7MessageBytes[i + 1] || 83 != originalHl7MessageBytes[i + 2] || 65 != originalHl7MessageBytes[i + 3] || fieldSeparator != originalHl7MessageBytes[i + 4]) continue;
                if (fieldSeparator != originalHl7MessageBytes[i + 7]) {
                    this.log.warn("MSA-1 is longer than 2-bytes - ignoring trailing bytes");
                }
                byte[] acknowledgmentTypeBytes = new byte[]{originalHl7MessageBytes[i + 5], originalHl7MessageBytes[i + 6]};
                try {
                    acknowledgementMessageType = new String(acknowledgmentTypeBytes, ExchangeHelper.getCharsetName(exchange));
                }
                catch (IOException ioEx) {
                    throw new RuntimeCamelException("Failed to convert acknowledgement message to string", ioEx);
                }
                if (65 != acknowledgmentTypeBytes[0]) {
                    switch (acknowledgementMessageBytes[1]) {
                        case 65: 
                        case 69: 
                        case 82: {
                            break;
                        }
                        default: {
                            this.log.warn("Invalid acknowledgement type [{}] found in message - should be AA, AE or AR", (Object)acknowledgementMessageType);
                        }
                    }
                }
                if (null == (acknowledgementTypeProperty = exchange.getProperty("CamelMllpAcknowledgementType", String.class)) || acknowledgementTypeProperty.equals(acknowledgementMessageType)) continue;
                this.log.warn("Acknowledgement type found in message [{}] does not match {} exchange property value [{}] - using value found in message", new Object[]{acknowledgementMessageType, "CamelMllpAcknowledgementType", acknowledgementTypeProperty});
            }
        }
        Message message = exchange.getMessage();
        if (acknowledgementMessageType != null && !acknowledgementMessageType.isEmpty()) {
            message.setHeader("CamelMllpAcknowledgementType", acknowledgementMessageType);
        }
        Charset charset = MllpCharsetHelper.getCharset(exchange, this.charset);
        if (consumerRunnable.getMllpBuffer().hasCompleteEnvelope()) {
            message.setHeader("CamelMllpAcknowledgement", consumerRunnable.getMllpBuffer().toMllpPayload());
            message.setHeader("CamelMllpAcknowledgementString", consumerRunnable.getMllpBuffer().toHl7String(charset));
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendAcknowledgement(originalHl7MessageBytes[{}], Exchange[{}], {}) - Sending Acknowledgement: {}", new Object[]{originalHl7MessageBytes == null ? -1 : originalHl7MessageBytes.length, exchange.getExchangeId(), consumerRunnable.getSocket(), consumerRunnable.getMllpBuffer().toPrintFriendlyHl7String()});
            }
            try {
                consumerRunnable.getMllpBuffer().writeTo(consumerRunnable.getSocket());
            }
            catch (MllpSocketException acknowledgementDeliveryEx) {
                exchangeEx = new MllpAcknowledgementDeliveryException("Failure delivering acknowledgment", originalHl7MessageBytes, acknowledgementMessageBytes, acknowledgementDeliveryEx, this.logPhi);
                exchange.setProperty("CamelMllpAcknowledgementException", (Object)acknowledgementDeliveryEx);
                exchange.setException(exchangeEx);
            }
            finally {
                consumerRunnable.getMllpBuffer().reset();
            }
        } else if (acknowledgementMessageBytes != null && acknowledgementMessageBytes.length > 0) {
            message.setHeader("CamelMllpAcknowledgement", acknowledgementMessageBytes);
            String acknowledgementMessageString = new String(acknowledgementMessageBytes, charset);
            message.setHeader("CamelMllpAcknowledgementString", acknowledgementMessageString);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendAcknowledgement(originalHl7MessageBytes[{}], Exchange[{}], {}) - Sending Acknowledgement: {}", new Object[]{originalHl7MessageBytes == null ? -1 : originalHl7MessageBytes.length, exchange.getExchangeId(), consumerRunnable.getSocket(), this.hl7Util.convertToPrintFriendlyString(acknowledgementMessageBytes)});
            }
            try {
                consumerRunnable.getMllpBuffer().setEnvelopedMessage(acknowledgementMessageBytes);
                consumerRunnable.getMllpBuffer().writeTo(consumerRunnable.getSocket());
            }
            catch (MllpSocketException acknowledgementDeliveryEx) {
                MllpAcknowledgementDeliveryException exchangeEx2 = new MllpAcknowledgementDeliveryException("Failure delivering acknowledgment", originalHl7MessageBytes, acknowledgementMessageBytes, acknowledgementDeliveryEx, this.logPhi);
                exchange.setProperty("CamelMllpAcknowledgementException", (Object)acknowledgementDeliveryEx);
                exchange.setException(exchangeEx2);
            }
        }
        this.getEndpoint().checkAfterSendProperties(exchange, consumerRunnable.getSocket(), this.log);
    }
}

