/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.time.Duration;
import org.apache.camel.Route;
import org.apache.camel.component.mllp.MllpTcpServerConsumer;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TcpServerBindThread
extends Thread {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MllpTcpServerConsumer consumer;

    public TcpServerBindThread(MllpTcpServerConsumer consumer) {
        this.consumer = consumer;
        String fullEndpointKey = consumer.getEndpoint().getEndpointKey();
        String endpointKey = fullEndpointKey.contains("?") ? fullEndpointKey.substring(0, fullEndpointKey.indexOf(63)) : fullEndpointKey;
        this.setName(String.format("%s - %s", this.getClass().getSimpleName(), endpointKey));
    }

    @Override
    public void run() {
        String routeId;
        MDC.put((String)"camel.contextId", (String)this.consumer.getEndpoint().getCamelContext().getName());
        Route route = this.consumer.getRoute();
        if (route != null && (routeId = route.getId()) != null) {
            MDC.put((String)"camel.routeId", (String)route.getId());
        }
        try {
            ServerSocket serverSocket = new ServerSocket();
            InetSocketAddress socketAddress = this.setupSocket(serverSocket);
            this.log.debug("Attempting to bind to {}", (Object)socketAddress);
            this.doAccept(serverSocket, socketAddress);
        }
        catch (IOException ioEx) {
            this.log.error("Unexpected exception encountered initializing ServerSocket before attempting to bind", (Throwable)ioEx);
        }
    }

    private void doAccept(ServerSocket serverSocket, InetSocketAddress socketAddress) {
        BlockingTask task = (BlockingTask)Tasks.foregroundTask().withBudget(Budgets.iterationTimeBudget().withMaxDuration(Duration.ofMillis(this.consumer.getConfiguration().getBindTimeout())).withInterval(Duration.ofMillis(this.consumer.getConfiguration().getBindRetryInterval())).build()).withName("mllp-tcp-server-accept").build();
        if (task.run(() -> this.doBind(serverSocket, socketAddress))) {
            this.consumer.startAcceptThread(serverSocket);
        } else {
            this.log.error("Failed to bind to address {} within timeout {}", (Object)socketAddress, (Object)this.consumer.getConfiguration().getBindTimeout());
        }
    }

    private boolean doBind(ServerSocket serverSocket, InetSocketAddress socketAddress) {
        try {
            if (this.consumer.getConfiguration().hasBacklog()) {
                serverSocket.bind(socketAddress, this.consumer.getConfiguration().getBacklog());
            } else {
                serverSocket.bind(socketAddress);
            }
            return true;
        }
        catch (IOException e) {
            this.log.warn("Failed to bind to address {} - retrying in {} milliseconds", (Object)socketAddress, (Object)this.consumer.getConfiguration().getBindRetryInterval());
            return false;
        }
    }

    private InetSocketAddress setupSocket(ServerSocket serverSocket) throws SocketException {
        if (this.consumer.getConfiguration().hasReceiveBufferSize()) {
            serverSocket.setReceiveBufferSize(this.consumer.getConfiguration().getReceiveBufferSize());
        }
        if (this.consumer.getConfiguration().hasReuseAddress()) {
            serverSocket.setReuseAddress(this.consumer.getConfiguration().getReuseAddress());
        }
        serverSocket.setSoTimeout(this.consumer.getConfiguration().getAcceptTimeout());
        InetSocketAddress socketAddress = null == this.consumer.getEndpoint().getHostname() ? new InetSocketAddress(this.consumer.getEndpoint().getPort()) : new InetSocketAddress(this.consumer.getEndpoint().getHostname(), this.consumer.getEndpoint().getPort());
        return socketAddress;
    }
}

