/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;

public class JacksonDataFormat
extends ServiceSupport
implements DataFormat {
    private final ObjectMapper objectMapper;
    private Class<?> unmarshalType;
    private Class<?> jsonView;
    private String include;

    public JacksonDataFormat() {
        this(HashMap.class);
    }

    public JacksonDataFormat(Class<?> unmarshalType) {
        this(unmarshalType, null);
    }

    public JacksonDataFormat(Class<?> unmarshalType, Class<?> jsonView) {
        this.objectMapper = new ObjectMapper();
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        this.objectMapper.registerModule(module);
    }

    public JacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType) {
        this(mapper, unmarshalType, null);
    }

    public JacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType, Class<?> jsonView) {
        this.objectMapper = mapper;
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.objectMapper.writerWithView(this.jsonView).writeValue(stream, graph);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.objectMapper.readValue(stream, this.unmarshalType);
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    protected void doStart() throws Exception {
        if (this.include != null) {
            JsonInclude.Include inc = JsonInclude.Include.valueOf(this.include);
            this.objectMapper.setSerializationInclusion(inc);
        }
    }

    protected void doStop() throws Exception {
    }
}

