/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.mongodb.CamelMongoDbException;
import org.apache.camel.component.mongodb.MongoDbComponent;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.apache.camel.component.mongodb.MongoDbOperation;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbProducer.class);
    private MongoDbEndpoint endpoint;

    public MongoDbProducer(MongoDbEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        MongoDbOperation operation = this.endpoint.getOperation();
        Object header = exchange.getIn().getHeader("CamelMongoDbOperation");
        if (header != null) {
            LOG.debug("Overriding default operation with operation specified on header: {}", header);
            try {
                operation = header instanceof MongoDbOperation ? (MongoDbOperation)((Object)ObjectHelper.cast(MongoDbOperation.class, (Object)header)) : MongoDbOperation.valueOf((String)exchange.getIn().getHeader("CamelMongoDbOperation", String.class));
            }
            catch (Exception e) {
                throw new CamelMongoDbException("Operation specified on header is not supported. Value: " + header, e);
            }
        }
        try {
            this.invokeOperation(operation, exchange);
        }
        catch (Exception e) {
            throw MongoDbComponent.wrapInCamelMongoDbException(e);
        }
    }

    protected void invokeOperation(MongoDbOperation operation, Exchange exchange) throws Exception {
        switch (operation) {
            case count: {
                this.doCount(exchange);
                break;
            }
            case findOneByQuery: {
                this.doFindOneByQuery(exchange);
                break;
            }
            case findById: {
                this.doFindById(exchange);
                break;
            }
            case findAll: {
                this.doFindAll(exchange);
                break;
            }
            case insert: {
                this.doInsert(exchange);
                break;
            }
            case save: {
                this.doSave(exchange);
                break;
            }
            case update: {
                this.doUpdate(exchange);
                break;
            }
            case remove: {
                this.doRemove(exchange);
                break;
            }
            case aggregate: {
                this.doAggregate(exchange);
                break;
            }
            case getDbStats: {
                this.doGetStats(exchange, MongoDbOperation.getDbStats);
                break;
            }
            case getColStats: {
                this.doGetStats(exchange, MongoDbOperation.getColStats);
                break;
            }
            case command: {
                this.doCommand(exchange);
                break;
            }
            default: {
                throw new CamelMongoDbException("Operation not supported. Value: " + (Object)((Object)operation));
            }
        }
    }

    protected void doCommand(Exchange exchange) throws Exception {
        CommandResult result = null;
        DB db = this.calculateDb(exchange);
        DBObject cmdObj = (DBObject)exchange.getIn().getMandatoryBody(DBObject.class);
        result = db.command(cmdObj);
        Message responseMessage = this.prepareResponseMessage(exchange, MongoDbOperation.command);
        responseMessage.setBody((Object)result);
    }

    protected void doGetStats(Exchange exchange, MongoDbOperation operation) throws Exception {
        CommandResult result = null;
        if (operation == MongoDbOperation.getColStats) {
            result = this.calculateCollection(exchange).getStats();
        } else if (operation == MongoDbOperation.getDbStats) {
            result = this.calculateDb(exchange).getStats();
        } else {
            throw new CamelMongoDbException("Internal error: wrong operation for getStats variant" + (Object)((Object)operation));
        }
        Message responseMessage = this.prepareResponseMessage(exchange, operation);
        responseMessage.setBody((Object)result);
    }

    protected void doRemove(Exchange exchange) throws Exception {
        DBCollection dbCol = this.calculateCollection(exchange);
        DBObject removeObj = (DBObject)exchange.getIn().getMandatoryBody(DBObject.class);
        WriteConcern wc = this.extractWriteConcern(exchange);
        WriteResult result = wc == null ? dbCol.remove(removeObj) : dbCol.remove(removeObj, wc);
        Message resultMessage = this.prepareResponseMessage(exchange, MongoDbOperation.remove);
        this.processAndTransferWriteResult(result, exchange);
        resultMessage.setHeader("CamelMongoDbRecordsAffected", (Object)result.getN());
    }

    protected void doUpdate(Exchange exchange) throws Exception {
        DBCollection dbCol = this.calculateCollection(exchange);
        List saveObj = (List)exchange.getIn().getMandatoryBody(List.class);
        if (saveObj.size() != 2) {
            throw new CamelMongoDbException("MongoDB operation = insert, failed because body is not a List of DBObject objects with size = 2");
        }
        DBObject updateCriteria = (DBObject)saveObj.get(0);
        DBObject objNew = (DBObject)saveObj.get(1);
        Boolean multi = (Boolean)exchange.getIn().getHeader("CamelMongoDbMultiUpdate", Boolean.class);
        Boolean upsert = (Boolean)exchange.getIn().getHeader("CamelMongoDbUpsert", Boolean.class);
        WriteConcern wc = this.extractWriteConcern(exchange);
        WriteResult result = multi == null && upsert == null ? (wc == null ? dbCol.update(updateCriteria, objNew) : dbCol.update(updateCriteria, objNew, false, false, wc)) : (wc == null ? dbCol.update(updateCriteria, objNew, this.calculateBooleanValue(upsert), this.calculateBooleanValue(multi)) : dbCol.update(updateCriteria, objNew, this.calculateBooleanValue(upsert), this.calculateBooleanValue(multi), wc));
        Message resultMessage = this.prepareResponseMessage(exchange, MongoDbOperation.update);
        this.processAndTransferWriteResult(result, exchange);
        resultMessage.setHeader("CamelMongoDbRecordsAffected", (Object)result.getN());
    }

    protected void doSave(Exchange exchange) throws Exception {
        DBCollection dbCol = this.calculateCollection(exchange);
        DBObject saveObj = (DBObject)exchange.getIn().getMandatoryBody(DBObject.class);
        WriteConcern wc = this.extractWriteConcern(exchange);
        WriteResult result = wc == null ? dbCol.save(saveObj) : dbCol.save(saveObj, wc);
        exchange.getIn().setHeader("CamelMongoOid", saveObj.get("_id"));
        this.prepareResponseMessage(exchange, MongoDbOperation.save);
        this.processAndTransferWriteResult(result, exchange);
    }

    protected void doFindById(Exchange exchange) throws Exception {
        DBCollection dbCol = this.calculateCollection(exchange);
        Object o = exchange.getIn().getMandatoryBody();
        DBObject fieldFilter = (DBObject)exchange.getIn().getHeader("CamelMongoDbFieldsFilter", DBObject.class);
        DBObject ret = fieldFilter == null ? dbCol.findOne(o) : dbCol.findOne(o, fieldFilter);
        Message resultMessage = this.prepareResponseMessage(exchange, MongoDbOperation.save);
        resultMessage.setBody((Object)ret);
        resultMessage.setHeader("CamelMongoDbResultTotalSize", (Object)(ret == null ? 0 : 1));
    }

    protected void doInsert(Exchange exchange) throws Exception {
        WriteResult result;
        DBCollection dbCol = this.calculateCollection(exchange);
        boolean singleInsert = true;
        Object insert = exchange.getIn().getBody(DBObject.class);
        if (insert == null) {
            insert = exchange.getIn().getBody(List.class);
            if (insert != null) {
                singleInsert = false;
                insert = this.attemptConvertToList((List)insert, exchange);
            } else {
                throw new CamelMongoDbException("MongoDB operation = insert, Body is not conversible to type DBObject nor List<DBObject>");
            }
        }
        WriteConcern wc = this.extractWriteConcern(exchange);
        if (singleInsert) {
            DBObject insertObject = (DBObject)insert;
            result = wc == null ? dbCol.insert(insertObject) : dbCol.insert(insertObject, wc);
            exchange.getIn().setHeader("CamelMongoOid", insertObject.get("_id"));
        } else {
            List insertObjects = (List)insert;
            result = wc == null ? dbCol.insert(insertObjects) : dbCol.insert(insertObjects, wc);
            ArrayList<Object> oids = new ArrayList<Object>(insertObjects.size());
            for (DBObject insertObject : insertObjects) {
                oids.add(insertObject.get("_id"));
            }
            exchange.getIn().setHeader("CamelMongoOid", oids);
        }
        Message resultMessage = this.prepareResponseMessage(exchange, MongoDbOperation.insert);
        this.processAndTransferWriteResult(result, exchange);
        resultMessage.setBody((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFindAll(Exchange exchange) throws Exception {
        DBCollection dbCol = this.calculateCollection(exchange);
        DBObject query = null;
        if (exchange.getIn().getBody() != null) {
            query = (DBObject)exchange.getIn().getBody(DBObject.class);
        }
        DBObject fieldFilter = (DBObject)exchange.getIn().getHeader("CamelMongoDbFieldsFilter", DBObject.class);
        Integer batchSize = (Integer)exchange.getIn().getHeader("CamelMongoDbBatchSize", Integer.class);
        Integer numToSkip = (Integer)exchange.getIn().getHeader("CamelMongoDbNumToSkip", Integer.class);
        Integer limit = (Integer)exchange.getIn().getHeader("CamelMongoDbLimit", Integer.class);
        DBObject sortBy = (DBObject)exchange.getIn().getHeader("CamelMongoDbSortBy", DBObject.class);
        try (DBCursor ret = null;){
            ret = query == null && fieldFilter == null ? dbCol.find(new BasicDBObject()) : (fieldFilter == null ? dbCol.find(query) : dbCol.find(query, fieldFilter));
            if (sortBy != null) {
                ret.sort(sortBy);
            }
            if (batchSize != null) {
                ret.batchSize(batchSize);
            }
            if (numToSkip != null) {
                ret.skip(numToSkip);
            }
            if (limit != null) {
                ret.limit(limit);
            }
            Message resultMessage = this.prepareResponseMessage(exchange, MongoDbOperation.findAll);
            resultMessage.setBody(ret.toArray());
            resultMessage.setHeader("CamelMongoDbResultTotalSize", (Object)ret.count());
            resultMessage.setHeader("CamelMongoDbResultPageSize", (Object)ret.size());
        }
    }

    protected void doFindOneByQuery(Exchange exchange) throws Exception {
        DBCollection dbCol = this.calculateCollection(exchange);
        DBObject o = (DBObject)exchange.getIn().getMandatoryBody(DBObject.class);
        DBObject fieldFilter = (DBObject)exchange.getIn().getHeader("CamelMongoDbFieldsFilter", DBObject.class);
        DBObject ret = fieldFilter == null ? dbCol.findOne(o) : dbCol.findOne(o, fieldFilter);
        Message resultMessage = this.prepareResponseMessage(exchange, MongoDbOperation.findOneByQuery);
        resultMessage.setBody((Object)ret);
        resultMessage.setHeader("CamelMongoDbResultTotalSize", (Object)(ret == null ? 0 : 1));
    }

    protected void doCount(Exchange exchange) throws Exception {
        DBCollection dbCol = this.calculateCollection(exchange);
        DBObject query = (DBObject)exchange.getIn().getBody(DBObject.class);
        Long answer = query == null ? Long.valueOf(dbCol.count()) : Long.valueOf(dbCol.count(query));
        Message resultMessage = this.prepareResponseMessage(exchange, MongoDbOperation.count);
        resultMessage.setBody((Object)answer);
    }

    protected void doAggregate(Exchange exchange) throws Exception {
        DBCollection dbCol = this.calculateCollection(exchange);
        DBObject query = (DBObject)exchange.getIn().getMandatoryBody(DBObject.class);
        Iterable<DBObject> dbIterator = null;
        AggregationOutput aggregationResult = null;
        if (query instanceof BasicDBList) {
            BasicDBList queryList = (BasicDBList)query;
            aggregationResult = dbCol.aggregate((DBObject)queryList.get(0), queryList.subList(1, queryList.size()).toArray(new BasicDBObject[queryList.size() - 1]));
        } else {
            aggregationResult = dbCol.aggregate(query, new DBObject[0]);
        }
        dbIterator = aggregationResult.results();
        Message resultMessage = this.prepareResponseMessage(exchange, MongoDbOperation.aggregate);
        resultMessage.setBody(dbIterator);
    }

    private DB calculateDb(Exchange exchange) throws Exception {
        if (!this.endpoint.isDynamicity()) {
            return this.endpoint.getDb();
        }
        String dynamicDB = (String)exchange.getIn().getHeader("CamelMongoDbDatabase", String.class);
        DB db = null;
        db = dynamicDB == null ? this.endpoint.getDb() : this.endpoint.getMongoConnection().getDB(dynamicDB);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dynamic database selected: {}", (Object)db.getName());
        }
        return db;
    }

    private DBCollection calculateCollection(Exchange exchange) throws Exception {
        if (!this.endpoint.isDynamicity()) {
            return this.endpoint.getDbCollection();
        }
        String dynamicDB = (String)exchange.getIn().getHeader("CamelMongoDbDatabase", String.class);
        String dynamicCollection = (String)exchange.getIn().getHeader("CamelMongoDbCollection", String.class);
        List dynamicIndex = (List)exchange.getIn().getHeader("CamelMongoDbCollectionIndex", List.class);
        DBCollection dbCol = null;
        if (dynamicDB == null && dynamicCollection == null) {
            dbCol = this.endpoint.getDbCollection();
        } else {
            DB db = this.calculateDb(exchange);
            if (dynamicCollection == null) {
                dbCol = db.getCollection(this.endpoint.getCollection());
            } else {
                dbCol = db.getCollection(dynamicCollection);
                if (dynamicIndex == null) {
                    this.endpoint.ensureIndex(dbCol, this.endpoint.createIndex());
                } else {
                    this.endpoint.ensureIndex(dbCol, dynamicIndex);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dynamic database and/or collection selected: {}->{}", (Object)dbCol.getDB().getName(), (Object)dbCol.getName());
        }
        return dbCol;
    }

    private boolean calculateBooleanValue(Boolean b) {
        return b == null ? false : b;
    }

    private void processAndTransferWriteResult(WriteResult result, Exchange exchange) {
        if (this.endpoint.isInvokeGetLastError() || this.endpoint.getWriteConcern() != null && this.endpoint.getWriteConcern().callGetLastError()) {
            CommandResult cr = result.getCachedLastError() == null ? result.getLastError() : result.getCachedLastError();
            exchange.getOut().setHeader("CamelMongoDbLastError", (Object)cr);
            if (!cr.ok()) {
                exchange.setException((Throwable)MongoDbComponent.wrapInCamelMongoDbException(cr.getException()));
            }
        }
        if (this.endpoint.isWriteResultAsHeader()) {
            exchange.getOut().setHeader("CamelMongoWriteResult", (Object)result);
        } else {
            exchange.getOut().setBody((Object)result);
        }
    }

    private WriteConcern extractWriteConcern(Exchange exchange) throws CamelMongoDbException {
        WriteConcern answer;
        Object o = exchange.getIn().getHeader("CamelMongoDbWriteConcern");
        if (o == null) {
            return null;
        }
        if (o instanceof WriteConcern) {
            return (WriteConcern)ObjectHelper.cast(WriteConcern.class, (Object)o);
        }
        if (o instanceof String && (answer = WriteConcern.valueOf((String)ObjectHelper.cast(String.class, (Object)o))) == null) {
            throw new CamelMongoDbException("WriteConcern specified in the CamelMongoDbWriteConcern header, with value " + o + " could not be resolved to a WriteConcern type");
        }
        LOG.warn("A problem occurred while resolving the Exchange's Write Concern");
        return null;
    }

    private List<DBObject> attemptConvertToList(List insertList, Exchange exchange) throws CamelMongoDbException {
        ArrayList<DBObject> dbObjectList = new ArrayList<DBObject>(insertList.size());
        TypeConverter converter = exchange.getContext().getTypeConverter();
        for (Object item : insertList) {
            try {
                DBObject dbObject = (DBObject)converter.mandatoryConvertTo(DBObject.class, item);
                dbObjectList.add(dbObject);
            }
            catch (Exception e) {
                throw new CamelMongoDbException("MongoDB operation = insert, Assuming List variant of MongoDB insert operation, but List contains non-DBObject items", e);
            }
        }
        return dbObjectList;
    }

    private Message prepareResponseMessage(Exchange exchange, MongoDbOperation operation) {
        Message answer = exchange.getOut();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)answer, (boolean)false);
        if (this.isWriteOperation(operation) && this.endpoint.isWriteResultAsHeader()) {
            answer.setBody(exchange.getIn().getBody());
        }
        return answer;
    }

    private boolean isWriteOperation(MongoDbOperation operation) {
        return MongoDbComponent.WRITE_OPERATIONS.contains((Object)operation);
    }
}

