/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.converters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import com.mongodb.util.JSONCallback;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.util.IOHelper;
import org.bson.BSONCallback;
import org.bson.BasicBSONDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class MongoDbBasicConverters {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasicConverters.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private MongoDbBasicConverters() {
    }

    @Converter
    public static DBObject fromMapToDBObject(Map<?, ?> map) {
        return new BasicDBObject(map);
    }

    @Converter
    public static Map<String, Object> fromBasicDBObjectToMap(BasicDBObject basicDbObject) {
        return basicDbObject;
    }

    @Converter
    public static DBObject fromStringToDBObject(String s) {
        DBObject answer = null;
        try {
            answer = (DBObject)JSON.parse(s);
        }
        catch (Exception e) {
            LOG.warn("String -> DBObject conversion selected, but the following exception occurred. Returning null.", (Throwable)e);
        }
        return answer;
    }

    @Converter
    public static DBObject fromFileToDBObject(File f, Exchange exchange) throws FileNotFoundException {
        return MongoDbBasicConverters.fromInputStreamToDBObject(new FileInputStream(f), exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static DBObject fromInputStreamToDBObject(InputStream is, Exchange exchange) {
        DBObject answer = null;
        try {
            byte[] input = IOConverter.toBytes((InputStream)is);
            if (MongoDbBasicConverters.isBson(input)) {
                JSONCallback callback = new JSONCallback();
                new BasicBSONDecoder().decode(input, (BSONCallback)callback);
                answer = (DBObject)callback.get();
            } else {
                answer = (DBObject)JSON.parse(IOConverter.toString((byte[])input, (Exchange)exchange));
            }
        }
        catch (Exception e) {
            LOG.warn("String -> DBObject conversion selected, but the following exception occurred. Returning null.", (Throwable)e);
        }
        finally {
            IOHelper.close((Closeable)is, (String)"InputStream", (Logger)LOG);
        }
        return answer;
    }

    private static boolean isBson(byte[] input) {
        int i = 0;
        while (i < input.length) {
            if (input[i] == 123) {
                return false;
            }
            if (Character.isWhitespace(input[i])) continue;
            return true;
        }
        return true;
    }

    @Converter
    public static DBObject fromAnyObjectToDBObject(Object value) {
        BasicDBObject answer;
        try {
            Map m = OBJECT_MAPPER.convertValue(value, Map.class);
            answer = new BasicDBObject(m);
        }
        catch (Exception e) {
            LOG.warn("Conversion has fallen back to generic Object -> DBObject, but unable to convert type {}. Returning null.", (Object)value.getClass().getCanonicalName());
            return null;
        }
        return answer;
    }
}

