/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.component.jackson.SchemaResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJacksonDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
DataFormatContentTypeHeader,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJacksonDataFormat.class);
    private CamelContext camelContext;
    private ObjectMapper objectMapper;
    private boolean useDefaultObjectMapper = true;
    private String collectionTypeName;
    private Class<? extends Collection> collectionType;
    private List<Module> modules;
    private String moduleClassNames;
    private String moduleRefs;
    private String unmarshalTypeName;
    private Class<?> unmarshalType;
    private String jsonViewTypeName;
    private Class<?> jsonView;
    private String include;
    private boolean prettyPrint;
    private boolean allowJmsType;
    private boolean useList;
    private String enableFeatures;
    private String disableFeatures;
    private boolean enableJacksonTypeConverter;
    private boolean allowUnmarshallType;
    private boolean contentTypeHeader = true;
    private TimeZone timezone;
    private boolean autoDiscoverObjectMapper;
    private SchemaResolver schemaResolver;
    private boolean autoDiscoverSchemaResolver = true;
    private String namingStrategy;

    public AbstractJacksonDataFormat() {
        this(Object.class);
    }

    public AbstractJacksonDataFormat(Class<?> unmarshalType) {
        this(unmarshalType, null);
    }

    public AbstractJacksonDataFormat(Class<?> unmarshalType, Class<?> jsonView) {
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
    }

    public AbstractJacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType) {
        this(mapper, unmarshalType, null);
    }

    public AbstractJacksonDataFormat(ObjectMapper mapper, Class<?> unmarshalType, Class<?> jsonView) {
        this.objectMapper = mapper;
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        FormatSchema schema = null;
        if (this.schemaResolver != null) {
            schema = this.schemaResolver.resolve(exchange);
        }
        this.objectMapper.writerWithView(this.jsonView).with(schema).writeValue(stream, graph);
        if (this.contentTypeHeader) {
            exchange.getMessage().setHeader("Content-Type", this.getDefaultContentType());
        }
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        FormatSchema schema = null;
        if (this.schemaResolver != null) {
            schema = this.schemaResolver.resolve(exchange);
        }
        Class<?> clazz = this.unmarshalType;
        String type = null;
        if (this.allowUnmarshallType) {
            type = exchange.getIn().getHeader("CamelJacksonUnmarshalType", String.class);
        }
        if (type == null && this.isAllowJmsType()) {
            type = exchange.getIn().getHeader("JMSType", String.class);
        }
        if (type != null) {
            clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(type);
        }
        if (this.collectionType != null) {
            CollectionType collType = this.objectMapper.getTypeFactory().constructCollectionType(this.collectionType, clazz);
            return this.objectMapper.readerFor(collType).with(schema).readValue(stream);
        }
        return this.objectMapper.reader(schema).readValue(stream, clazz);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isUseDefaultObjectMapper() {
        return this.useDefaultObjectMapper;
    }

    public void setUseDefaultObjectMapper(boolean useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<? extends Collection> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<? extends Collection> collectionType) {
        this.collectionType = collectionType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getJsonViewTypeName() {
        return this.jsonViewTypeName;
    }

    public void setJsonViewTypeName(String jsonViewTypeName) {
        this.jsonViewTypeName = jsonViewTypeName;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public boolean isAllowJmsType() {
        return this.allowJmsType;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isUseList() {
        return this.useList;
    }

    public void setUseList(boolean useList) {
        this.useList = useList;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public String getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public String getModuleClassNames() {
        return this.moduleClassNames;
    }

    public void addModule(Module module) {
        if (this.modules == null) {
            this.modules = new ArrayList<Module>();
        }
        this.modules.add(module);
    }

    public void setModuleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
    }

    public String getModuleRefs() {
        return this.moduleRefs;
    }

    public void setModuleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public void useList() {
        this.setCollectionType(ArrayList.class);
    }

    public void useMap() {
        this.setCollectionType(null);
        this.setUnmarshalType(HashMap.class);
    }

    public void setAllowJmsType(boolean allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public boolean isEnableJacksonTypeConverter() {
        return this.enableJacksonTypeConverter;
    }

    public void setEnableJacksonTypeConverter(boolean enableJacksonTypeConverter) {
        this.enableJacksonTypeConverter = enableJacksonTypeConverter;
    }

    public boolean isAllowUnmarshallType() {
        return this.allowUnmarshallType;
    }

    public void setAllowUnmarshallType(boolean allowJacksonUnmarshallType) {
        this.allowUnmarshallType = allowJacksonUnmarshallType;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public boolean isAutoDiscoverObjectMapper() {
        return this.autoDiscoverObjectMapper;
    }

    public void setAutoDiscoverObjectMapper(boolean autoDiscoverObjectMapper) {
        this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
    }

    public SchemaResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public boolean isAutoDiscoverSchemaResolver() {
        return this.autoDiscoverSchemaResolver;
    }

    public void setAutoDiscoverSchemaResolver(boolean autoDiscoverSchemaResolver) {
        this.autoDiscoverSchemaResolver = autoDiscoverSchemaResolver;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public void enableFeature(SerializationFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void enableFeature(DeserializationFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void enableFeature(MapperFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void disableFeature(SerializationFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    public void disableFeature(DeserializationFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    public void disableFeature(MapperFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    @Override
    protected void doInit() throws Exception {
        if (this.unmarshalTypeName != null && (this.unmarshalType == null || this.unmarshalType == Object.class)) {
            this.unmarshalType = this.camelContext.getClassResolver().resolveClass(this.unmarshalTypeName);
        }
        if (this.jsonViewTypeName != null && this.jsonView == null) {
            this.jsonView = this.camelContext.getClassResolver().resolveClass(this.jsonViewTypeName);
        }
        if (this.collectionTypeName != null && this.collectionType == null) {
            Class<?> clazz = this.camelContext.getClassResolver().resolveClass(this.collectionTypeName);
            this.collectionType = CastUtils.cast(clazz);
        }
    }

    @Override
    protected void doStart() throws Exception {
        Set<Object> set;
        if (this.useList) {
            this.setCollectionType(ArrayList.class);
        }
        boolean objectMapperFoundRegistry = false;
        if (this.objectMapper == null) {
            if (this.useDefaultObjectMapper && this.camelContext != null) {
                if (this.isAutoDiscoverObjectMapper()) {
                    set = this.camelContext.getRegistry().findByType(this.getObjectMapperClass());
                    if (set.size() == 1) {
                        this.objectMapper = (ObjectMapper)set.iterator().next();
                        LOG.debug("Found single ObjectMapper in Registry to use: {}", (Object)this.objectMapper);
                        objectMapperFoundRegistry = true;
                    } else if (set.size() > 1) {
                        LOG.debug("Found {} ObjectMapper in Registry cannot use as default as there are more than one instance.", (Object)set.size());
                    }
                } else {
                    LOG.debug("The option autoDiscoverObjectMapper is set to false, Camel won't search in the registry");
                }
            }
            if (this.objectMapper == null) {
                this.objectMapper = this.createNewObjectMapper();
                LOG.debug("Creating new ObjectMapper to use: {}", (Object)this.objectMapper);
            }
        }
        if (!objectMapperFoundRegistry) {
            PropertyNamingStrategy selectedNamingStrategy;
            String name;
            MapperFeature mf;
            DeserializationFeature df;
            Iterable<String> it;
            if (this.include != null) {
                JsonInclude.Include inc = this.getCamelContext().getTypeConverter().mandatoryConvertTo(JsonInclude.Include.class, this.include);
                this.objectMapper.setSerializationInclusion(inc);
            }
            if (this.prettyPrint) {
                this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            }
            if (this.enableFeatures != null) {
                it = org.apache.camel.support.ObjectHelper.createIterator(this.enableFeatures);
                while (it.hasNext()) {
                    String enable = it.next().toString();
                    SerializationFeature serializationFeature = this.getCamelContext().getTypeConverter().tryConvertTo(SerializationFeature.class, enable);
                    if (serializationFeature != null) {
                        this.objectMapper.enable(serializationFeature);
                        continue;
                    }
                    df = this.getCamelContext().getTypeConverter().tryConvertTo(DeserializationFeature.class, enable);
                    if (df != null) {
                        this.objectMapper.enable(df);
                        continue;
                    }
                    mf = this.getCamelContext().getTypeConverter().tryConvertTo(MapperFeature.class, enable);
                    if (mf != null) {
                        this.objectMapper.enable(mf);
                        continue;
                    }
                    throw new IllegalArgumentException("Enable feature: " + enable + " cannot be converted to an accepted enum of types [SerializationFeature,DeserializationFeature,MapperFeature]");
                }
            }
            if (this.disableFeatures != null) {
                it = org.apache.camel.support.ObjectHelper.createIterator(this.disableFeatures);
                while (it.hasNext()) {
                    String disable = it.next().toString();
                    SerializationFeature serializationFeature = this.getCamelContext().getTypeConverter().tryConvertTo(SerializationFeature.class, disable);
                    if (serializationFeature != null) {
                        this.objectMapper.disable(serializationFeature);
                        continue;
                    }
                    df = this.getCamelContext().getTypeConverter().tryConvertTo(DeserializationFeature.class, disable);
                    if (df != null) {
                        this.objectMapper.disable(df);
                        continue;
                    }
                    mf = this.getCamelContext().getTypeConverter().tryConvertTo(MapperFeature.class, disable);
                    if (mf != null) {
                        this.objectMapper.disable(mf);
                        continue;
                    }
                    throw new IllegalArgumentException("Disable feature: " + disable + " cannot be converted to an accepted enum of types [SerializationFeature,DeserializationFeature,MapperFeature]");
                }
            }
            if (this.modules != null) {
                for (Module module : this.modules) {
                    LOG.debug("Registering module: {}", (Object)module);
                    this.objectMapper.registerModules(module);
                }
            }
            if (this.moduleClassNames != null) {
                it = org.apache.camel.support.ObjectHelper.createIterable(this.moduleClassNames);
                for (Object object : it) {
                    name = object.toString();
                    Class<Module> clazz = this.camelContext.getClassResolver().resolveMandatoryClass(name, Module.class);
                    Module module = this.camelContext.getInjector().newInstance(clazz);
                    LOG.debug("Registering module: {} -> {}", (Object)name, (Object)module);
                    this.objectMapper.registerModule(module);
                }
            }
            if (this.moduleRefs != null) {
                it = org.apache.camel.support.ObjectHelper.createIterable(this.moduleRefs);
                for (Object object : it) {
                    name = object.toString();
                    if (name.startsWith("#")) {
                        name = name.substring(1);
                    }
                    Module module = CamelContextHelper.mandatoryLookup(this.camelContext, name, Module.class);
                    LOG.debug("Registering module: {} -> {}", (Object)name, (Object)module);
                    this.objectMapper.registerModule(module);
                }
            }
            if (ObjectHelper.isNotEmpty(this.timezone)) {
                LOG.debug("Setting timezone to Object Mapper: {}", (Object)this.timezone);
                this.objectMapper.setTimeZone(this.timezone);
            }
            if (ObjectHelper.isNotEmpty(this.namingStrategy) && ObjectHelper.isNotEmpty(selectedNamingStrategy = this.determineNamingStrategy(this.namingStrategy))) {
                this.objectMapper.setPropertyNamingStrategy(selectedNamingStrategy);
            }
        } else {
            LOG.debug("The objectMapper was already found in the registry, no customizations will be applied");
        }
        if (this.schemaResolver == null && this.isAutoDiscoverSchemaResolver()) {
            if (this.camelContext != null) {
                set = this.camelContext.getRegistry().findByType(SchemaResolver.class);
                if (set.size() == 1) {
                    this.schemaResolver = (SchemaResolver)set.iterator().next();
                    LOG.debug("Found single SchemaResolver in Registry to use: {}", (Object)this.schemaResolver);
                } else if (set.size() > 1) {
                    LOG.debug("Found {} SchemaResolver in Registry cannot use as default as there are more than one instance.", (Object)set.size());
                }
            }
        } else {
            LOG.debug("The option autoDiscoverSchemaResolver is set to false, Camel won't search in the registry");
        }
    }

    private PropertyNamingStrategy determineNamingStrategy(String namingStrategy) {
        PropertyNamingStrategy strategy = null;
        switch (namingStrategy) {
            case "LOWER_CAMEL_CASE": {
                strategy = PropertyNamingStrategies.LOWER_CAMEL_CASE;
                break;
            }
            case "LOWER_DOT_CASE": {
                strategy = PropertyNamingStrategies.LOWER_DOT_CASE;
                break;
            }
            case "LOWER_CASE": {
                strategy = PropertyNamingStrategies.LOWER_CASE;
                break;
            }
            case "KEBAB_CASE": {
                strategy = PropertyNamingStrategies.KEBAB_CASE;
                break;
            }
            case "SNAKE_CASE": {
                strategy = PropertyNamingStrategies.SNAKE_CASE;
                break;
            }
            case "UPPER_CAMEL_CASE": {
                strategy = PropertyNamingStrategies.UPPER_CAMEL_CASE;
                break;
            }
        }
        return strategy;
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public abstract String getDataFormatName();

    protected abstract ObjectMapper createNewObjectMapper();

    protected abstract Class<? extends ObjectMapper> getObjectMapperClass();

    protected abstract String getDefaultContentType();
}

